/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 package_info.c - information about the current selected package

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "greeting.h"
#include "console.h"
#include "edit.h"
#include "text.h"
#include "package_info.h"


GtkWidget* w_package_info[W_PACKAGE_INFO_N];

static void info_changed(GtkTextBuffer* txt, gpointer user_data);

static void info_create_aux(int widx, char* markup, GtkWidget* tmp) {
  GtkWidget* tmp2;

  if (markup) {
    tmp2 = gtk_label_new(NULL);
    gtk_misc_set_alignment(GTK_MISC(tmp2), 0.0, 0.0);
    gtk_label_set_markup(GTK_LABEL(tmp2), markup);
    gtk_widget_set_size_request(tmp2, lw, -1);
    gtk_box_pack_start(GTK_BOX(tmp), tmp2, FALSE, FALSE, 0);
  }

  if (widx != -1) {
    w_package_info[widx] = text_new();
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(w_package_info[widx]), GTK_WRAP_CHAR);
    gtk_text_view_set_left_margin(GTK_TEXT_VIEW(w_package_info[widx]), bw / 2);
    gtk_text_view_set_right_margin(GTK_TEXT_VIEW(w_package_info[widx]), bw / 2);
    gtk_box_pack_start(GTK_BOX(tmp), w_package_info[widx], TRUE, TRUE, 0);
  }
}

static void info_create(int widx, char* markup) {
  GtkWidget* tmp;
  tmp = gtk_hbox_new(FALSE, 0);

  info_create_aux(widx, markup, tmp);
  gtk_box_pack_start(GTK_BOX(w_package_info[W_PACKAGE_INFO_NEDITABLE]), tmp, FALSE, FALSE, 0);

  if (widx != -1) {
    gtk_text_view_set_editable(GTK_TEXT_VIEW(w_package_info[widx]), FALSE);
  }
}

static void info_create_editable(int widx, char* markup) {
  GtkTextBuffer* txt;
  GtkWidget* tmp;
  tmp = gtk_hbox_new(FALSE, 0);

  info_create_aux(widx, markup, tmp);
  gtk_box_pack_start(GTK_BOX(w_package_info[W_PACKAGE_INFO_EDITABLE]), tmp, FALSE, FALSE, 0);
  gtk_text_view_set_editable(GTK_TEXT_VIEW(w_package_info[widx]), TRUE);
  txt = gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_package_info[widx]));
  
  g_signal_connect(G_OBJECT(txt), "changed",
		   G_CALLBACK(info_changed), w_package_info[widx]);
}

static void info_set(int widx, char* text) {
  GtkTextBuffer* txt;
  GtkTextIter start;
  GtkTextIter end;
  const GdkColor color = { 0, 0, 0, 0 };

  txt = gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_package_info[widx]));
  g_signal_handlers_block_by_func(G_OBJECT(txt), G_CALLBACK(info_changed), w_package_info[widx]);

  gtk_text_buffer_get_start_iter(txt, &start);
  gtk_text_buffer_get_end_iter(txt, &end);

  gtk_text_buffer_delete(txt, &start, &end);
  gtk_text_buffer_get_end_iter(txt, &end);

  if (text)
    gtk_text_buffer_insert(txt, &end, text, strlen(text));

  gtk_widget_modify_text(w_package_info[widx], GTK_STATE_NORMAL, &color);
  
  g_signal_handlers_unblock_by_func(G_OBJECT(txt), G_CALLBACK(info_changed), w_package_info[widx]);
}

static void info_mode_normal(void) {
  if (GTK_WIDGET_VISIBLE(w_edit[W_EDIT]))
    gtk_widget_hide_all(w_edit[W_EDIT]);
  
  if (!GTK_WIDGET_VISIBLE(w_package_info[W_PACKAGE_INFO_NEDITABLE]))
    gtk_widget_show_all(w_package_info[W_PACKAGE_INFO_NEDITABLE]);
}

static void info_mode_edit(GtkWidget* widget) {
  const GdkColor color = { 0, 0, 0, 65535 };

  gtk_widget_modify_text(widget, GTK_STATE_NORMAL, &color);

  if (!GTK_WIDGET_VISIBLE(w_edit[W_EDIT]))
    gtk_widget_show_all(w_edit[W_EDIT]);
  
  if (GTK_WIDGET_VISIBLE(w_package_info[W_PACKAGE_INFO_NEDITABLE]))
    gtk_widget_hide_all(w_package_info[W_PACKAGE_INFO_NEDITABLE]);
}

static void info_changed(GtkTextBuffer* txt, gpointer user_data) {
  info_mode_edit(GTK_WIDGET(user_data));
}

void package_info_create(void) {
  GtkWidget* vbox;

  w_package_info[W_PACKAGE_INFO] = gtk_scrolled_window_new(NULL, NULL);
  
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(w_package_info[W_PACKAGE_INFO]),
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), bw);

  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(w_package_info[W_PACKAGE_INFO]), vbox);

  w_package_info[W_PACKAGE_INFO_EDITABLE] = gtk_vbox_new(FALSE, bw / 2);
  gtk_box_pack_start(GTK_BOX(vbox), w_package_info[W_PACKAGE_INFO_EDITABLE], FALSE, FALSE, 0);

  w_package_info[W_PACKAGE_INFO_NEDITABLE] = gtk_vbox_new(FALSE, bw / 2);
  gtk_box_pack_start(GTK_BOX(vbox), w_package_info[W_PACKAGE_INFO_NEDITABLE], FALSE, FALSE, bw * 2);

  info_create_editable(W_PACKAGE_INFO_NAME, "<b>Package name:</b>");
  info_create_editable(W_PACKAGE_INFO_DESC, "<b>Description:</b>");
  info_create_editable(W_PACKAGE_INFO_DESC_LONG, 0);
  
  edit_create();
  gtk_box_pack_start(GTK_BOX(w_package_info[W_PACKAGE_INFO_EDITABLE]), w_edit[W_EDIT], FALSE, FALSE, 0);

  info_create(W_PACKAGE_INFO_PREFIX, "<b>Installation prefix:</b>");
  info_create(W_PACKAGE_INFO_CONF, "<b>Configured as:</b>");
  info_create(W_PACKAGE_INFO_SRC, "<b>Source available:</b>");
  info_create(W_PACKAGE_INFO_SRC_LOC, "<b>Source location:</b>");
  info_create(W_PACKAGE_INFO_SRC_SIZE, "<b>Source size(KB):</b>");
  info_create(W_PACKAGE_INFO_SUBDIR, "<b>Build subdir:</b>");
  info_create(W_PACKAGE_INFO_INST, "<b>Installed:</b>");
  info_create(W_PACKAGE_INFO_INST_SIZE, "<b>Installed size(KB):</b>");
  info_create(W_PACKAGE_INFO_CHECK, "<b>Installed files check:</b>");
  info_create(W_PACKAGE_INFO_FILES, 0);
}

void package_info_show(void) {
  /* assert(current_package != 0); */
  char* name, *descr, *descr_long, *configured_as;
  char* offstr;
  int src_available;
  char* src_location;
  off_t src_size;
  char* subdir;
  
  int installed;
  off_t installed_size;
  char* installed_prefix;

  int check; struct srcinst_string_list* list;
  
  name = srcinst_get_name(state.package);

  greeting_hide();
  console_hide();

  info_set(W_PACKAGE_INFO_NAME, name);

  descr = srcinst_get_descr(state.package);
  info_set(W_PACKAGE_INFO_DESC, descr);

  descr_long = srcinst_get_descr_long(state.package);
  info_set(W_PACKAGE_INFO_DESC_LONG, descr_long);

  configured_as = srcinst_get_configure_string(state.package);
  info_set(W_PACKAGE_INFO_CONF, configured_as);

  src_available = srcinst_is_source_available(state.package);
  info_set(W_PACKAGE_INFO_SRC, src_available ? "yes" : "no");

  src_location = srcinst_get_source_location(state.package);
  info_set(W_PACKAGE_INFO_SRC_LOC, src_location);

  if ((src_size = srcinst_get_source_size(state.package)) != (off_t)-1)
    offstr = srcinst_offtostr(src_size);
  else
    offstr = 0;
  
  info_set(W_PACKAGE_INFO_SRC_SIZE, offstr);

  if (offstr)
    free(offstr);
  
  subdir = srcinst_get_build_subdir(state.package);
  info_set(W_PACKAGE_INFO_SUBDIR, subdir);

  installed = srcinst_is_installed(state.package);
  info_set(W_PACKAGE_INFO_INST, installed ? "yes" : "no");

  installed_size = srcinst_get_installed_size(state.package);
  if (installed_size != (off_t)-1)
    offstr = srcinst_offtostr(installed_size);
  else
    offstr = 0;

  info_set(W_PACKAGE_INFO_INST_SIZE, offstr);

  if (offstr)
    free(offstr);

  installed_prefix = srcinst_get_prefix(state.package);
  info_set(W_PACKAGE_INFO_PREFIX, installed_prefix);

  list = srcinst_get_installed_files(state.package);
  info_set(W_PACKAGE_INFO_FILES, 0);

  check = 1;			/* file check starts ok */

  if (list->count > 0) {
    int i; GtkTextView* view;

    view = GTK_TEXT_VIEW(w_package_info[W_PACKAGE_INFO_FILES]);
    
    for (i = 0; i < list->count; i++) {
      int missing;
      missing = srcinst_file_ltype(list->strings[i]) == SRCINST_TYPE_NONE;
      if (missing) check = 0;
      text_print(view, list->strings[i], missing ? TAG_STDERR : TAG_NONE);

      if (i < list->count - 1)
	text_print(view, "\n", TAG_NONE);
    }
  }

  info_set(W_PACKAGE_INFO_CHECK, list->count == 0 ? "no information" :
	   check ? "all files ok" : "missing files detected");

  if (!check) {
    const GdkColor color_err = { 0, 65535, 0, 0 };
    gtk_widget_modify_text(w_package_info[W_PACKAGE_INFO_CHECK],
			   GTK_STATE_NORMAL, &color_err);
  }
  
  if (!GTK_WIDGET_VISIBLE(w_package_info[W_PACKAGE_INFO]))
    gtk_widget_show_all(w_package_info[W_PACKAGE_INFO]);

  info_mode_normal();
  gui_update();
}

void package_info_hide(void) {
  if (GTK_WIDGET_VISIBLE(w_package_info[W_PACKAGE_INFO]))
    gtk_widget_hide_all(w_package_info[W_PACKAGE_INFO]);
}

