/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 package_list.c - the widget holding all the package names

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "menu.h"
#include "dialog.h"
#include "greeting.h"
#include "package_info.h"
#include "package_list.h"

GtkWidget* w_package_list[W_PACKAGE_LIST_N];
struct srcinst_string_list package_list;

/*
static gboolean package_list_strcmp(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer search_data) {
  gboolean result;
  char* value;
  gtk_tree_model_get(model, iter, column, &value, -1);

  result = strcmp(key, value) == 0 ? FALSE : TRUE;
  free(value);
  return result;
}
*/

void package_list_create(void) {
  GtkTreeView* tree; GtkTreeSelection* sel; GtkListStore* model;
  GtkTreeViewColumn* column; GtkCellRenderer* renderer;

  srcinst_init_string_list(&package_list);

  model = gtk_list_store_new(1, G_TYPE_STRING);
  
  w_package_list[W_PACKAGE_LIST] = gtk_tree_view_new_with_model(GTK_TREE_MODEL(model));
  tree = GTK_TREE_VIEW(w_package_list[W_PACKAGE_LIST]);
  sel = gtk_tree_view_get_selection(tree);
  gtk_tree_selection_set_mode(sel, GTK_SELECTION_SINGLE);
  
  gtk_tree_view_set_search_column(tree, 0);
  gtk_tree_view_set_enable_search(tree, TRUE);
  gtk_tree_view_set_headers_visible(tree, FALSE);

  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Packages", renderer,
						    "text", 0, NULL);
  gtk_tree_view_append_column(tree, column);

  w_package_list[W_PACKAGE_LIST_SCR] = gtk_scrolled_window_new(NULL, NULL);

  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(w_package_list[W_PACKAGE_LIST_SCR]), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(w_package_list[W_PACKAGE_LIST_SCR]), w_package_list[W_PACKAGE_LIST]);
}

void package_list_fill(void) {
  int i;
  GtkTreeView* tree; GtkListStore* model; GtkTreeIter end;
  
  printf("package_list_fill\n");

  if (package_list.count > 0)
    srcinst_free_string_list(&package_list);

  srcinst_init_string_list(&package_list);
  srcinst_list_packages(&package_list);

  tree = GTK_TREE_VIEW(w_package_list[W_PACKAGE_LIST]);
  model = GTK_LIST_STORE(gtk_tree_view_get_model(tree));

  gtk_list_store_clear(model);

  for (i = 0; i < package_list.count; i++) {
    gtk_list_store_append(model, &end);
    gtk_list_store_set(model, &end, 0, package_list.strings[i], -1);
  }
}

void package_list_update(void) {
  /* update list basing on current state */

  gtk_widget_set_sensitive(w_package_list[W_PACKAGE_LIST],
			   state.actions_locked ? FALSE : TRUE);
}


void package_list_row_activated(GtkTreeView* tree, GtkTreePath* path, GtkTreeViewColumn* column, gpointer user_data) {
  GtkTreeSelection* sel;

  printf("package_list_row_activated\n");
  sel = gtk_tree_view_get_selection(tree);
  gtk_tree_selection_select_path(sel, path);
  package_list_cursor_changed(tree, NULL);
}

void package_list_cursor_changed(GtkTreeView* tree, gpointer user_data) { 
  GtkTreeSelection* sel; GtkTreeModel* model; GtkTreeIter this;
  gchar* text;
  char* title = "Package selection";

  printf("package_list_cursor_changed\n");
  
  sel = gtk_tree_view_get_selection(tree);

  if (gtk_tree_selection_get_selected(sel, &model, &this) == FALSE) {
    printf("no packages selected\n");

    if (state.package != 0) { 
      printf("package unselected (deselected), must close\n");

      if (!srcinst_close_package(state.package)) {
	dialog_warning(title, "Error closing package", "Unexpected error closing current package. This is probably a bug you should report to " PACKAGE_BUGREPORT, 0);
      }
      state.package = 0;
    }
    greeting_show();
    return;
  }

  printf("package selected\n");
  
  if (state.package != 0) {
    printf("change package, must close previous\n");

    if (!srcinst_close_package(state.package)) {
      dialog_warning(title, "Error closing package", "Unexpected error changing current package. This is probably a bug you should report to " PACKAGE_BUGREPORT, 0);
    }
    state.package = 0;
  }

  gtk_tree_model_get(model, &this, 0, &text, -1);
  
  if (!(state.package = srcinst_open_package(text))) {
    dialog_warning(title, "Could not open package", "Failed to open package", text);
  } else {
    package_info_show();
  }

  free(text);
}

gboolean package_list_popup_menu(GtkWidget* widget, gpointer user_data) {
  printf("package_list_popup_menu\n");

  menu_popup(0, gtk_get_current_event_time());
  return TRUE;
}

gboolean package_list_button_press_event(GtkWidget* widget, GdkEventButton* event, gpointer user_data) {
  printf("package_list_button_pressed\n");

  if (event->type != GDK_BUTTON_PRESS || event->button != 3)
    return FALSE;
  
    /* only handle single right mouse click */
  
  menu_popup(event->button, event->time);
  return TRUE;
}

