/* Source Installer, Copyright (c) 2005 Claudio Fontana

 actions.h - actions implementation

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef SRCINST_ACTIONS_H
#define SRCINST_ACTIONS_H

struct _makefile_feature {
  char* pattern;
  int supported;
};

struct _makefile_features {
  struct _makefile_feature features[SRCINST_FEATURE_N];
};

SRCINST_ERR _action_init_build(struct _package_info* info, char* fn, char* subdir);
SRCINST_ERR _action_chdir_build(struct _package_info* info, char* subdir);
SRCINST_ERR _action_fini_build(struct _package_info* info);
SRCINST_ERR _action_install_binary(struct _package_info* i, int strip, int force);
SRCINST_ERR _action_install_source(struct _package_info* i, SRCINST_COMP format);
SRCINST_ERR _action_uninstall_binary(struct _package_info* info);
SRCINST_ERR _action_uninstall_source(struct _package_info* info);

SRCINST_ERR _action_find_configure(struct _package_info* i, struct srcinst_string_list* scripts);
SRCINST_ERR _action_configure(struct _package_info* i, char* prefix, struct srcinst_string_list* argv);
struct _makefile_features* _action_detect_makefile_features(struct _package_info* i);
SRCINST_ERR _action_detect_configure_opt(struct _package_info* i, struct srcinst_configure_sets* sets);
void _action_free_configure_opt(struct srcinst_configure_sets* sets);
SRCINST_ERR _action_detect_autoconf(struct _package_info* i, float* version);
SRCINST_ERR _action_rename_package(struct _package_element* e, char* newname);

/* decide what to do based on current state */
int _update_package(struct _package_list* l, struct _package_element* e);

/* detect a configure script, running autogen scripts if necessary. */

int _detect_configure(void);

/* check whether build is ready, and init it if not. Return 1 = ok, 0 = err */
int _check_build_ready(struct _package_info* i);

/* clear and recreate builddirs */
int _clear_builddirs(void);

#endif
