#!/usr/bin/env python

# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

import sys, re, string

s = sys.stdin.read()

versionline = re.compile("^\d+\.\d+\.\d+.*?\n", re.MULTILINE)
versionline = re.compile("^\d+\.\d+.*?\n", re.MULTILINE)
r = re.compile("^\s*\*", re.MULTILINE)
heading = re.compile("(----*)([^-]+.*?)(----*)", re.MULTILINE)
in_list = 0
while 1:
    m = versionline.search(s)
    if not m:
        break
    if not in_list:
        rp = "<strong>" + m.group() + "</strong><ul>\n"
    else:
        rp = "</ul><strong>" + m.group() + "</strong><ul>\n"
    in_list = 1
    s = s[:m.start()] + rp + s[m.end():]

while 1:
    m = heading.search(s)
    if not m:
        break
    s = s[:m.start()] + "<h1>" + m.groups()[1] + "</h1>" + s[m.end():]

s = r.sub("<li>", s)
print "<html><body>", s, "</ul></body></html>"

