#------------------------------>  Tcl - script  <-----------------------------#
#- Copyright (C) 199x by International Computer Science Institute            -#
#- This file is part of the GNU Sather package. It is free software; you may -#
#- redistribute  and/or modify it under the terms of the  GNU General Public -#
#- License (GPL)  as  published  by the  Free  Software  Foundation;  either -#
#- version 2 of the license, or (at your option) any later version.          -#
#- This  program  is distributed  in the  hope that it will  be  useful, but -#
#- WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY -#
#- or FITNESS FOR A PARTICULAR PURPOSE. See Doc/GPL for more details.        -#
#- The license text is also available from:  Free Software Foundation, Inc., -#
#- 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     -#
#------------->  Please email comments to <bug-sather@gnu.org>  <-------------#

#         This is the Sather interface startup file for using Tcl/Tk. This is
#    a version of the standard tcl/tk initialization. To avoid having to search
#    for the standard initialization files which seem to vary widely from one
#    system to another, both in name and locations, they have been copied
#    as tk-system-init.tcl and tcl-system-init.tcl in this directory.

#         If you wish to use specialised forms of these for your system then
#    you should alter the sourceSystemFile calls near the end of this file
#    as necessary.


################
# The following is just a hack that works for me - I have no idea how to
# make it portable - Norbert Nemec <nobbi@gnu.org>
#
set tcl_library "/usr/lib/tcl8.2"
set tk_library "/usr/lib/tk8.2"


set gCurrentlyLoading ""
set satherHomeEnvVars [array names env SATHER_HOME]

     if { ${satherHomeEnvVars} != "" } {
          set sHome $env(SATHER_HOME)
          } else {
          puts "ERROR::The environment variable SATHER_HOME not set!"
          }





proc sourceSystemFile { gname} {
     global gCurrentlyLoading
     global sHome
     set gCurrentlyLoading ${gname}

     if ![file exists ${gCurrentlyLoading} ] {
          puts "ERROR:The tcl/tk startup file: ${gCurrentlyLoading} was not found"
          puts "Try editing \$SATHER_HOME/tcltk/startup.tcl and try again"
          }

     set res [catch { uplevel #0 {source "${gCurrentlyLoading}" } } srcErr]

     if { ${res} != 0 } {
          puts "ERROR: startup.tcl cannot load ${gname} - error ${srcErr}"
          puts "     error occured on start-up. Please see:"
          puts "          \$SATHER_HOME/tcltk/startup.tcl"
          }
     }


sourceSystemFile "${sHome}/tcltk/tcl-system-init.tcl"
sourceSystemFile "${sHome}/tcltk/tk-system-init.tcl"

# Specify an icon for the root window. Some window managers need this

# iconmask . "@${sHome}/tcltk/sathermask.xbm"
# iconbitmap . "@${sHome}/tcltk/sather.xbm"

