## Copyright (C) 1994, 1995, 1996, 1997, 1998, 1999, 2005, 2006, 2007
##               John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or (at
## your option) any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, see
## <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {} gray (@var{n})
## Return a gray colormap with @var{n} entries corresponding to values from
## 0 to @var{n}-1.  The argument @var{n} should be a scalar.  If it is
## omitted, the length of the current colormap or 64 is assumed.
## @end deftypefn

## Author: Tony Richardson <arichard@stark.cc.oh.us>
## Created: July 1994
## Adapted-By: jwe

function map = gray (number)

  if (nargin == 0)
    number = rows (colormap);
  elseif (nargin == 1)
    if (! isscalar (number))
      error ("gray: argument must be a scalar");
    endif
  else
    print_usage ();
  endif

  gr = [0:(number-1)]';

  map = [ gr, gr, gr ] / (number - 1);

endfunction
