
/* ====================================================
   created by Isaac Tsai, 1997
   randomized labeling of a figure applet
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

<CENTER>

<APPLET CODE=GLabel.class CODEBASE=JAVA/Class width=550 height=304>
<PARAM NAME="BGIMG" VALUE="path/to/background.gif">
<PARAM NAME="GRID"  VALUE="10">
<PARAM NAME="COUNT" VALUE="7">
<PARAM NAME="LB0" VALUE="X">
<PARAM NAME="X0" VALUE="16">
<PARAM NAME="Y0" VALUE="242">
<PARAM NAME="LB1" VALUE="Y">
<PARAM NAME="X1" VALUE="144">
<PARAM NAME="Y1" VALUE="288">
<PARAM NAME="LB2" VALUE="3">
<PARAM NAME="X2" VALUE="317">
<PARAM NAME="Y2" VALUE="193">
<PARAM NAME="LB3" VALUE="4">
<PARAM NAME="X3" VALUE="524">
<PARAM NAME="Y3" VALUE="154">
<PARAM NAME="LB4" VALUE="5">
<PARAM NAME="X4" VALUE="309">
<PARAM NAME="Y4" VALUE="30">
<PARAM NAME="LB5" VALUE="6">
<PARAM NAME="X5" VALUE="224">
<PARAM NAME="Y5" VALUE="45">
<PARAM NAME="LB6" VALUE="7">
<PARAM NAME="X6" VALUE="49">
<PARAM NAME="Y6" VALUE="106">
<PARAM NAME="ICOUNT" VALUE="2">
<PARAM NAME="IMG0" VALUE="path/to/image0.gif">
<PARAM NAME="IX0" VALUE="106">
<PARAM NAME="IY0" VALUE="106">
<PARAM NAME="IMG1" VALUE="path/to/image1.gif">
<PARAM NAME="IX1" VALUE="106">
<PARAM NAME="IY1" VALUE="106">
</APPLET>

</CENTER>
< APPLET
            [CODEBASE = codebaseURL]
            CODE = appletFile 
            [ALT = alternateText]
            [NAME = appletInstanceName]
            WIDTH = pixels
            HEIGHT = pixels 
            [ALIGN = alignment] 
            [VSPACE = pixels]
            [HSPACE = pixels]
        >
        [< PARAM NAME = appletParameter1 VALUE = value >]
        [< PARAM NAME = appletParameter2 VALUE = value >]
        . . .
        [alternateHTML]
        </APPLET>

*/

import java.applet.*;
import java.awt.*;
import java.lang.*;
import java.util.*;
import java.net.*;

public class GLabel extends Applet implements Runnable
{

 public int     Xcord[];
 public int     Ycord[];
 public String  sLabel[];
 public Image   iImg[];
 public int     iX[];
 public int     iY[];
 
 public int     label_cnt;
 public int     img_cnt;
 public int     fsize;
 public int     show_grid;
 public int     grid_ww;
 public Image   img;
 public Font    f16;

public void init()
 {
   int      count, idx;
   String   p, q;
   URL      f_url=null;
   
   Xcord = new int[64]; Ycord = new int[64];
   sLabel = new String[64];
   iImg = new Image[64];
   iX = new int[64]; iY = new int[64];
   
   show_grid = 0;
   f16 = new Font("TimesRoman",Font.PLAIN,16);
   
   p=getParameter("COUNT");
   label_cnt=(p==null)?1:Integer.valueOf(p).intValue();

   for(idx=0;idx<label_cnt;idx++){
     q = "LB" + idx;
     sLabel[idx] = getParameter(q);
     q = "X" + idx;
     p = getParameter(q);
     Xcord[idx]=(p==null)?20:Integer.valueOf(p).intValue();
     q = "Y" + idx;
     p = getParameter(q);
     Ycord[idx]=(p==null)?30:Integer.valueOf(p).intValue();
     // System.out.println("X= "+Xcord[idx]+" Y= "+Ycord[idx]+" L= "+sLabel[idx]);
   }
   
   p=getParameter("ICOUNT");
   img_cnt=(p==null)?0:Integer.valueOf(p).intValue();
   for(idx=0;idx<img_cnt;idx++){
     q = "IMG" + idx;
     p = getParameter(q);
     if(p != null) {
     try {
          System.out.print("URL=" + p + "\n");
          f_url = new URL(p);
     } 
     catch (MalformedURLException exc) {
          System.out.print("Malformed URL=" + p + "\n");
       }
       iImg[idx] = getImage(f_url);
     }
     q = "IX" + idx;
     p = getParameter(q);
     iX[idx]=(p==null)?20:Integer.valueOf(p).intValue();
     q = "IY" + idx;
     p = getParameter(q);
     iY[idx]=(p==null)?30:Integer.valueOf(p).intValue();
     // System.out.println("X= "+Xcord[idx]+" Y= "+Ycord[idx]+" L= "+sLabel[idx]);
   }
   
   
   
   p=getParameter("BGIMG");
   if(p != null) {
     try {
          System.out.print("URL=" + p + "\n");
          f_url = new URL(p);
     } 
     catch (MalformedURLException exc) {
          System.out.print("Malformed URL=" + p + "\n");
     }
     img = getImage(f_url);
   }
   p=getParameter("FSIZE");
   fsize=(p==null)?16:Integer.valueOf(p).intValue();
   p=getParameter("GRID");
   if(p != null) {
       grid_ww=Integer.valueOf(p).intValue();
       show_grid = 1;
   }
   f16 = new Font("TimesRoman",Font.BOLD,fsize);
 }
 
public void paint(Graphics g)
 {
   int        idx; 
   Dimension  d = getSize();
   int        appw = d.width;
   int        apph = d.height;
   int        x1,y1,x2,y2;
   
    g.setFont(f16);
    if( img != null ) {
       g.drawImage(img, 0, 0, this);
    } else {
       g.setColor(Color.white);
       g.fillRect(0, 0, appw, apph);
    }
    
    for(idx=0;idx<img_cnt;idx++){
      if( iImg[idx] != null ) {
        g.drawImage(iImg[idx], iX[idx],iY[idx], this);
      } else {
        g.setColor(Color.white);
        g.fillRect(iX[idx], iY[idx], appw, apph);
      }
    }
    
    
    
    g.setColor(Color.black);
    for(idx=0;idx<label_cnt;idx++){
      g.drawString(sLabel[idx],Xcord[idx],Ycord[idx]);
    }
    if((show_grid == 1) && (grid_ww>1)) {
      for(x1=0,y1=0,y2=apph;x1<=appw;x1=x1+grid_ww) {
        x2=x1;
        g.drawLine(x1,y1,x2,y2);
      }
      for(x1=0,y1=0,x2=appw;y1<=apph;y1=y1+grid_ww) {
        y2=y1;
        g.drawLine(x1,y1,x2,y2);
      }
    }
 }
public void run()   { }
public void start() { }
public void stop()  { }

}

