/* -*-c-*- -------------- mixgtk_fontsel.c :
 * Implementation of the functions declared in mixgtk_fontsel.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-05-10 23:37:14 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <mixlib/mix.h>
#include "mixgtk_widgets.h"
#include "mixgtk_config.h"
#include "mixgtk_fontsel.h"

static GtkWidget *fontsel_dialog_ = NULL;
static mixgtk_widget_id_t widget_;
static GHashTable *winfo_ = NULL;

typedef struct winfo
{
  GtkWidget *widget;
  GtkStyle *style;
  const gchar *font;
  const gchar *key;
} winfo;

static mixgtk_widget_id_t widget_ids_[] = {
  MIXGTK_WIDGET_MIXVM,
  MIXGTK_WIDGET_PROMPT,
  MIXGTK_WIDGET_LOG,
  MIXGTK_WIDGET_MIXAL,
  MIXGTK_WIDGET_DEVICE
};

static const gchar *keys_[] = {
  "MIX.font", "Prompt.font", "Log.font", "MIXAL.font", "Device.font"
};


#define WIDGET_NO_  (sizeof (widget_ids_) / sizeof (widget_ids_[0]))

static winfo infos_[WIDGET_NO_];

/* initialise the font selection dialog */
static void
init_fontsel_ (void) 
{
  fontsel_dialog_ = mixgtk_widget_factory_get_dialog (MIXGTK_FONTSEL_DIALOG);
  g_assert (fontsel_dialog_ != NULL);
}

void
change_font_ (mixgtk_widget_id_t widget)
{
  winfo *info;
  if (!fontsel_dialog_) init_fontsel_ ();
  info = (winfo *) g_hash_table_lookup (winfo_,	GINT_TO_POINTER (widget));
  g_assert (info);
  widget_ = widget;
  if (info->font)
    gtk_font_selection_dialog_set_font_name
      (GTK_FONT_SELECTION_DIALOG (fontsel_dialog_), info->font);
  
  gtk_widget_show (fontsel_dialog_);

}

void
mixgtk_fontsel_load_defaults (void)
{
  int i;
  winfo_ = g_hash_table_new (NULL, NULL);
  for (i = 0; i < WIDGET_NO_; ++i)
    {
      infos_[i].widget = mixgtk_widget_factory_get (widget_ids_[i]);
      g_assert (infos_[i].widget != NULL);
      infos_[i].style = gtk_style_copy
	(gtk_widget_get_style (infos_[i].widget));
      gtk_widget_set_style (infos_[i].widget, infos_[i].style);
      if (widget_ids_[i] == MIXGTK_WIDGET_MIXVM)
	{
	  int k;
	  for (k = MIXGTK_WIDGET_rA; k <= MIXGTK_WIDGET_UPTIME; ++k)
	    gtk_widget_set_style (mixgtk_widget_factory_get (k),
				  infos_[i].style);
	}
      infos_[i].key = keys_[i];
      infos_[i].font = mixgtk_config_get (keys_[i]);
      g_hash_table_insert (winfo_, GINT_TO_POINTER (widget_ids_[i]),
			   (gpointer)(infos_ + i));
      if (infos_[i].font)
	{
	  mixgtk_fontsel_set (widget_ids_[i], infos_[i].font);
	}
    }
}

void
mixgtk_fontsel_set (mixgtk_widget_id_t widget, const gchar *font)
{
  winfo *w = (winfo *)
    g_hash_table_lookup (winfo_, GINT_TO_POINTER (widget));
  if (w != NULL && font != NULL)
    {
      GdkFont *f = gdk_font_load (font);
      if (f != NULL)
	{
	  gdk_font_unref (w->style->font);
	  w->style->font = f;
	  w->font = font;
	  gtk_widget_draw (w->widget, NULL);

	  if (widget == MIXGTK_WIDGET_MIXVM)
	    {
	      int k;
	      for (k = MIXGTK_WIDGET_rA; k <= MIXGTK_WIDGET_UPTIME; ++k)
		gtk_widget_draw (mixgtk_widget_factory_get (k), NULL);
	    }
	}
      mixgtk_config_update (w->key, w->font);
    }

}

const gchar *
mixgtk_fontsel_get (mixgtk_widget_id_t widget)
{
  const gchar *result = NULL;
  winfo *w = (winfo *)
    g_hash_table_lookup (winfo_, GINT_TO_POINTER (widget));
  if (w != NULL) result = w->font;
  return result;
}

/* callbacks */
void
on_log_font_activate (void)
{
  change_font_ (MIXGTK_WIDGET_LOG);
}

void
on_mixal_font_activate (void)
{
  change_font_ (MIXGTK_WIDGET_MIXAL);
}

void
on_prompt_font_activate (void)
{
  change_font_ (MIXGTK_WIDGET_PROMPT);
}

void
on_mix_font_activate (void) 
{
  change_font_ (MIXGTK_WIDGET_MIXVM);
}

void
on_devices_font_activate (void) 
{
  change_font_ (MIXGTK_WIDGET_DEVICE);
}

void
on_fontsel_apply_clicked (void)
{
  const gchar * name = gtk_font_selection_dialog_get_font_name
    (GTK_FONT_SELECTION_DIALOG (fontsel_dialog_));
  mixgtk_fontsel_set (widget_, name);
}

void
on_fontsel_ok_clicked (void)
{
  on_fontsel_apply_clicked ();
  gtk_widget_hide (fontsel_dialog_);
}

void
on_fontsel_cancel_clicked (void)
{
  gtk_widget_hide (fontsel_dialog_);
}


