/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999-2001 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Kilburn Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/

#ifndef _MAV_NAVIGATION_INCLUDE
#define _MAV_NAVIGATION_INCLUDE

#ifdef __cplusplus
extern "C" {
#endif

/* Navigators */

typedef void (*MAV_navigatorFn)(MAV_viewParams *, float, float, float);

void mav_navigate(MAV_navigatorFn fn, MAV_viewParams *vp, float am, float ls, float as);

void mav_navigateNull(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateTransX(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateTransY(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateTransZ(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateRotRight(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateRotUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateForwards(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateUpFixedUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateRight(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateForwardsFixedUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateTransForwardsFixedUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateRightFixedUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateRoll(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigatePitch(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateYaw(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigateYawFixedUp(MAV_viewParams *vp, float am, float ls, float as);
void mav_navigatePitchFixedUp(MAV_viewParams *vp, float am, float ls, float as);



/* Mouse and keyboard navigation */

void mav_navigationMouse(MAV_window *w, MAV_callbackMouseFn fn);
int  mav_navigationMouseDefault(MAV_object *obj, MAV_mouseEvent *ev);
void mav_navigationMouseDefaultParams(MAV_window *w, int but, MAV_navigatorFn x, float xls, float xas, 
				      MAV_navigatorFn y, float yls, float yas);

void mav_navigationKeyboard(MAV_window *w, MAV_callbackKeyboardFn fn);
int  mav_navigationKeyboardDefault(MAV_object *obj, MAV_keyboardEvent *ke);
void mav_navigationKeyboardDefaultParams(MAV_window *w, float am, float ls, float as);

extern int mav_navigating;
extern int mav_opt_navPassEvents;



/* Module initialise */

int mav_navigationModuleInit(void);
char *mav_navigationModuleID(void);

#ifdef __cplusplus
}
#endif
#endif
