/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.SourceError;
import gnu.text.SourceLocator;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SourceMessages
implements SourceLocator {
    private int errorCount = 0;
    SourceError firstError;
    SourceError lastError;
    SourceLocator locator;
    String current_filename;
    int current_line;
    int current_column;
    public static boolean debugStackTraceOnWarning = false;
    public static boolean debugStackTraceOnError = false;
    SourceError lastPrevFilename = null;
    public boolean sortMessages;

    public SourceError getErrors() {
        return this.firstError;
    }

    public boolean seenErrors() {
        return this.errorCount > 0;
    }

    public boolean seenErrorsOrWarnings() {
        return this.firstError != null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void clearErrors() {
        this.errorCount = 0;
    }

    public void clear() {
        this.lastError = null;
        this.firstError = null;
        this.errorCount = 0;
    }

    public void error(SourceError sourceError) {
        if (sourceError.severity == 'f') {
            this.errorCount = 1000;
        } else if (sourceError.severity != 'w') {
            ++this.errorCount;
        }
        if (debugStackTraceOnError && (sourceError.severity == 'e' || sourceError.severity == 'f') || debugStackTraceOnWarning && sourceError.severity == 'w') {
            sourceError.fakeException = new Throwable();
        }
        if (this.lastError != null && this.lastError.filename != null && !this.lastError.filename.equals(sourceError.filename)) {
            this.lastPrevFilename = this.lastError;
        }
        SourceError sourceError2 = this.lastPrevFilename;
        if (!this.sortMessages || sourceError.severity == 'f') {
            sourceError2 = this.lastError;
        } else {
            SourceError sourceError3;
            while ((sourceError3 = sourceError2 == null ? this.firstError : sourceError2.next) != null && (sourceError.line == 0 || sourceError3.line == 0 || sourceError.line >= sourceError3.line && (sourceError.line != sourceError3.line || sourceError.column == 0 || sourceError3.column == 0 || sourceError.column >= sourceError3.column))) {
                sourceError2 = sourceError3;
            }
        }
        if (sourceError2 == null) {
            sourceError.next = this.firstError;
            this.firstError = sourceError;
        } else {
            sourceError.next = sourceError2.next;
            sourceError2.next = sourceError;
        }
        if (sourceError2 == this.lastError) {
            this.lastError = sourceError;
        }
    }

    public void error(char c, String string, int n, int n2, String string2) {
        this.error(new SourceError(c, string, n, n2, string2));
    }

    public void error(char c, SourceLocator sourceLocator, String string) {
        this.error(new SourceError(c, sourceLocator, string));
    }

    public void error(char c, String string, int n, int n2, String string2, String string3) {
        SourceError sourceError = new SourceError(c, string, n, n2, string2);
        sourceError.code = string3;
        this.error(sourceError);
    }

    public void error(char c, SourceLocator sourceLocator, String string, String string2) {
        SourceError sourceError = new SourceError(c, sourceLocator, string);
        sourceError.code = string2;
        this.error(sourceError);
    }

    public void error(char c, String string) {
        this.error(new SourceError(c, this.current_filename, this.current_line, this.current_column, string));
    }

    public void error(char c, String string, Throwable throwable) {
        SourceError sourceError = new SourceError(c, this.current_filename, this.current_line, this.current_column, string);
        sourceError.fakeException = throwable;
        this.error(sourceError);
    }

    public void error(char c, String string, String string2) {
        SourceError sourceError = new SourceError(c, this.current_filename, this.current_line, this.current_column, string);
        sourceError.code = string2;
        this.error(sourceError);
    }

    public void printAll(PrintStream printStream, int n) {
        SourceError sourceError = this.firstError;
        while (sourceError != null && --n >= 0) {
            sourceError.println(printStream);
            sourceError = sourceError.next;
        }
    }

    public void printAll(PrintWriter printWriter, int n) {
        SourceError sourceError = this.firstError;
        while (sourceError != null && --n >= 0) {
            sourceError.println(printWriter);
            sourceError = sourceError.next;
        }
    }

    public String toString(int n) {
        if (this.firstError == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        SourceError sourceError = this.firstError;
        while (sourceError != null && --n >= 0) {
            stringBuffer.append(sourceError);
            stringBuffer.append('\n');
            sourceError = sourceError.next;
        }
        return stringBuffer.toString();
    }

    public boolean checkErrors(PrintWriter printWriter, int n) {
        if (this.firstError != null) {
            this.printAll(printWriter, n);
            this.lastError = null;
            this.firstError = null;
            int n2 = this.errorCount;
            this.errorCount = 0;
            return n2 > 0;
        }
        return false;
    }

    public boolean checkErrors(PrintStream printStream, int n) {
        if (this.firstError != null) {
            this.printAll(printStream, n);
            this.lastError = null;
            this.firstError = null;
            int n2 = this.errorCount;
            this.errorCount = 0;
            return n2 > 0;
        }
        return false;
    }

    public final void setSourceLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator == this ? null : sourceLocator;
    }

    public final SourceLocator swapSourceLocator(SourceLocator sourceLocator) {
        SourceLocator sourceLocator2 = this.locator;
        this.locator = sourceLocator;
        return sourceLocator2;
    }

    public final void setLocation(SourceLocator sourceLocator) {
        this.locator = null;
        this.current_line = sourceLocator.getLineNumber();
        this.current_column = sourceLocator.getColumnNumber();
        this.current_filename = sourceLocator.getFileName();
    }

    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    public String getSystemId() {
        return this.locator == null ? this.current_filename : this.locator.getSystemId();
    }

    public boolean isStableSourceLocation() {
        return false;
    }

    public final String getFileName() {
        return this.current_filename;
    }

    public final int getLineNumber() {
        return this.locator == null ? this.current_line : this.locator.getLineNumber();
    }

    public final int getColumnNumber() {
        return this.locator == null ? this.current_column : this.locator.getColumnNumber();
    }

    public void setFile(String string) {
        this.current_filename = string;
    }

    public void setLine(int n) {
        this.current_line = n;
    }

    public void setColumn(int n) {
        this.current_column = n;
    }

    public void setLine(String string, int n, int n2) {
        this.current_filename = string;
        this.current_line = n;
        this.current_column = n2;
    }
}

