/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Location;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.BindingInitializer;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.kawa.functions.AddOp;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.math.IntNum;

public class SetExp
extends AccessExp {
    Expression new_value;
    public static final int DEFINING_FLAG = 1;
    public static final int GLOBAL_FLAG = 2;
    public static final int PREFER_BINDING2 = 4;
    public static final int PROCEDURE = 8;
    public static final int SET_IF_UNBOUND = 16;
    public static final int HAS_VALUE = 32;
    public static final int BAD_SHORT = 65536;

    public SetExp(Object object2, Expression expression) {
        this.symbol = object2;
        this.new_value = expression;
    }

    public SetExp(Declaration declaration, Expression expression) {
        this.binding = declaration;
        this.symbol = declaration.getSymbol();
        this.new_value = expression;
    }

    public static SetExp makeDefinition(Object object2, Expression expression) {
        SetExp setExp = new SetExp(object2, expression);
        setExp.setDefining(true);
        return setExp;
    }

    public static SetExp makeDefinition(Declaration declaration, Expression expression) {
        SetExp setExp = new SetExp(declaration, expression);
        setExp.setDefining(true);
        return setExp;
    }

    public final Expression getNewValue() {
        return this.new_value;
    }

    public final boolean isDefining() {
        return (this.flags & 1) != 0;
    }

    public final void setDefining(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean getHasValue() {
        return (this.flags & 0x20) != 0;
    }

    public final void setHasValue(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public final boolean isFuncDef() {
        return (this.flags & 8) != 0;
    }

    public final void setFuncDef(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final boolean isSetIfUnbound() {
        return (this.flags & 0x10) != 0;
    }

    public final void setSetIfUnbound(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext callContext) throws Throwable {
        Environment environment = callContext.getEnvironment();
        Symbol symbol = this.symbol instanceof Symbol ? (Symbol)this.symbol : environment.getSymbol(this.symbol.toString());
        Object object2 = null;
        Language language = Language.getDefaultLanguage();
        if (this.isFuncDef() && language.hasSeparateFunctionNamespace()) {
            object2 = EnvironmentKey.FUNCTION;
        }
        if (this.isSetIfUnbound()) {
            gnu.mapping.Location location2 = environment.getLocation(symbol, object2);
            if (!location2.isBound()) {
                location2.set(this.new_value.eval(environment));
            }
            if (this.getHasValue()) {
                callContext.writeValue(location2);
            }
            return;
        }
        Object object3 = this.new_value.eval(environment);
        if (this.binding != null && !(this.binding.context instanceof ModuleExp)) {
            Object[] objectArray = callContext.evalFrames[ScopeExp.nesting(this.binding.context)];
            if (this.binding.isIndirectBinding()) {
                if (this.isDefining()) {
                    objectArray[this.binding.evalIndex] = gnu.mapping.Location.make(symbol);
                }
                gnu.mapping.Location location3 = (gnu.mapping.Location)objectArray[this.binding.evalIndex];
                location3.set(this.new_value);
            } else {
                objectArray[this.binding.evalIndex] = object3;
            }
        } else if (this.isDefining()) {
            environment.define(symbol, object2, object3);
        } else {
            environment.put(symbol, object2, object3);
        }
        if (this.getHasValue()) {
            callContext.writeValue(object3);
        }
    }

    public void compile(Compilation compilation, Target target) {
        if (this.new_value instanceof LambdaExp && target instanceof IgnoreTarget && ((LambdaExp)this.new_value).getInlineOnly()) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = this.getHasValue() && !(target instanceof IgnoreTarget);
        boolean bl2 = false;
        Declaration declaration = this.binding;
        Expression expression = declaration.getValue();
        if (declaration.getFlag(0x20000000) && this.isDefining() && !declaration.ignorable()) {
            BindingInitializer.create(declaration, this.new_value, compilation);
        } else if (expression instanceof LambdaExp && declaration.context instanceof ModuleExp && (!declaration.isPrivate() || expression instanceof ClassExp) && ((LambdaExp)expression).getName() != null && expression == this.new_value) {
            ((LambdaExp)this.new_value).compileSetField(compilation);
        } else if (declaration.context instanceof ModuleExp && (declaration.getFlag(16384) || declaration.isAlias()) && this.isDefining() && expression != null) {
            if (bl) {
                declaration.load(this, 0, compilation, Target.pushObject);
                bl2 = true;
            }
        } else {
            Object object2;
            Object object3;
            Object object4 = this;
            Declaration declaration2 = this.contextDecl();
            if (!this.isDefining()) {
                while (declaration != null && declaration.isAlias() && (expression = declaration.getValue()) instanceof ReferenceExp) {
                    object3 = (ReferenceExp)expression;
                    object2 = ((ReferenceExp)object3).binding;
                    if (object2 == null || declaration2 != null && ((Declaration)object2).needsContext()) break;
                    declaration2 = ((AccessExp)object3).contextDecl();
                    object4 = object3;
                    declaration = object2;
                }
            }
            if (declaration.ignorable()) {
                this.new_value.compile(compilation, Target.Ignore);
            } else if (declaration.isAlias() && this.isDefining()) {
                declaration.load(this, 1, compilation, Target.pushObject);
                object3 = ClassType.make("gnu.mapping.IndirectableLocation");
                codeAttr.emitCheckcast((Type)object3);
                this.new_value.compile(compilation, Target.pushObject);
                object2 = ((ClassType)object3).getDeclaredMethod("setAlias", 1);
                codeAttr.emitInvokeVirtual((Method)object2);
            } else if (declaration.isIndirectBinding()) {
                declaration.load((AccessExp)object4, 1, compilation, Target.pushObject);
                if (this.isSetIfUnbound()) {
                    if (bl) {
                        codeAttr.emitDup();
                        bl2 = true;
                    }
                    codeAttr.pushScope();
                    codeAttr.emitDup();
                    object3 = codeAttr.addLocal(Compilation.typeLocation);
                    codeAttr.emitStore((Variable)object3);
                    codeAttr.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod("isBound", 0));
                    codeAttr.emitIfIntEqZero();
                    codeAttr.emitLoad((Variable)object3);
                }
                this.new_value.compile(compilation, Target.pushObject);
                if (bl && !this.isSetIfUnbound()) {
                    codeAttr.emitDupX();
                    bl2 = true;
                }
                object3 = "set";
                codeAttr.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod((String)object3, 1));
                if (this.isSetIfUnbound()) {
                    codeAttr.emitFi();
                    codeAttr.popScope();
                }
            } else if (declaration.isSimple()) {
                int n;
                Type type = declaration.getType();
                object3 = declaration.getVariable();
                if (object3 == null) {
                    object3 = declaration.allocateVariable(codeAttr);
                }
                if ((n = SetExp.canUseInc(this.new_value, declaration)) != 65536) {
                    compilation.getCode().emitInc((Variable)object3, (short)n);
                    if (bl) {
                        codeAttr.emitLoad((Variable)object3);
                        bl2 = true;
                    }
                } else {
                    this.new_value.compile(compilation, declaration);
                    if (bl) {
                        codeAttr.emitDup(type);
                        bl2 = true;
                    }
                    codeAttr.emitStore((Variable)object3);
                }
            } else if (declaration.context instanceof ClassExp && declaration.field == null && !this.getFlag(8) && ((ClassExp)declaration.context).isMakingClassPair()) {
                object3 = ClassExp.slotToMethodName("set", declaration.getName());
                object2 = (ClassExp)declaration.context;
                Method method = ((ClassExp)object2).type.getDeclaredMethod((String)object3, 1);
                ((LambdaExp)object2).loadHeapFrame(compilation);
                this.new_value.compile(compilation, declaration);
                if (bl) {
                    codeAttr.emitDupX();
                    bl2 = true;
                }
                codeAttr.emitInvoke(method);
            } else {
                object3 = declaration.field;
                if (!((Field)object3).getStaticFlag()) {
                    declaration.loadOwningObject(declaration2, compilation);
                }
                Type type = ((Location)object3).getType();
                this.new_value.compile(compilation, declaration);
                compilation.usedClass(((Field)object3).getDeclaringClass());
                if (((Field)object3).getStaticFlag()) {
                    if (bl) {
                        codeAttr.emitDup(type);
                        bl2 = true;
                    }
                    codeAttr.emitPutStatic((Field)object3);
                } else {
                    if (bl) {
                        codeAttr.emitDupX();
                        bl2 = true;
                    }
                    codeAttr.emitPutField((Field)object3);
                }
            }
        }
        if (bl && !bl2) {
            throw new Error("SetExp.compile: not implemented - return value");
        }
        if (bl) {
            target.compileFromStack(compilation, this.getType());
        } else {
            compilation.compileConstant(Values.empty, target);
        }
    }

    public static int canUseInc(Expression expression, Declaration declaration) {
        block13: {
            Expression expression2;
            int n;
            ApplyExp applyExp;
            block15: {
                Object object2;
                block14: {
                    Variable variable = declaration.getVariable();
                    if (!declaration.isSimple() || variable.getType().getImplementationType().promote() != Type.intType || !(expression instanceof ApplyExp) || (applyExp = (ApplyExp)expression).getArgCount() != 2) break block13;
                    Expression expression3 = applyExp.getFunction();
                    object2 = expression3.valueIfConstant();
                    if (object2 != AddOp.$Pl) break block14;
                    n = 1;
                    break block15;
                }
                if (object2 != AddOp.$Mn) break block13;
                n = -1;
            }
            Expression expression4 = applyExp.getArg(0);
            Expression expression5 = applyExp.getArg(1);
            if (expression4 instanceof QuoteExp && n > 0) {
                expression2 = expression5;
                expression5 = expression4;
                expression4 = expression2;
            }
            if (expression4 instanceof ReferenceExp && ((AccessExp)(expression2 = (ReferenceExp)expression4)).getBinding() == declaration && !((ReferenceExp)expression2).getDontDereference()) {
                Object object3 = expression5.valueIfConstant();
                if (object3 instanceof Integer) {
                    int n2 = (Integer)object3;
                    if (n < 0) {
                        n2 = -n2;
                    }
                    if ((short)n2 == n2) {
                        return n2;
                    }
                } else if (object3 instanceof IntNum) {
                    IntNum intNum = (IntNum)object3;
                    int n3 = Short.MAX_VALUE;
                    int n4 = -n3;
                    if (n > 0) {
                        --n4;
                    } else {
                        ++n3;
                    }
                    if (IntNum.compare(intNum, n4) >= 0 && IntNum.compare(intNum, n3) <= 0) {
                        return n * intNum.intValue();
                    }
                }
            }
        }
        return 65536;
    }

    public final Type getType() {
        return !this.getHasValue() ? Type.voidType : (this.binding == null ? Type.pointer_type : this.binding.getType());
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkSetExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.new_value = expWalker.walk(this.new_value);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock(this.isDefining() ? "(Define" : "(Set", ")", 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        if (this.binding == null || this.symbol.toString() != this.binding.getName()) {
            outPort.print('/');
            outPort.print(this.symbol);
        }
        if (this.binding != null) {
            outPort.print('/');
            outPort.print(this.binding);
        }
        outPort.writeSpaceLinear();
        this.new_value.print(outPort);
        outPort.endLogicalBlock(")");
    }

    public String toString() {
        return "SetExp[" + this.symbol + ":=" + this.new_value + ']';
    }
}

