/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.commonlisp.lang.Lisp2ReadTable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.QuoteExp;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.FieldLocation;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import java.lang.reflect.Field;
import kawa.lang.Syntax;

public abstract class Lisp2
extends LispLanguage {
    public static final LList FALSE = LList.Empty;
    public static final Symbol TRUE = Namespace.getDefault().getSymbol("t");
    public static final Expression nilExpr = new QuoteExp(FALSE);

    public boolean isTrue(Object object2) {
        return object2 != FALSE;
    }

    public Object booleanObject(boolean bl) {
        if (bl) {
            return TRUE;
        }
        return FALSE;
    }

    public void emitPushBoolean(boolean bl, CodeAttr codeAttr) {
        if (bl) {
            codeAttr.emitGetStatic(ClassType.make("gnu.commonlisp.lang.Lisp2").getDeclaredField("TRUE"));
        } else {
            codeAttr.emitGetStatic(Compilation.scmListType.getDeclaredField("Empty"));
        }
    }

    public Object noValue() {
        return FALSE;
    }

    public boolean hasSeparateFunctionNamespace() {
        return true;
    }

    public boolean selfEvaluatingSymbol(Object object2) {
        return object2 instanceof Keyword || object2 == TRUE || object2 == FALSE;
    }

    public Object getEnvPropertyFor(Field field, Object object2) {
        if (Compilation.typeProcedure.getReflectClass().isAssignableFrom(field.getType()) || object2 instanceof Syntax) {
            return EnvironmentKey.FUNCTION;
        }
        return null;
    }

    public int getNamespaceOf(Declaration declaration) {
        if (declaration.isAlias()) {
            return 3;
        }
        return declaration.isProcedureDecl() ? 2 : 1;
    }

    public static Object asSymbol(String string) {
        if (string == "nil") {
            return FALSE;
        }
        return Environment.getCurrent().getSymbol(string);
    }

    protected Symbol fromLangSymbol(Object object2) {
        if (object2 == LList.Empty) {
            return this.environ.getSymbol("nil");
        }
        return super.fromLangSymbol(object2);
    }

    public static Object getString(String string) {
        return new FString(string);
    }

    public static Object getString(Symbol symbol) {
        return Lisp2.getString(symbol.getName());
    }

    protected void defun(String string, Object object2) {
        Named named;
        this.environ.define(this.getSymbol(string), EnvironmentKey.FUNCTION, object2);
        if (object2 instanceof Named && (named = (Named)object2).getName() == null) {
            named.setName(string);
        }
    }

    protected void defun(Symbol symbol, Object object2) {
        Procedure procedure;
        this.environ.define(symbol, EnvironmentKey.FUNCTION, object2);
        if (object2 instanceof Procedure && (procedure = (Procedure)object2).getSymbol() == null) {
            procedure.setSymbol(symbol);
        }
    }

    private void defun(Procedure procedure) {
        this.defun(procedure.getName(), (Object)procedure);
    }

    protected void importLocation(Location location2) {
        Symbol symbol = ((NamedLocation)location2).getKeySymbol();
        if (this.environ.isBound(symbol, EnvironmentKey.FUNCTION)) {
            return;
        }
        if ((location2 = location2.getBase()) instanceof FieldLocation && ((FieldLocation)location2).isProcedureOrSyntax()) {
            this.environ.addLocation(symbol, EnvironmentKey.FUNCTION, location2);
        } else {
            Object object2 = location2.get(null);
            if (object2 != null) {
                if (object2 instanceof Procedure || object2 instanceof Syntax) {
                    this.defun(symbol, object2);
                } else if (object2 instanceof LangObjType) {
                    this.defun(symbol, (Object)((LangObjType)object2).getConstructor());
                } else {
                    this.define(symbol.getName(), object2);
                }
            }
        }
    }

    public ReadTable createReadTable() {
        Lisp2ReadTable lisp2ReadTable = new Lisp2ReadTable();
        lisp2ReadTable.initialize();
        lisp2ReadTable.setInitialColonIsKeyword(true);
        return lisp2ReadTable;
    }
}

