/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import java.lang.reflect.Method;

public class ModuleMethod
extends MethodProc {
    public ModuleBody module;
    public final int selector;
    protected int numArgs;

    public ModuleMethod(ModuleBody moduleBody, int n, Object object2, int n2) {
        this.module = moduleBody;
        this.selector = n;
        this.numArgs = n2;
        if (object2 != null) {
            this.setSymbol(object2);
        }
    }

    public ModuleMethod(ModuleBody moduleBody, int n, Object object2, int n2, Object object3) {
        this.module = moduleBody;
        this.selector = n;
        this.numArgs = n2;
        this.setSymbol(object2);
        this.argTypes = object3;
    }

    public String getName() {
        String string = super.getName();
        if (string == null) {
            string = "{" + this.module.getClass().getName() + ':' + this.selector + '}';
        }
        return string;
    }

    protected void resolveParameterTypes() {
        Method method = null;
        try {
            Class<?> clazz = this.module.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            String string = Compilation.mangleNameIfNeeded(this.getName());
            int n = methodArray.length;
            while (--n >= 0) {
                if (!methodArray[n].getName().equals(string)) continue;
                if (method != null) {
                    method = null;
                    break;
                }
                method = methodArray[n];
            }
            if (method != null) {
                Language language = Language.getDefaultLanguage();
                Class<?>[] classArray = method.getParameterTypes();
                int n2 = classArray.length;
                Type[] typeArray = new Type[n2];
                int n3 = n2;
                while (--n3 >= 0) {
                    typeArray[n3] = language.getTypeFor(classArray[n3]);
                }
                this.argTypes = typeArray;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.argTypes == null) {
            super.resolveParameterTypes();
        }
    }

    public int numArgs() {
        return this.numArgs;
    }

    public int match0(CallContext callContext) {
        callContext.count = 0;
        callContext.where = 0;
        return this.module.match0(this, callContext);
    }

    public int match1(Object object2, CallContext callContext) {
        callContext.count = 1;
        callContext.where = 1;
        return this.module.match1(this, object2, callContext);
    }

    public int match2(Object object2, Object object3, CallContext callContext) {
        callContext.count = 2;
        callContext.where = 33;
        return this.module.match2(this, object2, object3, callContext);
    }

    public int match3(Object object2, Object object3, Object object4, CallContext callContext) {
        callContext.count = 3;
        callContext.where = 801;
        return this.module.match3(this, object2, object3, object4, callContext);
    }

    public int match4(Object object2, Object object3, Object object4, Object object5, CallContext callContext) {
        callContext.count = 4;
        callContext.where = 17185;
        return this.module.match4(this, object2, object3, object4, object5, callContext);
    }

    public int matchN(Object[] objectArray, CallContext callContext) {
        callContext.count = objectArray.length;
        callContext.where = 0;
        return this.module.matchN(this, objectArray, callContext);
    }

    public void apply(CallContext callContext) throws Throwable {
        Object object2;
        switch (callContext.pc) {
            case 0: {
                object2 = this.apply0();
                break;
            }
            case 1: {
                object2 = this.apply1(callContext.value1);
                break;
            }
            case 2: {
                object2 = this.apply2(callContext.value1, callContext.value2);
                break;
            }
            case 3: {
                object2 = this.apply3(callContext.value1, callContext.value2, callContext.value3);
                break;
            }
            case 4: {
                object2 = this.apply4(callContext.value1, callContext.value2, callContext.value3, callContext.value4);
                break;
            }
            case 5: {
                object2 = this.applyN(callContext.values);
                break;
            }
            default: {
                throw new Error("internal error - apply " + this);
            }
        }
        callContext.writeValue(object2);
    }

    public Object apply0() throws Throwable {
        return this.module.apply0(this);
    }

    public Object apply1(Object object2) throws Throwable {
        return this.module.apply1(this, object2);
    }

    public Object apply2(Object object2, Object object3) throws Throwable {
        return this.module.apply2(this, object2, object3);
    }

    public Object apply3(Object object2, Object object3, Object object4) throws Throwable {
        return this.module.apply3(this, object2, object3, object4);
    }

    public Object apply4(Object object2, Object object3, Object object4, Object object5) throws Throwable {
        return this.module.apply4(this, object2, object3, object4, object5);
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        return this.module.applyN(this, objectArray);
    }

    public static Object apply0Default(ModuleMethod moduleMethod) throws Throwable {
        return moduleMethod.module.applyN(moduleMethod, Values.noArgs);
    }

    public static Object apply1Default(ModuleMethod moduleMethod, Object object2) throws Throwable {
        Object[] objectArray = new Object[]{object2};
        return moduleMethod.module.applyN(moduleMethod, objectArray);
    }

    public static Object apply2Default(ModuleMethod moduleMethod, Object object2, Object object3) throws Throwable {
        Object[] objectArray = new Object[]{object2, object3};
        return moduleMethod.module.applyN(moduleMethod, objectArray);
    }

    public static Object apply3Default(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) throws Throwable {
        Object[] objectArray = new Object[]{object2, object3, object4};
        return moduleMethod.module.applyN(moduleMethod, objectArray);
    }

    public static Object apply4Default(ModuleMethod moduleMethod, Object object2, Object object3, Object object4, Object object5) throws Throwable {
        Object[] objectArray = new Object[]{object2, object3, object4, object5};
        return moduleMethod.module.applyN(moduleMethod, objectArray);
    }

    public static Object applyNDefault(ModuleMethod moduleMethod, Object[] objectArray) throws Throwable {
        int n = objectArray.length;
        int n2 = moduleMethod.numArgs();
        ModuleBody moduleBody = moduleMethod.module;
        if (n >= (n2 & 0xFFF) && (n2 < 0 || n <= n2 >> 12)) {
            switch (n) {
                case 0: {
                    return moduleBody.apply0(moduleMethod);
                }
                case 1: {
                    return moduleBody.apply1(moduleMethod, objectArray[0]);
                }
                case 2: {
                    return moduleBody.apply2(moduleMethod, objectArray[0], objectArray[1]);
                }
                case 3: {
                    return moduleBody.apply3(moduleMethod, objectArray[0], objectArray[1], objectArray[2]);
                }
                case 4: {
                    return moduleBody.apply4(moduleMethod, objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
                }
            }
        }
        throw new WrongArguments(moduleMethod, n);
    }

    public static void applyError() {
        throw new Error("internal error - bad selector");
    }
}

