/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.Menu;
import gnu.jemacs.swing.SwingWindow;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingFrame
extends EFrame {
    JFrame jframe;
    JMenuBar menuBar;
    JPanel contents;

    public SwingFrame() {
    }

    public SwingFrame(Buffer buffer) {
        this(new SwingWindow(buffer, true));
    }

    public SwingFrame(SwingWindow swingWindow) {
        super(swingWindow);
        this.contents = swingWindow.wrap();
        this.jframe = new JFrame(EFrame.defaultName());
        this.jframe.getContentPane().add(this.contents);
        ((Component)this.jframe).setSize(600, 400);
        ((Component)this.jframe).setVisible(true);
        this.jframe.setTitle("JEmacs");
        this.menuBar = new JMenuBar();
        this.jframe.setJMenuBar(this.menuBar);
    }

    public boolean isLive() {
        return this.contents != null;
    }

    public void validate() {
        this.jframe.validate();
    }

    public void delete() {
        super.delete();
        this.contents = null;
        this.jframe.dispose();
    }

    public String ask(String string) {
        String string2 = JOptionPane.showInputDialog(this.jframe, (Object)string);
        if (string2 == null) {
            throw new CancelledException();
        }
        return string2;
    }

    public void setMenuBar(Menu menu) {
        this.menuBar.removeAll();
        while (menu.getMenuComponentCount() > 0) {
            this.menuBar.add(menu.getMenuComponent(0));
        }
        this.menuBar.updateUI();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<frame #");
        stringBuffer.append(this.id);
        if (this.jframe != null) {
            stringBuffer.append(" size: ");
            stringBuffer.append(this.jframe.getSize());
            stringBuffer.append(" preferred: ");
            stringBuffer.append(this.jframe.getPreferredSize());
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

