/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ExitExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Values;

public class IfExp
extends Expression {
    Expression test;
    Expression then_clause;
    Expression else_clause;

    public IfExp(Expression expression, Expression expression2, Expression expression3) {
        this.test = expression;
        this.then_clause = expression2;
        this.else_clause = expression3;
    }

    protected final Interpreter getInterpreter() {
        return Interpreter.defaultInterpreter;
    }

    public Object eval(Environment environment) throws Throwable {
        Interpreter interpreter = this.getInterpreter();
        if (interpreter.isTrue(this.test.eval(environment))) {
            return this.then_clause.eval(environment);
        }
        if (this.else_clause != null) {
            return this.else_clause.eval(environment);
        }
        return interpreter.noValue();
    }

    public void eval(Environment environment, CallContext callContext) throws Throwable {
        Interpreter interpreter = this.getInterpreter();
        if (interpreter.isTrue(this.test.eval(environment))) {
            this.then_clause.eval(environment, callContext);
        } else if (this.else_clause != null) {
            this.else_clause.eval(environment, callContext);
        }
    }

    public void compile(Compilation compilation, Target target) {
        IfExp.compile(this.test, this.then_clause, this.else_clause == null ? QuoteExp.voidExp : this.else_clause, compilation, target);
    }

    public static void compile(Expression expression, Expression expression2, Expression expression3, Compilation compilation, Target target) {
        Label label;
        boolean bl;
        Label label2;
        Object object2;
        boolean bl2;
        Interpreter interpreter = compilation.getInterpreter();
        CodeAttr codeAttr = compilation.getCode();
        if (target instanceof ConditionalTarget && expression3 instanceof QuoteExp) {
            bl2 = true;
            object2 = ((QuoteExp)expression3).getValue();
            label2 = interpreter.isTrue(object2) ? ((ConditionalTarget)target).ifTrue : ((ConditionalTarget)target).ifFalse;
        } else if (expression3 instanceof ExitExp && ((ExitExp)expression3).result instanceof QuoteExp && ((ExitExp)expression3).block.subTarget instanceof IgnoreTarget) {
            bl2 = true;
            label2 = ((ExitExp)expression3).block.exitLabel;
        } else {
            bl2 = false;
            label2 = new Label(codeAttr);
        }
        if (expression == expression2 && target instanceof ConditionalTarget && expression2 instanceof ReferenceExp) {
            bl = true;
            label = ((ConditionalTarget)target).ifTrue;
        } else {
            bl = false;
            label = new Label(codeAttr);
        }
        object2 = new ConditionalTarget(label, label2, interpreter);
        if (bl) {
            ((ConditionalTarget)object2).trueBranchComesFirst = false;
        }
        expression.compile(compilation, (Target)object2);
        codeAttr.emitIfThen();
        if (!bl) {
            label.define(codeAttr);
            expression2.compileWithPosition(compilation, target);
        }
        if (!bl2) {
            codeAttr.emitElse();
            label2.define(codeAttr);
            if (expression3 == null) {
                compilation.compileConstant(Values.empty, target);
            } else {
                expression3.compileWithPosition(compilation, target);
            }
        } else {
            codeAttr.setUnreachable();
        }
        codeAttr.emitFi();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkIfExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.test = this.test.walk(expWalker);
        if (expWalker.exitValue == null) {
            this.then_clause = expWalker.walk(this.then_clause);
        }
        if (expWalker.exitValue == null) {
            this.else_clause = expWalker.walk(this.else_clause);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(If ", false, ")");
        outPort.setIndentation(-2, false);
        this.test.print(outPort);
        outPort.writeSpaceLinear();
        this.then_clause.print(outPort);
        if (this.else_clause != null) {
            outPort.writeSpaceLinear();
            this.else_clause.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

