/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.IntegerFormat;
import gnu.kawa.functions.LispFormat;
import gnu.kawa.functions.ObjectFormat;
import gnu.lists.FString;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Procedure1;
import gnu.text.CompoundFormat;
import gnu.text.LineBufferedReader;
import gnu.text.LiteralFormat;
import gnu.text.PadFormat;
import gnu.text.ReportFormat;
import java.io.IOException;
import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Vector;

public class ParseFormat
extends Procedure1 {
    public static final ParseFormat parseFormat = new ParseFormat(false);
    boolean emacsStyle = true;
    public static final int PARAM_UNSPECIFIED = -1073741824;
    public static final int PARAM_FROM_LIST = -1610612736;
    public static final int SEEN_MINUS = 1;
    public static final int SEEN_PLUS = 2;
    public static final int SEEN_SPACE = 4;
    public static final int SEEN_ZERO = 8;
    public static final int SEEN_HASH = 16;

    public ParseFormat(boolean bl) {
        this.emacsStyle = bl;
    }

    public ReportFormat parseFormat(LineBufferedReader lineBufferedReader) throws ParseException, IOException {
        return ParseFormat.parseFormat(lineBufferedReader, this.emacsStyle ? (char)'?' : '~');
    }

    public static ReportFormat parseFormat(LineBufferedReader lineBufferedReader, char c) throws ParseException, IOException {
        Object e;
        int n;
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = 0;
        Vector<ReportFormat> vector = new Vector<ReportFormat>();
        while (true) {
            char c2;
            int n3;
            Format format;
            int n4;
            if ((n = lineBufferedReader.read()) >= 0) {
                if (n != c) {
                    stringBuffer.append((char)n);
                    continue;
                }
                n = lineBufferedReader.read();
                if (n == c) {
                    stringBuffer.append((char)n);
                    continue;
                }
            }
            if ((n4 = stringBuffer.length()) > 0) {
                char[] cArray = new char[n4];
                stringBuffer.getChars(0, n4, cArray, 0);
                stringBuffer.setLength(0);
                vector.addElement(new LiteralFormat(cArray));
            }
            if (n < 0) break;
            if (n == 36) {
                int n5;
                n = lineBufferedReader.read();
                n2 = Character.digit((char)n, 10);
                if (n2 < 0) {
                    throw new ParseException("missing number (position) after '%$'", -1);
                }
                while ((n5 = Character.digit((char)(n = lineBufferedReader.read()), 10)) >= 0) {
                    n2 = 10 * n2 + n5;
                }
                --n2;
            }
            int n6 = 0;
            block14: while (true) {
                switch ((char)n) {
                    case '-': {
                        n6 |= 1;
                        break;
                    }
                    case '+': {
                        n6 |= 2;
                        break;
                    }
                    case ' ': {
                        n6 |= 4;
                        break;
                    }
                    case '0': {
                        n6 |= 8;
                        break;
                    }
                    case '#': {
                        n6 |= 0x10;
                        break;
                    }
                    default: {
                        break block14;
                    }
                }
                n = lineBufferedReader.read();
            }
            int n7 = -1073741824;
            int n8 = Character.digit((char)n, 10);
            if (n8 >= 0) {
                n7 = n8;
                while ((n8 = Character.digit((char)(n = lineBufferedReader.read()), 10)) >= 0) {
                    n7 = 10 * n7 + n8;
                }
            } else if (n == 42) {
                n7 = -1610612736;
            }
            int n9 = -1073741824;
            if (n == 46) {
                if (n == 42) {
                    n9 = -1610612736;
                } else {
                    n9 = 0;
                    while ((n8 = Character.digit((char)(n = lineBufferedReader.read()), 10)) >= 0) {
                        n9 = 10 * n9 + n8;
                    }
                }
            }
            switch (n) {
                case 83: 
                case 115: {
                    format = new ObjectFormat(n == 83, n9);
                    break;
                }
                case 88: 
                case 100: 
                case 105: 
                case 111: 
                case 120: {
                    int n10;
                    n3 = 0;
                    if (n == 100 || n == 105) {
                        c2 = '\n';
                    } else if (n == 111) {
                        c2 = '\b';
                    } else {
                        c2 = '\u0010';
                        if (n == 88) {
                            n3 = 32;
                        }
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    int n11 = n10 = (n6 & 9) == 8 ? 48 : 32;
                    if ((n6 & 0x10) != 0) {
                        n3 |= 8;
                    }
                    if ((n6 & 2) != 0) {
                        n3 |= 2;
                    }
                    if ((n6 & 1) != 0) {
                        n3 |= 0x10;
                    }
                    if ((n6 & 4) != 0) {
                        n3 |= 4;
                    }
                    if (n9 != -1073741824) {
                        n6 &= 0xFFFFFFF7;
                        format = IntegerFormat.getInstance(c2, n9, 48, -1073741824, -1073741824, n3 |= 0x40);
                        break;
                    }
                    format = IntegerFormat.getInstance(c2, n7, n10, -1073741824, -1073741824, n3);
                    break;
                }
                case 101: 
                case 102: 
                case 103: {
                    format = new ObjectFormat(false);
                    break;
                }
                default: {
                    throw new ParseException("unknown format character '" + n + "'", -1);
                }
            }
            if (n7 > 0) {
                char c3 = c2 = (n6 & 8) != 0 ? (char)'0' : ' ';
                n3 = (n6 & 1) != 0 ? 100 : (c2 == '0' ? -1 : 0);
                format = new PadFormat(format, n7, c2, n3);
            }
            vector.addElement((ReportFormat)format);
            ++n2;
        }
        n = vector.size();
        if (n == 1 && (e = vector.elementAt(0)) instanceof ReportFormat) {
            return (ReportFormat)e;
        }
        Object[] objectArray = new Format[n];
        vector.copyInto(objectArray);
        return new CompoundFormat((Format[])objectArray);
    }

    public Object apply1(Object object2) {
        return ParseFormat.asFormat(object2, this.emacsStyle ? (char)'?' : '~');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportFormat asFormat(Object object2, char c) {
        CharArrayInPort charArrayInPort;
        Serializable serializable;
        if (object2 instanceof ReportFormat) {
            return (ReportFormat)object2;
        }
        if (c == '~') {
            return new LispFormat(object2.toString());
        }
        if (object2 instanceof FString) {
            serializable = (FString)object2;
            charArrayInPort = new CharArrayInPort(serializable.data, serializable.size);
        } else {
            charArrayInPort = new CharArrayInPort(object2.toString());
        }
        try {
            serializable = ParseFormat.parseFormat(charArrayInPort, c);
        }
        catch (Throwable throwable) {
            try {
                charArrayInPort.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error parsing format (" + iOException + ")");
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Invalid format (" + parseException + ")");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException("End while parsing format");
            }
        }
        charArrayInPort.close();
        return serializable;
    }
}

