/*
 * $Id: CompilationException.java,v 1.2 1998/05/15 16:47:11 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */
package gnu.jel;
import gnu.jel.generated.ParseException;
import gnu.jel.generated.TokenMgrError;
import gnu.jel.generated.Token;

public class CompilationException extends Exception {
  
  int col;
  
  public CompilationException(int col,String message) {
    super(message);
    this.col=col;
  };

  public CompilationException(Token tok,String message) {
    super(message);
    col=tok.beginColumn;
  };
  
  public CompilationException(ParseException pe) {
    super("Encountered unexpected "+
	  (pe.currentToken.next.kind!=0?("\""+pe.currentToken.next+"\""):
	   "end of expression")+
	  " .");
    col=pe.currentToken.next.beginColumn;
  };

  public CompilationException(TokenMgrError pe) {
    super("Encountered unexpected "+
	  (pe.isEOF?"end of expression":("'"+pe.encountered+"'"))+
	  " .");
    col=pe.col;
  };

  public int getColumn() {return col;};

};
