/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import gnu.jel.reflect.Field;
import gnu.jel.reflect.LocalField;
import gnu.jel.reflect.Member;
import gnu.jel.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Hashtable names = new Hashtable();
    private Hashtable dynIDs = new Hashtable();
    private Hashtable stateless = new Hashtable();

    public Library(Class[] classArray, Class[] classArray2) {
        if (classArray != null) {
            this.rehash(classArray, true);
        }
        if (classArray2 != null) {
            this.rehash(classArray2, false);
        }
    }

    private String describe(String string, Class[] classArray) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(classArray[n].toString());
                ++n;
            }
        }
        stringBuffer.append(')');
        string2 = stringBuffer.toString();
        return string2;
    }

    public int getDynamicMethodClassID(Member member) {
        Integer n = (Integer)this.dynIDs.get(member);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public Member getMember(String string, Class[] classArray) throws NoSuchMethodException {
        Object object;
        Object object2;
        Hashtable hashtable = (Hashtable)this.names.get(string);
        if (hashtable == null) {
            throw new NoSuchMethodException("The name \"" + string + "\" is not defined.");
        }
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Member)enumeration.nextElement();
            object = object2.getParameterTypes();
            boolean bl = false;
            if (classArray != null) {
                if (((Class[])object).length == classArray.length) {
                    bl = true;
                    int n = 0;
                    while (n < ((Object)object).length && bl) {
                        bl = TypesStack.isWidening(classArray[n], (Class)object[n]);
                        ++n;
                    }
                }
            } else {
                boolean bl2 = bl = ((Class[])object).length == 0;
            }
            if (!bl) continue;
            vector.addElement(object2);
        }
        if (vector.size() == 0) {
            throw new NoSuchMethodException("Function \"" + string + "\" exists," + " but parameters " + this.describe(string, classArray) + " can not be accepted by it.");
        }
        if (vector.size() == 1) {
            return (Member)vector.firstElement();
        }
        object2 = vector.elements();
        object = (Member)object2.nextElement();
        Class[] classArray2 = object.getParameterTypes();
        while (object2.hasMoreElements()) {
            Member member = (Member)object2.nextElement();
            Class[] classArray3 = member.getParameterTypes();
            boolean bl = true;
            boolean bl3 = true;
            int n = 0;
            while (n < classArray3.length) {
                bl = bl && TypesStack.isWidening(classArray3[n], classArray2[n]);
                bl3 = bl3 && TypesStack.isWidening(classArray2[n], classArray3[n]);
                ++n;
            }
            if (bl && !bl3) {
                object = member;
                classArray2 = classArray3;
            }
            if (bl ^ bl3) continue;
            throw new NoSuchMethodException("Ambiguity detected between \"" + this.describe(string, classArray2) + "\" and \"" + this.describe(string, classArray3) + "\" on invocation \"" + this.describe(string, classArray) + "\" .");
        }
        return object;
    }

    public boolean isStateless(Member member) {
        return this.stateless.containsKey(member);
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester(System.out);
        Library.test(tester);
        tester.summarize();
    }

    public void markStateDependent(String string, Class[] classArray) throws NoSuchMethodException {
        Member member = this.getMember(string, classArray);
        Object v = this.stateless.remove(member);
    }

    private boolean rehash(Member member) {
        Hashtable hashtable;
        String string = member.getName();
        String string2 = ClassFile.getSignature(member);
        if (member instanceof Field) {
            string2 = "()" + string2;
        }
        if ((hashtable = (Hashtable)this.names.get(string)) == null) {
            Hashtable<String, Member> hashtable2 = new Hashtable<String, Member>();
            hashtable2.put(string2, member);
            this.names.put(string, hashtable2);
            return true;
        }
        Object v = hashtable.get(string2);
        if (v == null) {
            hashtable.put(string2, member);
            return true;
        }
        return false;
    }

    private void rehash(Class[] classArray, boolean bl) {
        int n = 0;
        while (n < classArray.length) {
            Integer n2 = new Integer(n);
            java.lang.reflect.Method[] methodArray = classArray[n].getMethods();
            java.lang.reflect.Field[] fieldArray = classArray[n].getFields();
            int n3 = methodArray.length;
            int n4 = n3 + fieldArray.length;
            int n5 = 0;
            while (n5 < n4) {
                LocalField localField;
                LocalField localField2 = localField = n5 < n3 ? new Method(methodArray[n5]) : new Field(fieldArray[n5 - n3]);
                if ((localField.getModifiers() & 8) > 0) {
                    if (bl && this.rehash(localField)) {
                        this.stateless.put(localField, Boolean.TRUE);
                    }
                } else if (!bl && this.rehash(localField)) {
                    this.dynIDs.put(localField, n2);
                }
                ++n5;
            }
            ++n;
        }
    }

    public static void test(Tester tester) {
        Class[] classArray;
        Object object;
        Class[] classArray2;
        Library library = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("It is IMPOSSIBLE :)");
        }
        tester.startTest("Creating the library of java.lang.Math");
        try {
            classArray2 = new Class[]{clazz};
            object = new Library(classArray2, null);
            library = object;
            tester.testOK();
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(double)");
        try {
            classArray2 = new Class[]{Double.TYPE};
            object = library.getMember("round", classArray2);
            if (object != null && object.equals(new Method(clazz.getMethod("round", classArray2)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(float)");
        try {
            classArray2 = new Class[]{Float.TYPE};
            object = library.getMember("round", classArray2);
            if (object != null && object.equals(new Method(clazz.getMethod("round", classArray2)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            classArray2 = new Class[]{Integer.TYPE};
            object = library.getMember("round", classArray2);
            classArray = new Class[]{Float.TYPE};
            if (object != null && object.equals(new Method(clazz.getMethod("round", classArray)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            classArray2 = new Class[]{Integer.TYPE};
            object = library.getMember("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && object.equals(new Method(clazz.getMethod("abs", classArray)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            classArray2 = new Class[]{Byte.TYPE};
            object = library.getMember("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && object.equals(new Method(clazz.getMethod("abs", classArray)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            classArray2 = new Class[]{Character.TYPE};
            object = library.getMember("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && object.equals(new Method(clazz.getMethod("abs", classArray)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of invocation min(int,float) best is min(float,float)");
        try {
            classArray2 = new Class[]{Integer.TYPE, Float.TYPE};
            object = library.getMember("min", classArray2);
            classArray = new Class[]{Float.TYPE, Float.TYPE};
            if (object != null && object.equals(new Method(clazz.getMethod("min", classArray)))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Attempt of access to the field PI");
        try {
            classArray2 = new Class[]{};
            object = library.getMember("PI", classArray2);
            if (object != null && object.getName().equals("PI")) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
        tester.startTest("Checking assignment of state dependence ");
        try {
            library.markStateDependent("random", null);
            if (!library.isStateless(library.getMember("random", null))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            Debug.reportThrowable(throwable);
            tester.testFail();
        }
    }
}

