/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.reflect.Method;

public class OPunary
extends OPfunction {
    protected int code;
    private boolean str_to_tsb = false;
    private boolean tsb_to_str = false;
    private static Method sb_constructor;
    private static Method sb_toString;
    protected static Class sb_class;
    protected static Class string_class;
    protected static final int[] unary_prmtns;
    private static final int[][] una;
    private static final String[] opSymbols;
    private static final String[] opNames;

    static {
        try {
            sb_class = Class.forName("java.lang.StringBuffer");
            string_class = Class.forName("java.lang.String");
            Class[] params = new Class[]{string_class};
            sb_constructor = new Method(sb_class.getConstructor(params));
            params = new Class[]{};
            sb_toString = new Method(sb_class.getMethod("toString", params));
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
        }
        int[] nArray = new int[10];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        unary_prmtns = nArray;
        int[][] nArrayArray = new int[13][];
        nArrayArray[0] = new int[]{116, 116, 255, 116, 116, 117, 118, 119, 255, 255};
        nArrayArray[1] = new int[]{255, 33282, 33282, 33282, 33282, 8619266, 255, 255, 255, 255};
        int[] nArray2 = new int[10];
        nArray2[1] = 255;
        nArray2[2] = 255;
        nArray2[3] = 255;
        nArray2[4] = 255;
        nArray2[5] = 255;
        nArray2[6] = 255;
        nArray2[7] = 255;
        nArray2[8] = 255;
        nArray2[9] = 255;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[10];
        nArray3[1] = 255;
        nArray3[2] = 255;
        nArray3[3] = 255;
        nArray3[4] = 255;
        nArray3[5] = 255;
        nArray3[6] = 255;
        nArray3[7] = 255;
        nArray3[8] = 255;
        nArray3[9] = 255;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[10];
        nArray4[0] = 145;
        nArray4[2] = 145;
        nArray4[3] = 145;
        nArray4[4] = 145;
        nArray4[5] = 37256;
        nArray4[6] = 37259;
        nArray4[7] = 37262;
        nArray4[8] = 255;
        nArray4[9] = 255;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[10];
        nArray5[0] = 146;
        nArray5[1] = 146;
        nArray5[3] = 146;
        nArray5[4] = 146;
        nArray5[5] = 37512;
        nArray5[6] = 37515;
        nArray5[7] = 37518;
        nArray5[8] = 255;
        nArray5[9] = 255;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[10];
        nArray6[0] = 147;
        nArray6[1] = 147;
        nArray6[2] = 147;
        nArray6[4] = 147;
        nArray6[5] = 37768;
        nArray6[6] = 37771;
        nArray6[7] = 37774;
        nArray6[8] = 255;
        nArray6[9] = 255;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[10];
        nArray7[5] = 136;
        nArray7[6] = 139;
        nArray7[7] = 142;
        nArray7[8] = 255;
        nArray7[9] = 255;
        nArrayArray[7] = nArray7;
        int[] nArray8 = new int[10];
        nArray8[0] = 133;
        nArray8[1] = 133;
        nArray8[2] = 133;
        nArray8[3] = 133;
        nArray8[4] = 133;
        nArray8[6] = 140;
        nArray8[7] = 143;
        nArray8[8] = 255;
        nArray8[9] = 255;
        nArrayArray[8] = nArray8;
        int[] nArray9 = new int[10];
        nArray9[0] = 134;
        nArray9[1] = 134;
        nArray9[2] = 134;
        nArray9[3] = 134;
        nArray9[4] = 134;
        nArray9[5] = 137;
        nArray9[7] = 144;
        nArray9[8] = 255;
        nArray9[9] = 255;
        nArrayArray[9] = nArray9;
        int[] nArray10 = new int[10];
        nArray10[0] = 135;
        nArray10[1] = 135;
        nArray10[2] = 135;
        nArray10[3] = 135;
        nArray10[4] = 135;
        nArray10[5] = 138;
        nArray10[6] = 141;
        nArray10[8] = 255;
        nArray10[9] = 255;
        nArrayArray[10] = nArray10;
        nArrayArray[11] = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 192, 255};
        nArrayArray[12] = new int[]{172, 172, 172, 172, 172, 173, 174, 175, 176, 177};
        una = nArrayArray;
        opSymbols = new String[]{"--", "~", "!", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "<RET>"};
        opNames = new String[]{"negation", "bitwise inversion", "logical inversion", "cast to boolean", "cast to byte", "cast to char", "cast to short", "cast to int", "cast to long", "cast to float", "cast to double", "cast to reference", "return"};
        Debug.assert(opNames.length == opSymbols.length && opNames.length == una.length);
    }

    public OPunary(TypesStack typesStk, int code) throws IllegalStateException {
        Debug.assert(code >= 0 && code <= 3);
        if (code == 3) {
            code = 12;
        }
        this.code = code;
        int opTypeID = typesStk.peekID();
        if (una[code][opTypeID] == 255) {
            throw new IllegalStateException("The '" + opNames[code] + "' operation " + "is not supported on " + TypesStack.primitiveTypeNames[opTypeID] + "s");
        }
        typesStk.pop();
        if (code != 12) {
            this.resID = unary_prmtns[opTypeID];
            typesStk.pushID(this.resID, null);
        } else {
            this.resID = opTypeID;
        }
    }

    public OPunary(TypesStack typesStk, int clsID, Class cls, boolean allownarrowing) {
        Debug.assert(clsID >= 0 && clsID <= 8 && (clsID != 8 || cls != null));
        this.code = clsID + 3;
        this.resID = clsID;
        Class currentClass = typesStk.peek();
        if (clsID == 8) {
            this.str_to_tsb = TypesStack.isString(currentClass) && TypesStack.isTSB(cls);
            this.tsb_to_str = TypesStack.isString(cls) && TypesStack.isTSB(currentClass);
            this.resType = cls;
        } else {
            this.resType = TypesStack.primitiveTypes[this.resID];
        }
        if (una[this.code][typesStk.peekID()] == 255) {
            throw new IllegalStateException("Can not convert " + typesStk.peek() + " to " + this.resType + " .");
        }
        if (!allownarrowing && !TypesStack.isWidening(currentClass, this.resType)) {
            throw new IllegalStateException("You must specify narrowing conversion from " + typesStk.peek() + " to " + this.resType + " explicitly.");
        }
        typesStk.pop();
        typesStk.pushID(this.resID, this.resType);
    }

    public OPunary(TypesStack typesStk, Class cls, boolean allownarrowing) {
        this(typesStk, TypesStack.primitiveID(cls), cls, allownarrowing);
    }

    protected void compile(ClassFile cf) {
        if (this.str_to_tsb) {
            cf.code(183);
            cf.codeI(cf.getIndex(sb_constructor, 10));
            cf.typesStk.pop();
            cf.typesStk.pop();
        } else if (this.tsb_to_str) {
            cf.code(182);
            cf.codeI(cf.getIndex(sb_toString, 10));
            cf.typesStk.pop();
            cf.typesStk.pushID(8, string_class);
        } else if (this.code == 2) {
            cf.labels_unblock_not();
        } else {
            cf.ensure_value();
            cf.code(una[this.code][cf.typesStk.peekID()]);
            if (this.code == 1) {
                cf.typesStk.tempExcessWords(TypesStack.stkoccup[this.resID]);
            } else if (this.code == 11) {
                cf.codeI(cf.getIndex(this.resType, 9));
            }
            cf.typesStk.pop();
            if (this.code != 12) {
                cf.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void compile_pre(ClassFile cf) {
        if (this.code == 2) {
            cf.labels_block();
        }
        if (this.str_to_tsb) {
            cf.code(187);
            cf.codeI(cf.getIndex(sb_class, 9));
            cf.code(89);
            cf.typesStk.pushID(8, sb_class);
            cf.typesStk.pushID(8, sb_class);
        }
    }

    protected void eval(OPlist list) {
        if (this.code == 12) {
            return;
        }
        if (!(this.prev instanceof OPload)) {
            return;
        }
        OPload opl = (OPload)this.prev;
        if (this.code == 2) {
            opl.what = ((Boolean)opl.what).booleanValue() ? Boolean.FALSE : Boolean.TRUE;
        } else if (this.code < 2) {
            Number val = TypesStack.widen(opl.what, opl.resID);
            switch (this.code) {
                case 0: {
                    if (opl.resID > 5) {
                        val = new Double(-val.doubleValue());
                        break;
                    }
                    val = new Long(-val.longValue());
                    break;
                }
                case 1: {
                    val = new Long(val.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                default: {
                    Debug.assert(this.code >= 0, "Wrong unary opcode.");
                }
            }
            opl.what = TypesStack.narrow(val, this.resID);
            opl.resID = this.resID;
        } else if (opl.resID != this.resID) {
            opl.what = TypesStack.narrow(TypesStack.widen(opl.what, opl.resID), this.resID);
            opl.resID = this.resID;
        } else if (this.code == 11) {
            if (this.tsb_to_str) {
                opl.what = opl.what.toString();
            }
            if (this.str_to_tsb) {
                opl.what = new StringBuffer((String)opl.what);
            }
        }
        list.remove(this);
    }

    public int getNParams() {
        return 1;
    }

    public String toString() {
        if (this.str_to_tsb) {
            return "->TSB";
        }
        if (this.tsb_to_str) {
            return "TSB->";
        }
        return opSymbols[this.code];
    }
}

