/* screen -- GNUstep specific functions for handling
	     screen information.

   Copyright (C) 2000 Free Software Foundation, Inc.

   Written by: Gregory John Casamento
   Date: Apr 2000
   
   This file is part of GNUstep

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <Foundation/Foundation.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSGraphicsContext.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef XDPS_BACKEND_LIBRARY
#define XGContext       NSDPSContext
#include "gnustep/xdps/NSDPSContextWindow.h"
#include "PXKDrawingEngine.h"
#else
#include "gnustep/xgps/XGContextWindow.h"
#include "gnustep/xgps/XGContextPrivate.h"
#include "XGDrawingEngine.h"
#endif

NSWindowDepth
_computeDepth(int class, int bpp)
{
  int		spp = 0;
  int		bitValue = 0;
  int		bps = 0;
  NSWindowDepth	depth = 0;

  switch (class)
    {
      case GrayScale:
      case StaticGray:
	bitValue = _GSGrayBitValue;
	spp = 1;
	break;
      case PseudoColor:
      case StaticColor:
	bitValue = _GSCustomBitValue;
	spp = 1;
	break;
      case DirectColor:
      case TrueColor:
	bitValue = _GSRGBBitValue;
	spp = 3;
	break;
      default:
	break;
    }

  bps = (bpp/spp);
  depth = (bitValue | bps);

  return depth;
}
     
NSWindowDepth
GSWindowDepthForScreen(NSGraphicsContext *ctxt, int screen_num)
{ 
  Display	*display;
  Screen	*screen;
  int		 class = 0, bpp = 0;

  display = [(id)ctxt xDisplay];
  if (display == NULL)
    {
      return 0;
    }

  screen = XScreenOfDisplay(display, screen_num);
  if (screen == NULL)
    {
      return 0;
    }

  bpp = screen->root_depth;
  class = screen->root_visual->class;

  return _computeDepth(class, bpp);
}

const NSWindowDepth*
GSAvailableDepthsForScreen(NSGraphicsContext *ctxt, int screen_num)
{  
  Display	*display;
  Screen	*screen;
  int		 bpp = 0;
  int		 class = 0;
  int		 index = 0;
  int		 ndepths = 0;
  NSZone	*defaultZone = NSDefaultMallocZone();
  NSWindowDepth	*depths = 0;

  display = [(id)ctxt xDisplay];
  if (display == NULL)
    {
      return NULL;
    }

  screen = XScreenOfDisplay(display, screen_num);
  if (screen == NULL)
    {
      return NULL;
    }

  // Allocate the memory for the array and fill it in.
  ndepths = screen->ndepths;
  class = screen->root_visual->class;
  depths = NSZoneMalloc(defaultZone, sizeof(NSWindowDepth)*(ndepths + 1));
  for (index = 0; index < ndepths; index++)
    {
      int depth = screen->depths[index].depth;
      depths[index] = _computeDepth(class, depth);
    }
  depths[index] = 0; // terminate with a zero.

  return depths;
}
