/* 
   XGDrawingEngine.h

   Copyright (C) 1999 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@gnu.org>
   Date: Jul 1999
   
   This file is part of the GNUstep GUI X/GPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _XGDrawingEngine_h_INCLUDE
#define _XGDrawingEngine_h_INCLUDE

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <Foundation/NSGeometry.h>
#include "gnustep/xgps/XGContext.h"

void XRDrawString(NSString *str, NSRect rect);
void XRDrawXImage(RXImage *xImage, NSRect rect);
void XRDrawLine(NSPoint a, NSPoint b, NSColor *color);
void XRSetCurrentFont(XGFont *aFont);

int _sendXString(Display* display, Window window, const char* string);
Window _findXWindow(Display* display, Window topwindow, Window window_to_check,
		    int x, int y);

#endif
