/* xrtools - Color conversion routines and other low-level X support

   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@boulder.colorado.edu>
   Date: Nov 1994
   
   This file is part of the GNU Objective C User Interface Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#ifndef _xrtools_h_INCLUDE
#define _xrtools_h_INCLUDE

#include "wraster/xrcontext.h"

/* Maintaining and using colormaps */
extern XStandardColormap *xrDefaultColormap(xr_context_t * context);
extern unsigned long xrAllocActualRGB(xr_context_t * context, float red, 
			float green, float blue);

/* Internal conversion of colors to pixels values */
extern u_long	xrGrayToPixel(xr_context_t * context, float gray);
extern u_long	xrRGBToPixel(xr_context_t * context, float red, 
			float green, float blue);
extern u_long	xrHSBToPixel(xr_context_t * context, float h, float s, float b);
extern u_long	xrCMYKToPixel(xr_context_t * context, float c, float m, 
			float y, float k); 
extern u_long	xrColorToPixel(xr_context_t * context, xr_device_color_t color);

extern xr_device_color_t xrConvertToGray(xr_device_color_t color);
extern xr_device_color_t xrConvertToRGB(xr_device_color_t color);
extern xr_device_color_t xrConvertToHSB(xr_device_color_t color);
extern xr_device_color_t xrConvertToCMYK(xr_device_color_t color);


/* Internal conversion of image data to pixel values */
extern u_char	*xrMapColors(xr_context_t * context, u_char **src, int colorspace,
	int bps, int spp, int ncolors, int planar, u_char *dest);

#endif


