#!/usr/bin/env python

from gnuradio import gr, gru, eng_notation
from gnuradio import audio
from gnuradio import usrp
from gnuradio import blks
from gnuradio import tv_rx
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import sys
import math


"""
Reads from a file and generates PAL TV pictures in black and white
which can be displayed using ImageMagick


  # set the center freq of the TV RX tuner to 546 MHz somehow (center
  # of the 8 MHz PAL channel).  This works:

  $ tvrx_wfm_rcv_gui.py -f 546

  # adjust mux as required. This is for TV RX on B side.
  # hit Enter about 1 or 2 seconds after starting it...
  $ usrp_rx_cfile.py -d 8 -c -5.75M --mux=0xf0f0f0f2 -o foo.dat
  

  # -4.0 scale factor; 128 offset; 546  channel center freq
  $ tvrx_tv_rcv.py foo.dat -4.0 128 546

  $ display -size 512x312 gray:pal_out_raw_char.gray

"""

#
# return a gr.flow_graph
#

def build_graph(input_filename, freq,rffreq,sfactor,black_level):
    global plot
    adc_rate = 64e6
    xxx=1
    decim = int(adc_rate/8e6)
    video_rate = adc_rate / decim               # 8 Mhz
    demod_rate = video_rate*2
    #audio_decimation = 8*xxx
    #audio_rate = quad_rate / audio_decimation  # 32 kHz

    fg = gr.flow_graph ()
    
    if input_filename:
        src = gr.file_source(gr.sizeof_gr_complex, input_filename)
    else:
        # usrp is data source
        src = usrp.source_c (0, decim)
        which_side = 1
        if which_side == 0:
            src.set_mux(gru.hexint(0xf0f0f0f0))
        else:
            src.set_mux(gru.hexint(0xf0f0f0f2))
    
        dboard = tv_rx.tv_rx (src, which_side)
        RF_freq = rffreq #freq1 * 1e6
        (success, baseband_freq) = dboard.set_freq(RF_freq)
        assert success
        dboard.set_gain(57)
        IF_freq = RF_freq - baseband_freq
        src.set_rx_freq (0, -IF_freq)
    
    itaps = gr.firdes.low_pass(2,   # gain
                               1,   # sample rate
                               .2,
                               .1,  # should be 0.05
                               gr.firdes.WIN_HAMMING)

    #plot = gru.gnuplot_freqz (gru.freqz (itaps, 1), 1)
    interp = gr.interp_fir_filter_ccf(2, itaps)

    lo = gr.sig_source_c(video_rate*2, gr.GR_SIN_WAVE, 
                         +2.75e6, 1.0)
    mixer = gr.multiply_cc()

    fg.connect(src, interp)
    fg.connect(interp, (mixer, 0))
    fg.connect(lo, (mixer, 1))


    #fg.connect(interp, gr.file_sink(gr.sizeof_gr_complex, "interp.cmplx"))
    #fg.connect(mixer, gr.file_sink(gr.sizeof_gr_complex, "mixer.cmplx"))
    
    am_demod = gr.complex_to_mag ()
        
    dc_restore = gr.add_const_ff(black_level) 

    scale = gr.multiply_const_ff (sfactor)

    #video_lp_coeffs = gr.firdes.low_pass (
    #        1, video_rate, 1e6, 6e6, 
    #        gr.firdes.WIN_HAMMING )
    #
    #video_lp = gr.fir_filter_fff (int(video_rate/demod_rate), video_lp_coeffs )

    float_to_char=gr.float_to_char()

    dst = gr.file_sink (gr.sizeof_char, "pal_out_raw_char.gray")#raw file with short image data, not synchronized yet

    fg.connect (mixer, am_demod, scale, dc_restore, float_to_char, dst)
 
    #demod_rate=sampling_freq/cfir_decimation
    pixels_in_line_pal=demod_rate/(25*625*2)
    pixels_in_line_ntsc=demod_rate/(30*525*2)

    print "You can use the imagemagick display tool to show the resulting imagesequence"
    print "use the following line to show a PAL signal:"
    print "display -size " +str(int(pixels_in_line_pal))+ "x312  gray:pal_out_raw_char.gray"
    print "use the following line to show a NTSC signal:"
    print "display -size " +str(int(pixels_in_line_ntsc))+ "x262  gray:ntsc_out_raw_char.gray"

    return fg
    

def mainx (args):
    nargs = len (args)
    if nargs == 1:
        freq1 = float (args[0]) 
    else:
        sys.stderr.write ('usage: tv_demod_usrp freq1 (Mhz)\n')
        sys.exit (1)

    # connect to RF front end
    #rf_front_end = gr.microtune_4937_eval_board ()
    #if not rf_front_end.board_present_p ():
    #    raise IOError, 'RF front end not found'

    # set front end gain
    #rf_front_end.set_AGC (300)
    #IF_freq = rf_front_end.get_output_freq ()
    IF_freq = 5.75e6

    #rf_front_end.set_RF_freq (freq1)
    fg = build_graph (freq1,IF_freq)

    fg.start ()        # fork thread(s) and return
    raw_input ('Press Enter to quit: ')
    fg.stop ()

def main (args):
    nargs = len (args)
    input_filename = sys.argv[1]   # FIXME
    rffreq=0.0
    if nargs == 4:
                rffreq=float (args[3])* 1e6
    if ((nargs == 3) | (nargs==4)):
                #freq=float (args[0])* 1e6
                freq=0
                sfactor=float (args[1])
                black_level=float(args[2])
    else:
                sys.stderr.write ('usage: ntsc_demod.py iffreq  scale black_levelcorrection [rffreq]\n')
                sys.stderr.write ('frequencies in Mhz\n')
                sys.stderr.write ('Using an 8 bit ADC and an iffreq of 38.9 Mhz (folded back to 11.0625 when using 50 Mhz sampling_freq), a scale factor of -20.0 and a blacklevelcorrection of -22 gave me a reasonable picture for a PAL signal\n')
                sys.stderr.write ('For NTSC I think you need to use a positive scale factor\n')
                sys.exit (1)
    fg = build_graph(input_filename, freq,rffreq,sfactor,black_level)
    #fg.start()
    #raw_input ('Press Enter to quit')
    #fg.stop()
    fg.run()
    
if __name__ == '__main__':
    main (sys.argv[1:])
