#!/usr/bin/env python

from gnuradio import gr, eng_notation
# from gnuradio import usrp
from gnuradio import audio
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import math

from gnuradio.wxgui import stdgui, fftsink
import wx


class fsk_tx_graph (stdgui.gui_flow_graph):
    def __init__(self, frame, panel, vbox, argv):
        stdgui.gui_flow_graph.__init__ (self, frame, panel, vbox, argv)

        parser = OptionParser (option_class=eng_option)
        parser.add_option ("-c", "--cordic-freq", type="eng_float", default=29.32e6,
                           help="set Tx cordic frequency to FREQ", metavar="FREQ")
        parser.add_option ("-f", "--filename", type="string",
                           default="/home/eb/demo/payload.dat",
                           help="read data from FILENAME")
        parser.add_option ("-R", "--repeat", action="store_true", default=False)
        parser.add_option ("-r", "--data-rate", type="eng_float", default=100e3)
        (options, args) = parser.parse_args ()

        print "cordic_freq = %s" % (eng_notation.num_to_str (options.cordic_freq))

        # ----------------------------------------------------------------

        data_rate = options.data_rate
        self.sw_interp = 8
        self.usrp_interp = 128e6 / self.sw_interp / data_rate
        self.fs = 128e6 / self.usrp_interp

        max_deviation = data_rate / 4
        payload_size = 10             # bytes
    
        print "data_rate = ", data_rate
        print "sw_interp = ", self.sw_interp
        print "usrp_interp = ", self.usrp_interp
        print "fs = ", self.fs

        # transmitter pipeline
        
        src = gr.file_source (gr.sizeof_char, options.filename, options.repeat)

        framer = gr.simple_framer (payload_size)
        
        bytes_to_syms = gr.bytes_to_syms ()


        interp_taps =  gr.firdes.low_pass (self.sw_interp,      # gain
                                           self.fs,             # sampling rate
                                           data_rate / 2 * 1.2, # cutoff
                                           data_rate/2 * 0.4,   # trans width
                                           gr.firdes.WIN_HANN)

        print "len = ", len (interp_taps)

        interp = gr.interp_fir_filter_fff (self.sw_interp, interp_taps)

        k = 2 * math.pi * max_deviation / self.fs
        fmmod = gr.frequency_modulator_fc (k)

        gain = gr.multiply_const_cc (2000)

        self.connect (src, framer)
        self.connect (framer, bytes_to_syms)
        self.connect (bytes_to_syms, interp)
        self.connect (interp, fmmod)
        self.connect (fmmod, gain)
        tx_tail = gain                  # end of tx pipeline
        

        if 0:
            post_interp = fftsink.fft_sink_f (self, panel, title="Post Interp", fft_size=512, sample_rate=self.fs)
            self.connect (interp, post_interp)
            vbox.Add (post_interp.win, 1, wx.EXPAND)

        if 0:
            post_mod = fftsink.fft_sink_c (self, panel, title="Post Modulation", fft_size=512, sample_rate=self.fs)
            self.connect (fmmod, post_mod)
            vbox.Add (post_mod.win, 1, wx.EXPAND)

        # receiver pipeline

        self.samples_per_symbol = 8
        self.usrp_decim = 64e6 / self.samples_per_symbol / data_rate
        assert (self.fs == data_rate * self.samples_per_symbol)

        demod_gain = 1
        filter_taps =  gr.firdes.low_pass (1,                   # gain
                                           self.fs,             # sampling rate
                                           data_rate / 2 * 1.1, # cutoff
                                           data_rate,           # trans width
                                           gr.firdes.WIN_HANN)

        print "len = ", len (filter_taps)

        filter = gr.fir_filter_ccf (1, filter_taps)

        # k = 2 * math.pi * max_deviation / self.fs
        fmdemod = gr.quadrature_demod_cf (demod_gain)

        corr = gr.simple_correlator (payload_size)

        filesink = gr.file_sink (gr.sizeof_char, "rx.dat")

        self.connect (tx_tail, filter)
        self.connect (filter, fmdemod)
        self.connect (fmdemod,corr)
        self.connect (corr,filesink)

        if 0:
            fft_input = fftsink.fft_sink_c (self, panel, "Input", 512, self.fs)
            self.connect (tx_tail, fft_input)
            vbox.Add (fft_input.win, 1, wx.EXPAND)


def main ():
    app = stdgui.stdapp (fsk_tx_graph, "FSK Loopback")
    app.MainLoop ()

if __name__ == '__main__':
    main ()
