#!/usr/bin/python

import wx
import threading
import time
import sys

sys.path.append ('.')
sys.path.append ('/usr/local/gnuradio/python')

import powermate

class PowerMateThread (threading.Thread):
    """Get Events from PowerMate, send to Window"""
    def __init__(self,fc=None,**kwds):
        threading.Thread.__init__(self,**kwds)
        self.mypm = powermate.PowerMate()
	self.accel = 0
	self.control_target = 0
        self.keep_running = True
        self.start()
        self.freqcontrol = fc

    def run (self):
        updown_count = 0
        while(self.keep_running):
            event = self.mypm.WaitForEvent(1)
            if (event != None):
                if (event[2] == 1 and event[3] == 256 and event[4] == 1):
                    # Button Pressed
                    self.control_target = (self.control_target + 1) % 4
                    self.accel = 0
                    # print self.control_target
                    
                elif ((event[2] == 2) and (event[3] == 7)):
                    updown_count = updown_count + event[4]
#                    if(self.freqcontrol):
#                        print "not here"
#                        evt = PowerMateEvent(3, updown_count)
#                        wx.PostEvent(self.eventreceiver, evt)

#                    if (self.control_target == 0):
#                        self.FreqDeltaHandler (updown_count)
#                    elif (self.control_target == 1):
#                        self.VolumeDeltaHandler (frame, updown_count)
#                    elif (self.control_target == 2):
#                        self.ModeDeltaHandler (frame, updown_count)
#                    elif (self.control_target == 3):
#                        self.BandDeltaHandler (frame, updown_count)

    def FreqDeltaHandler (self, updown_count):
        if (updown_count == 0):
	    self.accel = self.accel * 0.7
        else:
            self.accel = self.accel * 1.1 + 1
	    if (self.accel > 1000):
	      self.accel = 1000
	    self.freqcontrol.FreqDelta(updown_count * self.accel)

    def VolumeDeltaHandler (self, frame, updown_count):
	if (updown_count == 0):
            self.accel = self.accel * 0.7
	else:
            self.accel = self.accel * 1.1 + 1
	    if (self.accel > 1000):
	        self.accel = 1000
	    frame.VolumeDelta(updown_count * self.accel)

    def ModeDeltaHandler (self, frame, updown_count):
        if (updown_count == 0):
            self.accel = self.accel * 0.7
        else:
	    self.accel = self.accel * 1.1 + 1
	    if (self.accel > 1000):
	        self.accel = 1000
	    frame.ModeDelta(updown_count * self.accel)

    def BandDeltaHandler (self, frame, updown_count):
        if (updown_count == 0):
            self.accel = self.accel * 0.7
        else:
            self.accel = self.accel * 1.1 + 1
	    if (self.accel > 1000):
		    self.accel = 1000
	    frame.BandDelta(updown_count * self.accel)


POWERMATE_EVENT = wx.NewEventType()

def EVT_POWERMATE_EVENT(win, func):
    win.Connect(-1, -1, POWERMATE_EVENT, func)

class PowerMateEvent(wx.PyCommandEvent):
    eventtype = POWERMATE_EVENT
    def __init__(self, windowid):
        wx.PyCommandEvent.__init__(self,self.eventtype,windowid)
        #        self.SetEventType(wxEVT_PMATE)
        #        self.barNum = barNum
        #        self.value = value

    def Clone( self ): 
        self.__class__( self.GetId() ) 
 

if(__name__ == "__main__"):
    try:
        pmate = PowerMateThread()
        use_powermate = 1
        print "wxPowermate started"
    except RuntimeError:
        print "wxPowermate not there"
        use_powermate = 0

    raw_input("Press Enter to quit")
    if(use_powermate):
        pmate.keep_running=False
