/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRFILEDESCRITORSINK_H_
#define _GRFILEDESCRITORSINK_H_

#include <GrSink.h>


/*!
 * \brief a sink that writes to a file descriptor
 *
 * Given an item size and a file descriptor, create a sink that writes
 * binary objects of size itemsize to the given file descriptor.
 *
 * itemsize is in bytes.
 */

class GrFileDescriptorSink : public GrSink
{
private:
  size_t	d_itemsize;
  int		d_fd;

public:
  GrFileDescriptorSink (size_t itemsize, int file_descriptor);
  ~GrFileDescriptorSink ();

  virtual const char *name () { return "GrFileDescriptorSink"; }

  virtual int work3 (VrSampleRange output,
		     VrSampleRange inputs[], void *i[]);
};

#endif
