/*
     This file is part of GNUnet
     (C) 2005, 2006, 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/main_window_create_pseudonym.c
 * @author Christian Grothoff
 *
 */
#include "common.h"

/**
 */
void
GNUNET_GTK_main_menu_create_pseudonym_activate_cb (GtkWidget * dummy, 
						   gpointer data)
{
  GtkWidget *ad;
  GtkBuilder *builder;
  const char *name;
  struct GNUNET_FS_Namespace *ns;

  builder = GNUNET_GTK_get_new_builder ("create_namespace_dialog.glade");
  if (builder == NULL)
    {
      GNUNET_break (0);
      return;
    }
  ad = GTK_WIDGET (gtk_builder_get_object (builder,
					   "GNUNET_GTK_create_namespace_dialog"));
  if (GTK_RESPONSE_OK != gtk_dialog_run (GTK_DIALOG (ad)))
    {
      gtk_widget_destroy (ad);
      g_object_unref (G_OBJECT (builder));
      return;
    }
  name = gtk_entry_get_text (GTK_ENTRY (gtk_builder_get_object (builder,
								"GNUNET_GTK_create_namespace_name_entry")));
  /* FIXME: show busy dialog while doing key creation */
  ns = GNUNET_FS_namespace_create (GNUNET_GTK_get_fs_handle (),
				   name);
  GNUNET_FS_namespace_delete (ns, GNUNET_NO);
  gtk_widget_destroy (ad);
  g_object_unref (G_OBJECT (builder));
}


/* end of main_window_create_pseudonym.c */
