/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/common.h
 * @brief Common includes for all gnunet-gtk source files
 * @author Christian Grothoff
 */
#ifndef COMMON_H
#define COMMON_H

#ifndef HAVE_USED_CONFIG_H
#define HAVE_USED_CONFIG_H
#include "gnunet_gtk_config.h"
#endif
#include <gnunet/platform.h>
#include <gnunet/gnunet_util_lib.h>
#include <gnunet/gnunet_fs_service.h>
#include <extractor.h>
#include <gladeui/glade.h>
#include <gtk/gtk.h>


/**
 * Get the name of the directory where all of our package
 * data is stored ($PREFIX/share/)
 * 
 * @return name of the data directory
 */
const char *
GNUNET_GTK_get_data_dir (void);

/**
 * @brief get the path to a specific GNUnet installation directory or,
 * with GNUNET_IPK_SELF_PREFIX, the current running apps installation directory
 * @author Milan
 * @return a pointer to the dir path (to be freed by the caller)
 */
char *
GNUNET_GTK_installation_get_path (enum GNUNET_OS_InstallationPathKind dirkind);


GdkPixbuf *
GNUNET_GTK_get_thumbnail_from_meta_data (const struct GNUNET_CONTAINER_MetaData *meta);

/**
 * Setup the expiration year adjustment to start with the
 * next year and default to next year plus one.
 */
void
GNUNET_GTK_setup_expiration_year_adjustment (GtkBuilder *builder);

/**
 * Convert the year from the spin button to an expiration
 * time (on midnight, January 1st of that year).
 */
struct GNUNET_TIME_Absolute 
GNUNET_GTK_get_expiration_time (GtkSpinButton *spin);


/**
 * mmap the given file and run the GNUNET_FS_directory_list_contents
 * function on it.
 */
void
GNUNET_GTK_mmap_and_scan (const char *filename,
			  GNUNET_FS_DirectoryEntryProcessor dep,
			  void *dep_cls);


/**
 * Create an initialize a new builder based on the
 * GNUnet-GTK glade file.
 *
 * @param filename name of the resource file to load
 * @return NULL on error
 */
GtkBuilder *
GNUNET_GTK_get_new_builder (const char *filename);

/**
 * Get an object from the main window.
 *
 * @param name name of the object
 * @return NULL on error
 */
GObject *
GNUNET_GTK_get_main_window_object (const char *name);


/**
 * Get LE plugin list.
 */
struct EXTRACTOR_PluginList *
GNUNET_GTK_get_le_plugins (void);


/**
 * Get cfg.
 */
const struct GNUNET_CONFIGURATION_Handle *
GNUNET_GTK_get_configuration (void);


/**
 * Return handle for file-sharing operations.
 * @return NULL on error
 */
struct GNUNET_FS_Handle *
GNUNET_GTK_get_fs_handle (void);


/**
 * Add meta data to list store.
 *
 * @param cls closure (the GtkListStore)
 * @param plugin_name name of the plugin that produced this value;
 *        special values can be used (i.e. '<zlib>' for zlib being
 *        used in the main libextractor library and yielding
 *        meta data).
 * @param type libextractor-type describing the meta data
 * @param format basic format information about data 
 * @param data_mime_type mime-type of data (not of the original file);
 *        can be NULL (if mime-type is not known)
 * @param data actual meta-data found
 * @param data_len number of bytes in data
 * @return 0 to continue (always)
 */ 
int
GNUNET_GTK_add_meta_data_to_list_store (void *cls,
					const char *plugin_name,
					enum EXTRACTOR_MetaType type,
					enum EXTRACTOR_MetaFormat format,
					const char *data_mime_type,
					const char *data,
					size_t data_len);

#endif
/* end of common.h */
