/*
     This file is part of GNUnet
     (C) 2005, 2006, 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/main_window_file_search.c
 * @author Christian Grothoff
 */
#include "common.h"

/**
 * Builder used for the search dialog.
 */
static GtkBuilder *builder;


void
GNUNET_GTK_search_dialog_search_button_clicked_cb (GtkWidget * dummy, 
						   gpointer data)
{
  GtkEntry *query;
  GtkSpinButton *anonymity;
  GtkTreeView *namespace;
  const char *keywords;
  char *emsg;
  struct GNUNET_FS_Uri *uri;

  query = GTK_ENTRY (gtk_builder_get_object (builder,
					     "GNUNET_GTK_search_dialog_keyword_entry"));
  anonymity = GTK_SPIN_BUTTON (gtk_builder_get_object (builder,
						 "GNUNET_GTK_search_dialog_anonymity_spin_button"));
  namespace = GTK_TREE_VIEW (gtk_builder_get_object (builder,
						     "GNUNET_GTK_search_dialog_namespace_tree_view"));
  keywords = gtk_entry_get_text (query);
  /* FIXME: check if namespace was selected */
#if 0
  if (TRUE ==
      gtk_list_model_get_active_iter (model,
				      &iter))
    {
      gtk_list_model_get (model, &iter,
                          NS_SEARCH_DESCRIPTION, &descStr, 
			  NS_SEARCH_NAME, &nsName, 
			  -1);
      // ...
    }      
#endif
  emsg = NULL;
  uri = GNUNET_FS_uri_ksk_create (keywords, &emsg);
  if (uri == NULL)
    {
      GNUNET_log (GNUNET_ERROR_TYPE_ERROR,
		  _("Invalid keyword string `%s': %s"),
		  keywords,
		  emsg);
      GNUNET_free_non_null (emsg);
      return;
    }
  GNUNET_FS_search_start (GNUNET_GTK_get_fs_handle (),
			  uri,
			  gtk_spin_button_get_value_as_int (anonymity),
			  GNUNET_FS_SEARCH_OPTION_NONE,
			  NULL);
  GNUNET_FS_uri_destroy (uri);
}


/**
 * Search selected in 'file' menu.
 */
void
GNUNET_GTK_main_menu_file_search_activate_cb (GtkWidget * dummy, 
					      gpointer data)
{
  GtkWidget *ad;
  GtkListStore *ls;
  
  GNUNET_assert (builder == NULL);
  builder = GNUNET_GTK_get_new_builder ("search_dialog.glade");
  if (builder == NULL)
    return;
  ad = GTK_WIDGET (gtk_builder_get_object (builder,
					   "GNUNET_GTK_search_dialog"));
  ls = GTK_LIST_STORE (gtk_builder_get_object (builder,
					       "GNUNET_GTK_namespace_list_store"));
  /* FIXME: populate 'ls' */
  gtk_dialog_run (GTK_DIALOG (ad));
  gtk_widget_destroy (ad);
  g_object_unref (G_OBJECT (builder));
  builder = NULL;
}

/* end of main_window_file_search.c */
