/*
     This file is part of GNUnet
     (C) 2005, 2006, 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/main_window_file_download.c
 * @author Christian Grothoff
 */
#include "common.h"
#include "download.h"


static GtkBuilder *builder;

void
GNUNET_GTK_open_url_dialog_url_entry_changed_cb (GtkEditable *editable,
						 gpointer user_data)
{
  struct GNUNET_FS_Uri *uri;
  char *perr;
  const char *uris;
  
  perr = NULL;
  uris = gtk_entry_get_text (GTK_ENTRY (gtk_builder_get_object (builder,
								"GNUNET_GTK_open_url_dialog_url_entry")));
  if (uris != NULL)
    uri = GNUNET_FS_uri_parse (uris, &perr);
  else
    uri = NULL;
  gtk_widget_set_sensitive (GTK_WIDGET (gtk_builder_get_object (builder,
								"GNUNET_GTK_open_url_dialog_execute_button")),
			    (uri == NULL) ? FALSE : TRUE);
  if (uri != NULL)
    GNUNET_FS_uri_destroy (uri);
  else
    GNUNET_free_non_null (perr);   
}


/**
 * User selected "Open URI" in main window.
 */
void
GNUNET_GTK_main_menu_file_download_uri_activate_cb (GtkWidget * dummy, 
						    gpointer data)
{
  GtkWidget *ad;
  const char *uris;
  uint32_t anonymity;
  struct GNUNET_FS_Uri *uri;
  char *perr;
  struct DownloadContext *dc;

  GNUNET_assert (builder == NULL);
  builder = GNUNET_GTK_get_new_builder ("open_url_dialog.glade");
  if (builder == NULL)
    {
      GNUNET_break (0);
      return;
    }
  ad = GTK_WIDGET (gtk_builder_get_object (builder,
					   "GNUNET_GTK_open_url_dialog"));
  if (GTK_RESPONSE_OK != gtk_dialog_run (GTK_DIALOG (ad)))
    {
      gtk_widget_destroy (ad);
      g_object_unref (G_OBJECT (builder));
      builder = NULL;
      fprintf (stderr,
	       "Dialog closed!\n");
      return;
    }
  uris = gtk_entry_get_text (GTK_ENTRY (gtk_builder_get_object (builder,
								"GNUNET_GTK_open_url_dialog_url_entry")));
  anonymity = gtk_spin_button_get_value (GTK_SPIN_BUTTON (gtk_builder_get_object (builder,
										  "GNUNET_GTK_open_url_dialog_anonymity_spin_button")));
  uri = GNUNET_FS_uri_parse (uris, &perr);
  gtk_widget_destroy (ad);
  g_object_unref (G_OBJECT (builder));
  builder = NULL;
  if (uri == NULL)
    {
      GNUNET_free (perr);
      /* Why was "execute" button sensitive!? */     
      GNUNET_break (0);
      return;
    }
  if (GNUNET_FS_uri_test_sks (uri) ||
      GNUNET_FS_uri_test_ksk (uri))
    {
      fprintf (stderr,
	       "Starting search!\n");
      GNUNET_break (NULL !=
		    GNUNET_FS_search_start (GNUNET_GTK_get_fs_handle (),
					    uri,
					    anonymity,
					    GNUNET_FS_SEARCH_OPTION_NONE,
					    NULL));
      GNUNET_FS_uri_destroy (uri);
      return;
    }
  if (GNUNET_FS_uri_test_chk (uri) ||
	   GNUNET_FS_uri_test_loc (uri))
    {
      dc = GNUNET_malloc (sizeof (struct DownloadContext));
      dc->uri = uri;
      dc->anonymity = anonymity;
      GNUNET_GTK_open_download_as_dialog (dc);
      return;
    }
  GNUNET_break (0);
  GNUNET_FS_uri_destroy (uri);
}

/* end of main_window_file_download.c */
