/*
     This file is part of GNUnet
     (C) 2005, 2006, 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/fs_anonymtiy_spin_buttons.c
 * @author Christian Grothoff
 *
 * This file contains callbacks to turn spin buttons red when the
 * value reaches zero.
 */
#include "common.h"


/**
 * Spin button is changed, update its colour.
 */
void
GNUNET_GTK_anonymity_spin_button_value_changed_cb (GtkWidget *w, 
						   gpointer data)
{
  GtkSpinButton *spin;
  gint val;
  GdkColor bcolor;
  GdkColor fcolor;

  spin = GTK_SPIN_BUTTON (w);
  if (spin == NULL)
    {
      GNUNET_break (0);
      return;
    }
  val = gtk_spin_button_get_value_as_int (spin);
  if (val == 0)
    {
      if ((TRUE == gdk_color_parse ("red",
                                    &bcolor)) &&
          (TRUE == gdk_colormap_alloc_color (gdk_colormap_get_system (),
                                             &bcolor, FALSE, TRUE)) &&
	  (TRUE == gdk_color_parse ("black",
                                    &fcolor)) &&
          (TRUE == gdk_colormap_alloc_color (gdk_colormap_get_system (),
                                             &fcolor, FALSE, TRUE)))
	{
	  gtk_widget_modify_base (w, GTK_STATE_NORMAL, &bcolor);
	  gtk_widget_modify_text (w, GTK_STATE_NORMAL, &fcolor);
	}
    }
  else
    {
      gtk_widget_modify_base (w, GTK_STATE_NORMAL, NULL);
      gtk_widget_modify_text (w, GTK_STATE_NORMAL, NULL);
    }
}


/* end of fs_anonymtiy_spin_buttons.c */
