# GNU Enterprise Navigator - Setup Script for py2exe
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py 10136 2009-12-19 20:18:28Z reinhard $

import py2exe

from distutils.core import setup


# The manifest will be inserted as resource into .exe files.  This
# gives the controls the Windows XP appearance (if run on XP).
manifest = '''
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
<assemblyIdentity
    version="5.0.0.0"
    processorArchitecture="x86"
    name="Controls"
    type="win32"
/>
<description>GNU Enterprise</description>
<dependency>
    <dependentAssembly>
        <assemblyIdentity
            type="win32"
            name="Microsoft.Windows.Common-Controls"
            version="6.0.0.0"
            processorArchitecture="X86"
            publicKeyToken="6595b64144ccf1df"
            language="*"
        />
    </dependentAssembly>
</dependency>
</assembly>
'''

setup(
    windows = [
        {
            'script': "scripts/gnue-navigator",
            'icon_resources': [(1, "packaging/win32/gnue-32x32.ico")],
            'other_resources': [(24, 1, manifest)]}],
    options = {
        'py2exe': {
            'dll_excludes': [
                "msvcp60.dll", "tcl84.dll", "tk84.dll", "oci.dll"],
            'excludes': ["gnue.navigator", "wx", "mx", "PIL"]
            'compressed': True}})
