# GNU Enterprise Forms - HTML UI Driver - Widget Generator
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: _base.py 8810 2006-10-17 10:11:19Z reinhard $


FIX = 24
FIX2 = 12

def _on_click_event(event):
    return u' onClick="sendCmd(\'event\',\'event=%s\');"' % event

def _on_change_event(id, what):
    return u'onchange="sendCmd(\'onChange\',\'id=%s&text=\'+this.%s)"\n' % (id, what)

def _on_focus_event(id, what):
    return u'onfocus="sendCmd(\'onFocus\',\'id=%s&text=\'+this.%s)"\n' % (id, what)

def _css_position(x,y,width,height):
    return (u'style="position:absolute; top:%spx; left:%spx;'+\
            u' width:%spx; height:%spx;"') % (FIX + y, x, width, height)

def build_tooltip(forid, text):
    return (u'<span dojoType="tooltip" connectId="%s" caption="%s" toggle="fade" '+\
            u'toggleDuration="500"></span>\n') % (forid, text)

def build_label(id, value, x, y, width, height):
    return (u'<div id="%s" %s>%s</div>\n') % \
           (id, _css_position(x,y,width,height-FIX2), value)

def build_entry_label(id, value, x, y, width, height):
    return (u'<div id="%s" %s>%s</div>\n') % \
           (id, _css_position(x,y,width,height-FIX2), value)

def build_entry_checkbox(id, value, label, x, y):
    return (u'<div style="position:absolute; top:%spx; left:%spx">\n'+\
            u'<input type="checkbox" id="%s" dojoType="Checkbox" value="%s" %s %s/>\n'+\
            u'<label for="%s">%s</label></div>\n') % \
           (FIX + y, x, id, value, _on_change_event(id,"value"),
            _on_focus_event(id, "value"), id, label)

def build_entry_default(id, value, x, y, width, height, textbox_style):
    return (u'<div %s><input dojo:type="%s" type="text" id="%s" value="%s"\n %s\n %s ' +\
            u'dojoOnBuild="fixCSS(this);"/></div>\n') % \
           (_css_position(x,y,width,height-FIX2),textbox_style, id, value,  \
           _on_change_event(id,"textbox.value"),_on_focus_event(id, "textbox.value"))
    # dojo:type="Textbox", IntegerTextbox, DateTextbox, TimeTextbox



def build_entry_multiline(id, value, rowcount, x, y, width, height):
    return u'<textarea id="%s" rows="%s" %s\n %s\n %s/>%s</textarea>\n' % \
           (id, rowcount, _css_position(x,y,width,height-4), \
           _on_change_event(id, "value"),_on_focus_event(id, "value"), value)

def _build_choices(choices):
    out = ""
    for i in choices:
        out+=u"<option>%s</option>\n" % i
    return out

def build_entry_listbox(id, value, choices, rows, x, y, width, height):
    return (u'<select id="%s" value="%s" size="%s" %s\n %s\n'+ \
            u'%s>\n%s</select>\n') % \
            (id, value, rows, _css_position(x,y,width,height),
             _on_change_event(id, "value"),_on_focus_event(id, "value"), _build_choices(choices))

def build_entry_combobox(id, value, choices, rows, x, y, width, height):
    return (u'<select id="%s" value="%s" size="%s" dojoType="ComboBox" %s\n %s\n'+ \
            u'%s>\n%s</select>\n') % \
            (id, value, rows, _css_position(x,y,width,height),
             _on_change_event(id, "value"),_on_focus_event(id, "value"), _build_choices(choices))

def _toolbar_toogle_handler(event, event2):
    return (u'toggleItem="true" onmousedown="if (this.isSelected()) ' +\
            u'sendCmd(\'event\',\'event=%s\'); else sendCmd(\'event\',' +\
            '\'event=%s\');"') % (event, event2)

def build_toolbar_button(id, label, event, iconpath, tooltip, toggleItem, enabled):
    return (u'   <img id="%s" dojo:type="ToolbarButton" name="%s" dojo:icon="%s"'+\
            u' %s %s %s />\n    %s\n') % \
            (id, label, iconpath, enabled, _on_click_event(event), \
             (toggleItem and _toolbar_toogle_handler(event, toggleItem) or ""), \
              build_tooltip(id,tooltip))


def build_toolbar_separator(id):
    return u'   <span dojo:type="ToolbarSeparator">&nbsp;</span>\n\n'

def build_toolbar(id, content):
    return (u'<div id="%s" dojo:type="ToolbarContainer">\n'+\
            u'<div dojo:type="toolbar">\n%s\n</div>\n</div>\n\n') % (id, content)

def build_button(id, label, x, y, width, height):
    return u'<input id="%s" type="button" value="%s" %s %s/>\n' % \
                (id, label, _css_position(x,y,width,height),
                 _button_on_click(id))

def _button_on_click(id):
    return u'onclick="sendCmd(\'btn\',\'id=%s\')"' % id

def build_image(id, value, x, y, width, height):
    return u'<image id="%s" src="/images/%s" %s>' % \
           (id, value, _css_position(x,y,width,height))

def build_box(id, label, x, y, width, height):
    return u'<div id="%s" %s z-index:-5; border-width: 1px; border-style: solid">%s</div>' % \
            (id, _css_position(x,y+FIX2,width,height-FIX)[0:-1], label)

def build_page(id, pagename, content):
    return (u"<div id=\"%s\" dojoType=\"ContentPane\" label=\"%s\" " +\
            u'onShow="sendCmd(\'pagechange\',\'page=%s&id=%s\');">\n' +\
            u" %s \n</div>\n") % (id, pagename, pagename, id, content)

def build_splashscreen(forward_url, VERSION):
    return u"""<HTML><HEAD>
<meta http-equiv="refresh" content="4; URL=%s">
</HEAD>
   <BODY>
      <CENTER>
         <IMAGE SRC="splashscreen.png">
         <BR>
         Version: %s
      </CENTER>
    <H1 ALIGN="CENTER"> Please wait while GNUe-Forms is loading ...</H1>
    <A HREF="%s"> Press here!</A>
   </BODY>
</HTML>""" % (forward_url, VERSION, forward_url)

def build_basic_dialog():
    return u"""<table>
            <tr>
                <td><h1 id="basic_title">Warning!</h1></td>
            </tr>
            <tr>
                <td>&nbsp;</td>
            </tr>
            <tr>
                <td id="basic_content"></td>
            </tr>
            <tr>
                <td>&nbsp;</td>
            </tr>
            <tr>
                <td>
                <input type="button" id="basic_button" value="OK"></td>
            </tr>
        </table>
    </form>
"""

def build_error_dialog(msg, main, error):
    return u"""<table>
            <tr>
                <td>Line 1</td>
                <td><input type="text"></td>
            </tr>
            <tr>
                <td>Location:</td>
                <td><input type="text"></td>
            </tr>
            <tr>
                <td>Description:</td>
                <td><input type="text"></td>
            </tr>
            <tr>
                <td>Location:</td>
                <td><input type="file"></td>
            </tr>
            <tr>
                <td>
                <input type="button" id="basic_button" value="OK"></td>
            </tr>
        </table>
    </form>
"""


def build_error_page(type, message):
    return u"""<HTML><HEAD></HEAD><BODY>
            <H1>%s</H1><BR>
            %s</BODY></HTML>
            """ % (message, (type=="restart") and '<A HREF="/">Restart GNUe Forms</A>')

def build_loading_page(message):
    return u"""<HTML><HEAD>
<meta http-equiv="refresh" content="4; ">
</HEAD>
   <BODY>
      <CENTER>
         <IMAGE SRC="splashscreen.png">
         <BR>
      </CENTER>
    <H1 ALIGN="CENTER">%s</H1>
   </BODY>
</HTML>""" % (message)

def build_form(title, header, pages, footer):
    #FIXME: use "labelPosition" in TabContainer
    return u"""<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
      <html>
      <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <meta name="description" content="GNUe Forms - Interactive HTML Frontend" />
      <title>"""+title+"""</title>

      <script type="text/javascript">
        var djConfig = {
               isDebug: true,
               ieClobberMinimal : true,
               debugAtAllCosts: true
           };
        // djConfig.debugAtAllCosts = true;

      </script>
      <script language="javascript" type="text/javascript"  src="/incl/firebug/firebug.js"></script>
      <script type="text/javascript" src="/incl/dojo.js"></script>
      <script language="JavaScript" type="text/javascript">
        if (dojo==undefined) {
           alert("Dojo Toolkit could not be loaded!\\nRestarting...")
           window.location="\"
        }
        dojo.require("dojo.widget.Menu2")
        dojo.require("dojo.widget.ContentPane")
        dojo.require("dojo.widget.TabContainer")
        dojo.require("dojo.widget.ComboBox")
        dojo.require("dojo.widget.Toolbar")
        dojo.require("dojo.debug.console")
        dojo.require("dojo.io")
        dojo.hostenv.writeIncludes()
      </script>
      <script type="text/javascript" src="/incl/gnue.js"></script>
        <style>
          html, body{
          width: 100%;  /* make the body expand to fill the visible window */
          height: 100%;
          overflow: hidden;  /* erase window level scrollbars */
          padding: 0 0 0 0;
          margin: 0 0 0 0;
          }
        .dojoSplitPane{
          margin: 5px;
        }
        #rightPane {
          margin: 0;
        }
        .dojoMenuBar2 {
          border-top:1px solid #d4d4d4;
        }
        .dojoDialog {
          background : #eee;
          border : 1px solid #999;
          -moz-border-radius : 5px;
          padding : 4px;
         }

         </style>
      </head>
      <body>
      <a dojoType="dialog" id="basicDialog" toggle="wipe" toggleDuration="250"
          executeScripts="true" href="base.html"></a>

      """ + header + u"""
      <div dojoType="LayoutContainer"
        layoutChildPriority='top-bottom'
        style="width: 100%; height: 100%;">
        <div id="mainTabContainer" dojoType="TabContainer" sizeMin="20" sizeShare="70" style="width: 100%; height: 100%;">
      """ + pages + u"""
      </div>
      """ + footer + u"""
      </body>
      </html>
      """