# GNU Enterprise Forms - GF Object Hierarchy - Datasources
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GFDataSource.py 9956 2009-10-11 18:54:57Z reinhard $
"""
Logical datasource support
"""

from gnue.common.datasources.GDataSource import GDataSource

# =============================================================================
# Wrapper class for datasources used in GF object trees
# =============================================================================

class GFDataSource(GDataSource):
    """
    A GFDataSource wrapps a L{gnue.common.datasources.GDataSource} object
    """

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent):

        GDataSource.__init__(self, parent, 'GFDataSource')

        self._toplevelParent = 'GFForm'
        self._form = self.findParentOfType('GFForm')
