#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2004-2007 Free Software Foundation
#
# FILE:
# barcodes/code39.py
#
# DESCRIPTION:
"""
Implements the Standard 2 of 5 barcode spec
"""
#

from Base import Barcode

class Standard2of5(Barcode):
  chars = '0123456789'
  mapping = {
    '0': 'N0N0W0W0N0',
    '1': 'W0N0N0N0W0',
    '2': 'N0W0N0N0W0',
    '3': 'W0W0N0N0N0',
    '4': 'N0N0W0N0W0',
    '5': 'W0N0W0N0N0',
    '6': 'N0W0W0N0N0',
    '7': 'N0N0N0W0W0',
    '8': 'W0N0N0W0N0',
    '9': 'N0W0N0W0N0'
  }

  start = '0M0N0'
  stop  = 'M0N0M'

  encodingMap = {
         # Stroke?, X Multiplier, Y Multiplier
    '0': (False, 1, 1),   # Narrow Spaces
    'N': (True, 1, 1),    # Narrow bars
    'M': (True, 2, 1),    # Medium bars
    'W': (True, 3, 1)   # Wide bars
  }

  # calculateLineHeight = Barcode._calculate15 # Unsure of this
  lineWidth = 1 # points -- Unsure of this
  lineHeight = 18 # Actually dependent on the width


if __name__ == '__main__':

  testbar = Standard2of5()

  def test(value, format, file):
    f = open(file,'wb')
    testbar.generate(value,f, format)
    f.close()

#   test('0123456789','png','test1.png')
#   test('9876543210','tiff','test1.tif')
  test('0123456789','eps','s2of5-1.eps')
