#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# GraphicObject.py
#
# DESCRIPTION:
#
# NOTES:
#


import curses

from constants import *

class GraphicObject:
  """
  GraphicObject is the base class for Container: the full screen
  container, as well as for Control: the base class for all of the on-
  screen controls.

  GraphicObject maintains a private dictionary of properties and is used
  heavily throughout to modify appearance and behaviour.  GraphicObject
  methods are mostly concerned with managing data in the _Properties dict.
  """

  _InheritedProperties=[ "LOLIGHT_COLOR", "HILIGHT_COLOR" ]


  def __init__( self, sioScreen, **properties):
    self.__dict__.update(properties)
    self.SCREEN = sioScreen
    self.breakUp = 0
    self.SetColor( colorLow,colorHi)
    self.PRIOR_COLOR = colorLow
    self.active = 1


  def GetProperty(self, pptyName):
    return self.__dict__[pptyName]


  def SetProperty(self, pptyName, pptyVal):
    self.__dict__[pptyName] = pptyVal


  def HasProperty(self, pptyName):
    "Equally well named pptyExists(x)"
    return self.__dict__.has_key(pptyName)


  def IsPropertyInherited( self, pptyName):
    "True if arguement is an inherited property, false otherwise."
    return pptyName in self._InheritedProperties


  def InheritProperties(self, fromObj):
    """
    A beefy method.  InheritProperties uses each element in the private
    list, _InheritedProperties, verifies that each member exists in
    'fromObj' and that it DOESN'T exist in self before adding to self.
    """
    for pptyName in self._InheritedProperties:
      if fromObj.HasProperty(pptyName) and not self.HasProperty(pptyName):
          self.SetProperty(pptyName, fromObj.GetProperty(pptyName))

  #
  # various (of how much) utility methods
  #

  def Verify( self, arg1, arg2, arg3):
    return self.active


  def SetColor( self, color, focusColor=None):
    ""
    if type(color) == type(""):
      color = self.SCREEN.colors.__dict__['C_%s' % color]
    if focusColor == None:
      focusColor = color
    elif type(focusColor) == type(""):
      focusColor = self.SCREEN.colors.__dict__['C_%s' % focusColor]

    self.COLOR = color
    self.FOCUSCOLOR = focusColor


  def LoLight (self):
#    return
    Screen = self.SCREEN
    self._SetLight("LOLIGHT_COLOR", Screen.SetColor, Screen.LoLight)


  def HiLight(self):
    return
    Screen = self.SCREEN
    self._SetLight("HILIGHT_COLOR", Screen.SetColor, Screen.HiLight)

  #
  # private methods
  #

  def _SetLight(self, PropertyName, Setter, DefaultSetter):
    try:
      if curses.has_colors():
        Setter(self.__dict__[PropertyName])
        return
    except (KeyError, AttributeError):
      pass
    DefaultSetter()


