/* This file is generated automatically by (piw log-cogen).
 * Do not edit it.
 */

#include "hackerlab/vu/vu.h"
#include "hackerlab/vu/vfdbuf.h"
#include "hackerlab/vu/printfmt.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/piw-malloc/logging.h"
#include "hackerlab/piw-malloc/log-printing.h"


struct piw_formatter piw_formatters[] = 
{
  {"malloc", piw_text_log_malloc},
  {"realloc", piw_text_log_realloc},
  {"free", piw_text_log_free},
  {"malloc_call", piw_text_log_malloc_call},
  {"realloc_call", piw_text_log_realloc_call},
  {"free_call", piw_text_log_free_call},
  {"bogus_realloc", piw_text_log_bogus_realloc},
  {"bogus_free", piw_text_log_bogus_free},
  {"bogus_malloc_padding", piw_text_log_bogus_malloc_padding},
  {"bogus_malloc_fill", piw_text_log_bogus_malloc_fill},
  {"bogus_malloc_meta_data", piw_text_log_bogus_malloc_meta_data},
  {"malloc_tags_map_overflow", piw_text_log_malloc_tags_map_overflow},
  {"block_write", piw_text_log_block_write},
  {"block_read", piw_text_log_block_read},
  {"bad_block_write", piw_text_log_bad_block_write},
  {"bad_block_read", piw_text_log_bad_block_read},
  {"rm", piw_text_log_rm},
  {"wm", piw_text_log_wm},
  {"bad_write", piw_text_log_bad_write},
  {"bad_read", piw_text_log_bad_read},
  {"init", piw_text_log_init},
  {"sequence", piw_text_log_sequence},
  {"stray_write", piw_text_log_stray_write},
  { 0, 0 }
};

void
piw_text_log_malloc (int fd, struct piw_malloc_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(malloc %d %d %lu)\n",
                    data->call_number,
                    data->amt_requested,
                    (t_ulong)data->new_block))
    panic ("I/O error while printing record");
}

void
piw_text_log_realloc (int fd, struct piw_realloc_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(realloc %d %lu %d %lu)\n",
                    data->call_number,
                    (t_ulong)data->block,
                    data->amt_requested,
                    (t_ulong)data->new_block))
    panic ("I/O error while printing record");
}

void
piw_text_log_free (int fd, struct piw_free_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(free %d %lu)\n",
                    data->call_number,
                    (t_ulong)data->block))
    panic ("I/O error while printing record");
}

void
piw_text_log_malloc_call (int fd, struct piw_malloc_call_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(malloc-call %d %d %lu)\n",
                    data->call_number,
                    data->amt_requested,
                    data->caller_address))
    panic ("I/O error while printing record");
}

void
piw_text_log_realloc_call (int fd, struct piw_realloc_call_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(realloc-call %d %lu %d %lu)\n",
                    data->call_number,
                    (t_ulong)data->block,
                    data->amt_requested,
                    (t_ulong)data->caller_address))
    panic ("I/O error while printing record");
}

void
piw_text_log_free_call (int fd, struct piw_free_call_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(free-call %d %lu %lu)\n",
                    data->call_number,
                    (t_ulong)data->block,
                    (t_ulong)data->caller_address))
    panic ("I/O error while printing record");
}

void
piw_text_log_bogus_realloc (int fd, struct piw_bogus_realloc_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bogus-realloc %d %lu)\n",
                    data->call_number,
                    (t_ulong)data->location))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_bogus_free (int fd, struct piw_bogus_free_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bogus-free %d %lu)\n",
                    data->call_number,
                    (t_ulong)data->location))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_bogus_malloc_padding (int fd, struct piw_bogus_malloc_padding_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bogus-malloc-padding %lu %lu)\n",
                    (t_ulong)data->block,
                    (t_ulong)data->location))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_bogus_malloc_fill (int fd, struct piw_bogus_malloc_fill_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bogus-malloc-fill %lu %lu)\n",
                    (t_ulong)data->block,
                    (t_ulong)data->location))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_bogus_malloc_meta_data (int fd, struct piw_bogus_malloc_meta_data_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bogus-malloc-meta-data %lu)\n",
                    (t_ulong)data->location))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_malloc_tags_map_overflow (int fd, struct piw_malloc_tags_map_overflow_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(malloc-tags-map-overflow)\n"))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_block_write (int fd, struct piw_block_write_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(block-write %lu %lu %d)\n",
                    (t_ulong)data->location,
                    (t_ulong)data->origin,
                    data->size))
    panic ("I/O error while printing record");
}

void
piw_text_log_block_read (int fd, struct piw_block_read_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(block-read %lu %lu %d)\n",
                    (t_ulong)data->location,
                    (t_ulong)data->origin,
                    data->size))
    panic ("I/O error while printing record");
}

void
piw_text_log_bad_block_write (int fd, struct piw_bad_block_write_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bad-block-write %lu %lu %d)\n",
                    (t_ulong)data->location,
                    (t_ulong)data->origin,
                    data->size))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_bad_block_read (int fd, struct piw_bad_block_read_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bad-block-read %lu %lu %d)\n",
                    (t_ulong)data->location,
                    (t_ulong)data->origin,
                    data->size))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_rm (int fd, struct piw_rm_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(rm %lu %d)\n",
                    (t_ulong)data->location,
                    data->size))
    panic ("I/O error while printing record");
}

void
piw_text_log_wm (int fd, struct piw_wm_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(wm %lu %d)\n",
                    (t_ulong)data->location,
                    data->size))
    panic ("I/O error while printing record");
}

void
piw_text_log_bad_write (int fd, struct piw_bad_write_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bad-write %lu %d)\n",
                    (t_ulong)data->location,
                    data->size))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_bad_read (int fd, struct piw_bad_read_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(bad-read %lu %d)\n",
                    (t_ulong)data->location,
                    data->size))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_init (int fd, struct piw_init_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(init %d)\n",
                    data->pid))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

void
piw_text_log_sequence (int fd, struct piw_sequence_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(sequence %d)\n",
                    data->seq))
    panic ("I/O error while printing record");
}

void
piw_text_log_stray_write (int fd, struct piw_stray_write_data * data)
{
  int errn;
  if (0 > printfmt (&errn, fd,
                    "(stray-write %lu)\n",
                    (t_ulong)data->location))
    panic ("I/O error while printing record");
  if (0 > vfdbuf_flush (&errn, fd))
    panic ("I/O error flushing text-log buffer");
}

