'\" t
.\" Copyright (c) 2000 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH dbconfig 5 "January 2000" "GNATS @VERSION@" "GNATS Admininstration Files"
.SH NAME
dbconfig \- GNATS database configuration file
.SH DESCRIPTION
The dbconfig configuration file is, oddly enough, used to control
the configuration of a GNATS database.  Each database has its own
individual copy of the file, which is located in the \fBgnats-adm\fR
administrative subdirectory of the database.
.P
The file contains 6 major sections, which must appear in this order:
.P
.RS 0.5i
.br
Overall database configuration
.br
Individual field configuration
.br
Named query definitions
.br
Audit-trail and outgoing email formats
.br
Index file description
.br
Initial \fIPR\fR input fields
.RE
.P
Individual descriptions of each section will appear below.  (It is
helpful to refer to the supplied default configuration, which contains
examples of most of the available configuration options.)
.P
It is very helpful if the administrator has a reasonably good
understanding of the overall GNATS \fIPR\fR process before trying to
create or edit a database configuration.
.SH "FILE FORMAT"
The file is a free-form ASCII file.  Whitespace is completely
optional, and is ignored.  Braces ({}) are used to delimit sections
within the file.  Non-keyword values must generally be surrounded with
double quotes. Newline characters within double quotes must be
proceeded with a backslash (`\\') character, and are not included in
the final resulting string; to include a newline character in a value,
use the \fB\\n\fR combination instead.
.SH "Overall Database Configuration"
The overall database options are controlled with the \fBdatabase-info\fR
section:
.P
.RS 0.5i
\fBdatabase-info\fR {
.RS 0.25i
[\fIoptions\fR]
.RE
}
.RE
The following options may be present:
.TP
\fBdebug-mode\fR \fItrue\fR|\fIfalse\fR
If set to true, the database is placed into \fIdebug mode\fR.  This
causes all outgoing email to be sent to the \fIgnats-admin\fR user
listed in the \fBresponsible\fR adm file.
.RS 0.5i
.P
The default value is \fIfalse\fR.
.RE
.TP
\fBkeep-all-received-headers\fR \fItrue\fR|\fIfalse\fR
If set to true, all of the Received: headers for \fIPR\fRs submitted via
email are kept in the PR; otherwise, only the first one is kept.
.RS 0.5i
.P
The default value is \fIfalse\fR.
.RE
.TP
\fBnotify-about-expired-prs\fR \fItrue\fR|\fIfalse\fR
If set to true, notification email about expired \fIPR\fRs is sent via
the at-pr command.  Otherwise, required times for \fIPR\fR fixes
are not used.
.RS 0.5i
.P
The default value is \fIfalse\fR.
.RE
.TP
\fBsend-submitter-ack\fR \fItrue\fR|\fIfalse\fR
When new \fIPRs\fR are submitted to the database, an acknowledgement
email will be sent to the submitter if \fBsend-submitter-ack\fR is set
to true.  This is in addition to the normal notification mail to the
person(s) responsible for the new \fIPR\fR.
.RS 0.5i
.P
The default value is \fIfalse\fR.
.RE
.TP
\fBlibexecdir\fR "\fIpath\fR"
Used to specify the directory where the GNATS adminstrative
executables can be found; in particular, \fBat\-pr\fR and
\fBmail\-pr\fR are invoked from this directory.
.RS 0.5i
.P
The default value is the empty string, which is unlikely to be useful.
.RE
.TP
\fBbusiness-day-hours\fR \fIday-start\fR \- \fIday-end\fR
Used to specify the hours that define a business day in 24-hour
format; the times are inclusive.  A single dash separates the two
values.  The values are used to determine if a \fIPR\fR required
completion time has expired.
.RS 0.5i
.P
The default values are 8 for \fIday-start\fR, and 17 for \fIday-end\fR.
.RE
.TP
\fBbusiness-week-days\fR \fIweek-start\fR \- \fIweek-end\fR 

Used to specify the start and ending days of the business week, where
0 is Sunday, 1 is Monday, etc; the days are inclusive. These values
are used to determine if a \fIPR\fR required completion time has
expired.
.RS 0.5i
.P
The default values are 1 for \fIweek-start\fR, and 5 for \fIweek-end\fR.
.RE
.TP
\fBcreate-category-dirs\fR \fItrue\fR|\fIfalse\fR

If set to true, database directories for categories are automatically
created as needed; otherwise, they must be created manually (usually
with the \fBmkcat\fR script).  It is suggested that the value be left
to \fItrue\fR.
.RS 0.5i
.P
The default value is \fItrue\fR.
.RE

.SH "Individual field configuration"
Each field in a PR is described with a field entry. It has the general 
structure
.RS
\fBfield\fR "\fIfieldname\fR" {
.RS 0.25i
\fBdescription\fR "\fIstring\fR"
.br
[ \fIfield-options\fR ... ]
.br
\fIdatatype\fR [ \fIdatatype-options\fR ... ]
.br
[ \fBon-change\fR { \fIedit-options\fR ... } ]
.RE
}
.RE
.P
\fIfieldname\fR is used as the field header in the \fIPR\fR.  The
\fB>\fR and \fB:\fR field markers should not be present in the name.
.P
The order in which the field configurations appear in the
configuration file determines the order that they appear in the PR
text.  There is no required order, unlike previous versions of GNATS;
multitext and the Unformatted fields can appear anywhere in the PR.
.P
The following options may be present within the \fBfield\fR section:
.TP
\fBbuiltin-name\fR "\fRname\fR"
Indicates that this field corresponds to one of the GNATS builtin
fields.
.RS
.P
GNATS has several fields which are required to be present in a
\fIPR\fR, and this option is used to map their external descriptions
to their internal usage.  The internal fieldnames are:
.P
.TS
l l
l l.
\fBName	Meaning\fR
number	The PR's unique numeric identifier
category	The category that the PR falls into
synopsis	The one-line description of the PR
confidential	If "yes", the PR is confidential
severity	How severe is the PR?
priority	What's the PR's priority?
responsible	Who's responsible for the PR?
state	What's the frequency, Kenneth?
submitter	The user that submitted the PR
arrival-date	When did the PR arrive?
last-modified	The date of the last PR modification
audit-trail	The audit-trail of various changes to the PR
.TE
.P
For these builtin fields, a matching field description must appear in
the database configuration.  Otherwise, the configuration will be
considered invalid, and errors will be generated from the GNATS
clients and \fBgnatsd\fR.
.RE
.TP
\fBdescription\fR "\fIdescription text\fR"
A one-line human-readable description of the field.  Clients
can use this string to describe the field in a help dialog; the
string is returned from the \fBFDSC\fR command in \fBgnatsd\fR,
and is also available via the \fB\-\-field-description\fR option
in \fBquery\-pr\fR.
.RS 0.5i
.P
This entry must be present in the field description; there is no default
value.
.RE
.TP
\fBquery-default\fR \fIexact-regexp\fR|\fIinexact-regexp\fR
Used to specify the default type of searches performed on this field.
This is used when the \fB^\fR search operator appears in a query, and
is also used for queries in \fBquery\-pr\fR that use the old \fI\-\-field\fR
query options.
.RS 0.5i
.P
If the option is not given, the default search is \fIexact\-regexp\fR).
.RE
.TP
\fBtextsearch\fR
If this option is present, the field will be searched when the user
performs a --text search from \fBquery-pr\fR.  The field is also
flagged as a \fItextsearch\fR field in the set of field flags returned
by the \fBFIELDFLAGS\fR command in \fBgnatsd\fR.
.P
.RS 0.5i
By default, fields are not marked as \fItextsearch\fR fields.
.RE
.TP
\fBread-only\fR
The field contents may not be edited; they must be set when the PR
is initially created.  In general, this should only be used for fields that
are given internal values rather than fields supplied by the user.
.P
.RS 0.5i
By default, fields are editable by the user.
.RE
.SH Field datatypes
.TP
\fIdatatype\fR [ \fIoptions\fR ... ]
Describes the type of data to be stored in the field, and must be present
in each field description.
.P
.RS
The available datatypes are:
.RE
.TP
\fBtext\fR [ \fBmatching\fR { "\fIregexp\fR" [ "\fIregexp\fR" ... ]  } ]
The text datatype is the most commonly used type; it is a one-line
text string.
.P
.RS
If the \fBmatching\fR qualfifier is present, the data in the field
must match at least one of the specified regexps.  Otherwise, no
restriction is placed on what values may appear in the field.
.P
.RE
.TP
\fBmultitext\fR [ { \fBdefault\fR "\fIstring\fR" } ]
The field can contain multiple lines of text.
.P
.RS
If the \fBdefault\fR option is present, the field will default to the
specified \fIstring\fR if the field is not given a value when the
\fIPR\fR is initially created.  Otherwise, the field will be left
empty.
.RE
.ne 8
.TP
\fBenum\fR {
.RS 0.25i
\fBvalues\fR {
.RS 0.25i
"\fIstring\fR" [ "\fIstring\fR" ... ]
.RE
}
.br
[ \fBdefault\fR "\fIstring\fR" ] 
.RE
}
.P
.RS
Defines an enumerated field, where the value in the PR field must
match an entry from a list of specified values.  
.P
The list of allowed values is given with the \fBvalues\fR option,
which must be present.
.P
If a \fBdefault\fR option is present, it is used to determine the
initial value of the field if no entry for the field appears in an
initial PR (or if the value in the initial PR is not one of the
acceptable values).  However, the value in the \fBdefault\fR
statement is not required to be one of the accepted values; this can
be used to allow the field to be initially empty, for example.
.P
If no \fBdefault\fR option is specified, the default value for the
field is the first value in the \fBvalues\fR section.
.RE
.TP
\fBmultienum\fR {
.RS 0.25i
\fBvalues\fR {
.RS 0.25i
"\fIstring\fR" [ "\fIstring\fR" ... ]
.RE
}
.br
[ \fBseparators\fR "\fIstring\fR" ]
.br
[ \fBdefault\fR "\fIstring\fR" ] 
.RE
}
.P
.RS
The \fBmultienum\fR datatype is similar to the \fBenum\fR datatype,
except that the field can contain multiple values, separated by one or
more characters from the \fIseparators\fR list.
.P
If no \fBseparators\fR option is present, the default separators are
space (` ') and colon (':').
.RE
.ne 8
.TP
\fBenumerated-in-file\fR {
.RS 0.25i
\fBpath\fR "\fIfilename\fR"
.br
\fBfields\fR {
.RS 0.25i
"\fIname\fR" [ "\fIname\fR" ... ]
.RE
} \fBkey\fR "\fIname\fR"
.br
[ \fBallow-any-value\fR ]
.RE
}
.RS
The \fBenumerated-in-file\fR type is used to describe an enumerated
field with an associated \fIadministrative file\fR, which lists the
legal values for the field, and may optionally contain additional
fields that can be examined by query clients or used for other
internal purposes.  It is similar to the \fBenum\fR datatype, except
that the list of legal values is stored in a separate file.
.P
\fIfilename\fR is the name of a file in the \fBgnats-adm\fR administrative
directory for the database.
.P
The format of the administrative file is a simple ASCII text file.
Fields within the file are separated with colons (`:').  Lines
beginning with an octothorpe ('#') are ignored as comments.  Records
within the file are separated with newlines.
.P
The \fBfield\fR option is used to name the fields in the
administrative file. There must be at least one field, which is used
to list the legal values for the field.  If the administrative file is
empty (or does not contain any non-empty non-comment lines) then the
PR field must be empty.
.P
The \fBkey\fR option is used to designate which field in the
administrative file should be used to list the legal values for the PR
field.  The value must match one of the field names in the \fBfield\fR
option.
.P
If the \fBallow-any-value\fR option is present, then the value of the
PR field is not required to appear in the administrative file; any
value will be accepted.
.RE
.TP
\fBdate\fR
The date datatype is used to hold dates.  Date fields may be empty, or
must contain a correctly-formatted date.
.P
.RS
No defaults or other options are available.  The field is left empty if
no value for the field is given in the initial PR.
.RE
.TP
\fBinteger\fR [ { \fBdefault\fR "\fIinteger\fR" } ]
Integer fields are used to hold numbers.  They may be empty, or must
contain a value composed entirely of digits, with an optional leading
sign.
.P
.RS
If the \fBdefault\fR option is present, the field will have the
value of \fIinteger\fR if the field is not given a value when the
\fIPR\fR is initially created.  Otherwise, the field will be left
empty.
.RE
.SH "Edit controls"
The \fBon-change\fR section is used to specify one or more actions
to be performed when the field value is edited by the user.  It
has the general form
.RS
\fBon-change\fR [ "\fIquery-expression\fR" ] {
.P
.RS 0.25i
[ \fBadd-audit-trail\fR ]
.P
[ \fBaudit-trail-format {
.RS 0.25i
\fBformat\fR "\fIformatstring\fR"
.br
[ fields { "\fIfieldname\fR" ... } ]
.RE
} ]
.P
[ \fBrequire-change-reason\fR ]
.P
[ \fBset-field\fR|\fBappend-to-field\fR "\fIfieldname\fR" {
.RS 0.25i
"\fIformat-string\fR" [ \fIfieldlist\fR ]
.RE
} ]
.RE
}
.RE
.P
The optional \fIquery-expression\fR controls whether or not the
actions in the \fBon-change\fR section are taken.  If the expression
fails to match, the actions are skipped.
.P
The \fBadd-audit-trail\fR option indicates that an entry should be
appended to the builtin audit-trail field when this field is changed.
The format of the entry is controlled by the optional
\fBaudit-trail-format\fR section within the field, or by the global
\fBaudit-trail-format\fR section.  (See the \fBAudit-trail and
outgoing email formats\fR section for more information.)
.P
The \fBrequire-change-reason\fR option specifies that a change reason
must be present in the PR when this field is edited.  This option only
makes sense if an audit-trail entry is required, as the change reason
is otherwise unused.
.P
The \fBset-field\fR and \fBappend-to-field\fR options are used to
change the value of the field \fIfieldname\fR in the PR.  The supplied
\fBformat\fR is used to format the value that will be placed in the
field (for more information, see the \fBAudit-trail and outgoing email
formats\fR section of this manual).  \fBappend-to-field\fR appends the
resulting formatted string to the existing field contents, while
\fBset-field\fR completely replaces the contents.
.P
Any field may be edited by the \fBset-field\fR or
\fBappend-to-field\fR option (the \fBread-only\fR option on a field is
ignored).  However, the changes are subject to the usual field content
checks.
.P
There is a global \fBon-change\fR section that is executed once for
each \fIPR\fR edit.
.SH "Named query definitions"
When queries are performed via \fBquery\-pr\fR, they can refer to
a query format described via the \fBquery\fR section:
.RS
\fBquery\fR "\fIqueryname\fR" {
.RS 0.25i
\fBformat\fR "\fIformatstring\fR"
.br
[ \fBfields\fR { "\fIfieldname\fR" [ "\fIfieldname\fR" ... ] } ]
.RE
}
.RE
\fIformatstring\fR is as described in the \fBquery-pr\fR(1) manpage;
it contains a string with \fBprintf\fR(3)-like % escapes.  The output
of the query is then formatted as specified by the format string.
.P
The \fBfields\fR option lists the fields to be used with the
\fBformat\fR string.  If the \fBfields\fR option is present without a
\fBformat\fR option is, then the listed fields are printed out as just
their contents separated by newlines.
.P
The named query formats \fIfull\fR, \fIstandard\fR and \fIsummary\fR
must be present in the database configuration. \fBfull\fR and
\fBsummary\fR correspond to the \fBquery\-pr\fR options \fB--full\fR
and \fB--summary\fR, while \fIstandard\fR is used when no format
option is given to \fBquery\-pr\fR.
.SH "Audit-trail and outgoing email formats"
These formats are smilar to the named query formats, but they include
more options.  They are used for formatting audit-trail entries and
for outgoing email messages.
.P
There is currently only one audit-trail format, defined by the
\fBaudit-trail-format\fR option:
.RS
\fBaudit-trail-format\fR {
.RS 0.25i
\fBformat\fR "\fIformatstring\fR"
.br
[\fBfields\fR { "\fIfieldname\fR" [ "\fIfieldname\fR" ... ] } ]
.RE
}
.RE
For those fields that require an audit-trail entry, the audit-trail
text to be appended is formatted as described by this format.  The
per-field \fBaudit-trail-format\fR is used in preference to this one,
if it exists.
.P
\fIformatstring\fR and \fIfieldname\fR are similar to those used by
the named query format.  \fIfieldname\fR may also be a \fIformat
parameter\fR, which is a context-specific value.  [Format parameters
are distinguished from fieldnames by a leading dollarsign (`$').]
.P
The following format parameters are defined for
\fBaudit-trail-format\fR entries:
.TP
\fB$FieldName\fR
The name of the field for which an audit-trail entry is being created.
.TP
\fB$OldValue\fR
The old value of the field.
.TP
\fB$NewValue\fR
The new field value.
.TP
\fB$EditUserEmailAddr\fR
The email address of the user editing the field.
.TP
\fB$CurrentDate\fR
The current date.
.TP
\fB$ChangeReason\fR
The reason for the change; may be blank if no reason was supplied.
.P
These parameters may be used anywhere a \fIfieldname\fR can appear.


.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (7),
.BR send-pr (1),
.BR edit-pr (1),
.BR query-pr (1),
.BR file-pr (8),
.BR queue-pr (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkcat (8).
.SH COPYING
Copyright (c) 2000 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
