/* Miscellaneous variables used by queries.
   Copyright (C) 1997 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"

/* How we should print out the format of the PR.  */
unsigned int query_format = FORMAT_REG;

/* What list we're interested in seeing.  */
unsigned int list_format = 0;

/* Whether or not to search the text fields, and the regexp to
   search for.  */
char *text_search = NULL;

/* Whether or not to search the multitext fields, and the regexp to
   search for.  */
char *m_text_search = NULL;

/* Whether or not we're searching more than one (or every) PR.  */
int searching = 0;

/* If 1, don't talk about closed PRs.  */
int skip_closed = 0;

/* If 1, print a string like "/gnats/GNATS/g++/145:0:" for the
   emacs next-error function.  */
int print_path = 0;

/* If 1, don't emit any errors from get_pr.  */
int quiet = 0;

/* If specified, search for the originator of this PR.  */
char *originator = NULL;

/* If specified, search for the class of this PR.  */
char *class = NULL;

/* Look for PRs that arrived before this date.  */
time_t arrived_before = (time_t)0;

/* Look for PRs that arrived after this date.  */
time_t arrived_after = (time_t)0;

/* Look for PRs which were closed before this date.  */
time_t closed_before = (time_t)0;

/* Look for PRs which were closed after this date.  */
time_t closed_after = (time_t)0;

/* Look for PRs which were modified before this date.  */
time_t modified_before = (time_t)0;

/* Look for PRs which were modified after this date.  */
time_t modified_after = (time_t)0;

#ifdef GNATS_RELEASE_BASED
/* Look for PRs required before this date.  */
time_t required_before = (time_t)0;

/* Look for PRs required after this date.  */
time_t required_after = (time_t)0;

/* If specified, search for the quarter of this PR.  */
char *quarter = NULL;

/* If specified, search for the keywords of this PR.  */
char *keywords = NULL;
#endif

/* If specified, search for the synopsis of this PR.  */
char *synopsis = NULL;

/* If specified, search for the release of this PR.  */
char *release = NULL;

/* Where the results of query-pr should go.  */
FILE *outfile = NULL;
