#!/bin/sh

if [ -z "$2" ]; then
	echo "Usage: `basename $0` <gnash_srcdir> <gnash_builddir>" >&2
	exit 1
fi

TESTDIR=$1
BUILDDIR=$2
PASSFILE="${TESTDIR}/PASSING"

TESTER="${BUILDDIR}/../../utilities/gprocessor -v -r0 -f 10 "

cat<<EOF
#!/bin/sh

# Generated by gen-swfmill-trace-runner
EOF

echo -n TESTS=\"

for tracetest in `ls ${TESTDIR}/*.trace`; do
	testname=`basename ${tracetest} | sed -e s/\\\.trace//g`
	echo -n "${testname} "
done
echo \"

cat<<EOF

for testcase in \$TESTS; do

	expectpass=no
	if grep -q "^\${testcase}\$" ${PASSFILE}; then
		expectpass=yes
	fi

	out=\${testcase}.out
	$TESTER ${BUILDDIR}/\${testcase}.swf | grep TRACE -A1 | sed '/^--$/d; s/.*TRACE: //; /\n*[0-9]:[0-9]*\].*/d; s/^$//;' > \$out
	diff -q ${TESTDIR}/\${testcase}.trace \$out >/dev/null
	if [ \$? -ne 0 ]; then
		if [ x"\${expectpass}" = "xyes" ]; then
			echo FAILED: \${testcase}
		else
			echo XFAILED: \${testcase}
		fi
	else
		if [ x"\${expectpass}" = "xyes" ]; then
			echo PASSED: \${testcase}
		else
			echo XPASSED: \${testcase}
		fi
	fi
done


EOF
