/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem.linalg;

import gnu.gleem.linalg.Matf;
import gnu.gleem.linalg.Rotf;
import gnu.gleem.linalg.Vec3f;
import gnu.gleem.linalg.Vec4f;

public class Mat4f {
    private float[] data = new float[16];

    public void makeIdent() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                } else {
                    this.set(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
    }

    public void set(Mat4f arg) {
        float[] mine = this.data;
        float[] yours = arg.data;
        int i = 0;
        while (i < mine.length) {
            mine[i] = yours[i];
            ++i;
        }
    }

    public float get(int i, int j) {
        return this.data[4 * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[4 * i + j] = val;
    }

    public void setTranslation(Vec3f trans) {
        this.set(0, 3, trans.x());
        this.set(1, 3, trans.y());
        this.set(2, 3, trans.z());
    }

    public void setRotation(Rotf rot) {
        rot.toMatrix(this);
    }

    public void setRotation(Vec3f x, Vec3f y, Vec3f z) {
        this.set(0, 0, x.x());
        this.set(1, 0, x.y());
        this.set(2, 0, x.z());
        this.set(0, 1, y.x());
        this.set(1, 1, y.y());
        this.set(2, 1, y.z());
        this.set(0, 2, z.x());
        this.set(1, 2, z.y());
        this.set(2, 2, z.z());
    }

    public void getRotation(Rotf rot) {
        rot.fromMatrix(this);
    }

    public void invertRigid() {
        float t = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, t);
        t = this.get(0, 2);
        this.set(0, 2, this.get(2, 0));
        this.set(2, 0, t);
        t = this.get(1, 2);
        this.set(1, 2, this.get(2, 1));
        this.set(2, 1, t);
        Vec3f negTrans = new Vec3f(-this.get(0, 3), -this.get(1, 3), -this.get(2, 3));
        Vec3f trans = new Vec3f();
        this.xformDir(negTrans, trans);
        this.set(0, 3, trans.x());
        this.set(1, 3, trans.y());
        this.set(2, 3, trans.z());
    }

    public Mat4f mul(Mat4f b) {
        Mat4f tmp = new Mat4f();
        tmp.mul(this, b);
        return tmp;
    }

    public void mul(Mat4f a, Mat4f b) {
        int rc = 0;
        while (rc < 4) {
            int cc = 0;
            while (cc < 4) {
                float tmp = 0.0f;
                int i = 0;
                while (i < 4) {
                    tmp += a.get(rc, i) * b.get(i, cc);
                    ++i;
                }
                this.set(rc, cc, tmp);
                ++cc;
            }
            ++rc;
        }
    }

    public void xformVec(Vec4f src, Vec4f dest) {
        int rc = 0;
        while (rc < 4) {
            float tmp = 0.0f;
            int cc = 0;
            while (cc < 4) {
                tmp += this.get(rc, cc) * src.get(cc);
                ++cc;
            }
            dest.set(rc, tmp);
            ++rc;
        }
    }

    public void xformPt(Vec3f src, Vec3f dest) {
        int rc = 0;
        while (rc < 3) {
            float tmp = 0.0f;
            int cc = 0;
            while (cc < 3) {
                tmp += this.get(rc, cc) * src.get(cc);
                ++cc;
            }
            dest.set(rc, tmp += this.get(rc, 3));
            ++rc;
        }
    }

    public void xformDir(Vec3f src, Vec3f dest) {
        int rc = 0;
        while (rc < 3) {
            float tmp = 0.0f;
            int cc = 0;
            while (cc < 3) {
                tmp += this.get(rc, cc) * src.get(cc);
                ++cc;
            }
            dest.set(rc, tmp);
            ++rc;
        }
    }

    public void getColumnMajorData(float[] out) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                out[4 * j + i] = this.get(i, j);
                ++j;
            }
            ++i;
        }
    }

    public Matf toMatf() {
        Matf out = new Matf(4, 4);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                out.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return out;
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + ", " + this.get(0, 2) + ", " + this.get(0, 3) + endl + this.get(1, 0) + ", " + this.get(1, 1) + ", " + this.get(1, 2) + ", " + this.get(1, 3) + endl + this.get(2, 0) + ", " + this.get(2, 1) + ", " + this.get(2, 2) + ", " + this.get(2, 3) + endl + this.get(3, 0) + ", " + this.get(3, 1) + ", " + this.get(3, 2) + ", " + this.get(3, 3) + ")";
    }
}

