/* Copyright (C) 1998 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
  to anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer
  to the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given
  to you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises supports the work of the GNU Project, but is not
  affiliated with the Free Software Foundation or the GNU Project.  GNU
  Ghostscript, as distributed by Aladdin Enterprises, does not require any
  GNU software to build or run it.
*/

/*$Id: gp_semon.c $ */
/* Construct monitors out of semaphores */
#include "std.h"
#include <semaphore.h>
#include "gserror.h"
#include "gserrors.h"
#include "gpsync.h"

typedef struct semaphore_monitor_s {
    gp_semaphore sem;		/* size is actually unknonwn */
} semaphore_monitor_t;

uint
gp_monitor_sizeof(void)
{
    return gp_semaphore_sizeof();
}

int
gp_monitor_open(gp_monitor * mon)
{
    semaphore_monitor_t * const semon = (semaphore_monitor_t *)mon;
    int code;

    if (!mon)
	return gp_semaphore_open(0);
    code = gp_semaphore_open(&semon->sem);
    if (code < 0)
	return code;
    return gp_semaphore_signal(&semon->sem);
}

int
gp_monitor_close(gp_monitor * mon)
{
    semaphore_monitor_t * const semon = (semaphore_monitor_t *)mon;

    return gp_semaphore_close(&semon->sem);
}

int
gp_monitor_enter(gp_monitor * mon)
{
    semaphore_monitor_t * const semon = (semaphore_monitor_t *)mon;

    return gp_semaphore_wait(&semon->sem);
}

int
gp_monitor_leave(gp_monitor * mon)
{
    semaphore_monitor_t * const semon = (semaphore_monitor_t *)mon;

    return gp_semaphore_signal(&semon->sem);
}
