-- EB4014A.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- OBJECTIVE:
--     CHECK THAT WHEN EXCEPTIONS ARE RAISED DURING THE ELABORATION OF
--     A LIBRARY UNIT, EXECUTION OF THE MAIN PROGRAM IS ABANDONED.

-- PASS/FAIL CRITERIA:
--     THIS TEST MUST EXECUTE AND REPORT "TENTATIVELY PASSED". IN
--     ADDITION, THE OUTPUT/LOG FILE MUST INDICATE THAT THE PROGRAM
--     TERMINATED WITH AN UNHANDLED EXCEPTION.

-- HISTORY:
--     DHH 03/29/88 CREATED ORIGINAL TEST.
--     PWN 05/25/94 ADDED A PROCEDURE TO KEEP PACKAGE BODIES LEGAL.

WITH REPORT; USE REPORT;
FUNCTION EB4014A1 RETURN INTEGER IS
BEGIN

     TEST("EB4014A", "THIS LINE SHOULD NOT BE PRINTED");

     FAILED("THE MAIN PROGRAM BODY WAS ENTERED");
     RESULT;

     RETURN IDENT_INT(1);

END EB4014A1;

WITH REPORT; USE REPORT;
PRAGMA ELABORATE (REPORT);
PACKAGE EB4014A_OUTSIDE IS
     PROCEDURE REQUIRE_BODY;
END EB4014A_OUTSIDE;

PACKAGE BODY EB4014A_OUTSIDE IS
     PROCEDURE REQUIRE_BODY IS
     BEGIN
          NULL;
     END;
BEGIN
     TEST("EB4014A", "CHECK THAT WHEN EXCEPTIONS ARE RAISED DURING " &
                     "THE ELABORATION OF A LIBRARY UNIT, EXECUTION " &
                     "OF THE MAIN PROGRAM IS ABANDONED");

     SPECIAL_ACTION("CHECK THE OUTPUT/LOG FILE TO SEE IF THIS " &
                    "PROGRAM TERMINATED WITH AN UNHANDLED " &
                    "EXCEPTION");

     RESULT;

     RAISE CONSTRAINT_ERROR;
END EB4014A_OUTSIDE;

WITH EB4014A1; WITH EB4014A_OUTSIDE;
WITH REPORT; USE REPORT;
PROCEDURE EB4014A IS
     X : INTEGER := EB4014A1;
BEGIN

     TEST("EB4014A", "THIS LINE SHOULD NOT PRINT OUT");

     FAILED("EXCEPTION DID NOT CAUSE MAIN PROGRAM TERMINATION");
     RESULT;
     X := IDENT_INT(X);
END EB4014A;
