/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard2;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizardPanel;
import com.sun.electric.tool.user.tecEditWizard2.WizardField;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class Metal
extends TechEditWizardPanel {
    private JPanel metal;
    private JScrollPane metalPane;
    private MetalContainer[] metalContainers;
    private int numMetals;
    private TechEditWizard parent;

    public Metal(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.setTitle("Metal");
        this.setName("");
        this.metal = new JPanel();
        this.metal.setLayout(new GridBagLayout());
        this.metalPane = new JScrollPane();
        JLabel heading = new JLabel("Metal Parameters");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.metal.add((Component)heading, gbc);
        JLabel image = new JLabel();
        image.setIcon(Resources.getResource(this.getClass(), "Metal.png"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.metal.add((Component)image, gbc);
        JButton addMetal = new JButton("Add Metal");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        addMetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Metal.this.addMetal();
            }
        });
        this.metal.add((Component)addMetal, gbc);
        JButton removeMetal = new JButton("Remove Metal");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        removeMetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Metal.this.removeMetal();
            }
        });
        this.metal.add((Component)removeMetal, gbc);
        JLabel l1 = new JLabel("Distance");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.metal.add((Component)l1, gbc);
        JLabel l2 = new JLabel("Rule Name");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.metal.add((Component)l2, gbc);
        this.metalPane.setViewportView(this.metal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.metalPane, new GridBagConstraints());
        JLabel nano = new JLabel("Distances are in nanometers");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 99;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.metal.add((Component)nano, gbc);
    }

    public Component getComponent() {
        return this.metalPane;
    }

    public String getName() {
        return "Metal";
    }

    public void init() {
        TechEditWizardData data2 = this.wizard.getTechEditData();
        this.numMetals = data2.getNumMetalLayers();
        this.metalContainers = new MetalContainer[this.numMetals];
        for (int i = 0; i < this.numMetals; ++i) {
            this.metalContainers[i] = this.addMetalLayer(i, data2);
        }
    }

    private MetalContainer addMetalLayer(int i, TechEditWizardData data2) {
        MetalContainer mc = new MetalContainer();
        mc.widthLabel = new JLabel("Metal-" + (i + 1) + " width (A):");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4 + i * 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.metal.add((Component)mc.widthLabel, gbc);
        mc.width = new JTextField();
        mc.width.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4 + i * 2;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.metal.add((Component)mc.width, gbc);
        mc.widthRule = new JTextField();
        mc.widthRule.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4 + i * 2;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.metal.add((Component)mc.widthRule, gbc);
        mc.spacingLabel = new JLabel("Metal-" + (i + 1) + " spacing (B):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5 + i * 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 4, 4, 0);
        this.metal.add((Component)mc.spacingLabel, gbc);
        mc.spacing = new JTextField();
        mc.spacing.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5 + i * 2;
        gbc.insets = new Insets(1, 0, 4, 2);
        this.metal.add((Component)mc.spacing, gbc);
        mc.spacingRule = new JTextField();
        mc.spacingRule.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5 + i * 2;
        gbc.insets = new Insets(1, 0, 4, 2);
        this.metal.add((Component)mc.spacingRule, gbc);
        if (data2 != null) {
            mc.width.setText(TextUtils.formatDouble(data2.getMetalWidth()[i].value));
            mc.widthRule.setText(data2.getMetalWidth()[i].rule);
            mc.spacing.setText(TextUtils.formatDouble(data2.getMetalSpacing()[i].value));
            mc.spacingRule.setText(data2.getMetalSpacing()[i].rule);
        }
        return mc;
    }

    private void addMetal() {
        ++this.numMetals;
        MetalContainer[] newMetalContainers = new MetalContainer[this.numMetals];
        System.arraycopy(this.metalContainers, 0, newMetalContainers, 0, this.numMetals - 1);
        this.metalContainers = newMetalContainers;
        this.metalContainers[this.numMetals - 1] = this.addMetalLayer(this.numMetals - 1, null);
        this.parent.pack();
    }

    private void removeMetal() {
        if (this.numMetals <= 1) {
            Job.getUserInterface().showErrorMessage("Cannot delete the last metal layer: must be at least one", "Illegal Operation");
            return;
        }
        --this.numMetals;
        MetalContainer mc = this.metalContainers[this.numMetals];
        this.metalContainers[this.numMetals] = null;
        this.metal.remove(mc.widthLabel);
        this.metal.remove(mc.width);
        this.metal.remove(mc.widthRule);
        this.metal.remove(mc.spacingLabel);
        this.metal.remove(mc.spacing);
        this.metal.remove(mc.spacingRule);
        this.parent.pack();
    }

    public void term() {
        TechEditWizardData data2 = this.wizard.getTechEditData();
        data2.setNumMetalLayers(this.numMetals);
        for (int i = 0; i < this.numMetals; ++i) {
            MetalContainer mc = this.metalContainers[i];
            data2.setMetalWidth(i, new WizardField(TextUtils.atof(mc.width.getText()), mc.widthRule.getText()));
            data2.setMetalSpacing(i, new WizardField(TextUtils.atof(mc.spacing.getText()), mc.spacingRule.getText()));
        }
    }

    private class MetalContainer {
        JLabel widthLabel;
        JLabel spacingLabel;
        JTextField spacing;
        JTextField spacingRule;
        JTextField width;
        JTextField widthRule;

        private MetalContainer() {
        }
    }
}

