/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.ExecProcess;
import com.sun.electric.tool.simulation.test.LogicSettableArray;
import com.sun.electric.tool.simulation.test.NetscanGeneric;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashSet;

public class Signalyzer
extends NetscanGeneric {
    private ExecProcess urjtag;
    private BufferedReader br;
    private HashSet<String> defined = new HashSet();
    private static boolean DEBUG = false;

    public Signalyzer() {
        this(8);
    }

    public Signalyzer(int irLen) {
        try {
            PipedOutputStream pos = new PipedOutputStream();
            this.br = new BufferedReader(new InputStreamReader(new PipedInputStream(pos)));
            this.urjtag = new ExecProcess("jtag -q", new String[0], new File("."), (OutputStream)pos, (OutputStream)new FileOutputStream("urjtag.err"));
            this.urjtag.setDaemon(true);
            this.urjtag.start();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writeln("cable Signalyzer");
            this.expectStart("Connected to");
            this.writeln("detect");
            this.expectStart("IR length: " + irLen);
            this.expectStart("Chain length: 1");
            this.writeln("part 0");
            this.writeln("instruction length " + irLen);
            this.logicOutput = new LogicSettableArray(1);
            this.setLogicOutput(0, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void configure(float tapVolt, long kiloHerz) {
        this.writeln("frequency " + kiloHerz * 1000L);
        this.expectStart("Setting TCK frequency to");
    }

    public void reset() {
        this.writeln("reset");
    }

    public void tms_reset() {
        this.writeln("reset");
    }

    public void disconnect() {
        this.urjtag.destroyProcess();
    }

    public void setLogicOutput(int index2, boolean newLevel) {
        if (index2 != 0) {
            throw new RuntimeException("we only support one GPIO, pin 15");
        }
        this.logicOutput.setLogicState(index2, newLevel);
        this.writeln("pod RESET=" + (newLevel ? "1" : "0"));
    }

    protected int hw_net_scan_ir(int numBits, short[] scanIn, short[] scanOut, int drBits) {
        if (DEBUG) {
            int i;
            System.err.print("hw_net_scan_ir(" + numBits + ", {");
            for (i = 0; i < scanIn.length; ++i) {
                System.err.print(" " + scanIn[i] + ",");
            }
            System.err.print("}, {");
            for (i = 0; i < scanOut.length; ++i) {
                System.err.print(" " + scanOut[i] + ",");
            }
            System.err.println("})");
        }
        if (scanIn.length != 1) {
            throw new RuntimeException("not implemented");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = numBits - 1; i >= 0; --i) {
            sb.append((scanIn[i / 16] & (short)(1 << i % 16)) == 0 ? "0" : "1");
        }
        String bits = sb.toString();
        if (!this.defined.contains(bits)) {
            this.defined.add(bits);
            this.writeln("register R" + bits + " " + drBits);
            this.writeln("instruction I" + bits + " " + bits + " R" + bits);
        }
        this.writeln("instruction I" + bits);
        this.writeln("shift ir");
        scanOut[0] = 1;
        return 0;
    }

    protected int hw_net_scan_dr(int numBits, short[] scanIn, short[] scanOut) {
        if (DEBUG) {
            int i;
            System.err.print("hw_net_scan_dr(" + numBits + ", {");
            for (i = 0; i < scanIn.length; ++i) {
                System.err.print(" " + scanIn[i] + ",");
            }
            System.err.print("}, {");
            for (i = 0; i < scanOut.length; ++i) {
                System.err.print(" " + scanOut[i] + ",");
            }
            System.err.println("})");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = numBits - 1; i >= 0; --i) {
            sb.append((scanIn[i / 16] & (short)(1 << i % 16)) == 0 ? "0" : "1");
        }
        String bits = sb.toString();
        this.writeln("dr " + bits);
        this.expectStart(bits);
        this.writeln("shift dr");
        this.writeln("dr");
        String dr = this.readln();
        if (dr.length() == 0) {
            throw new RuntimeException();
        }
        for (int i = 0; i < scanOut.length; ++i) {
            scanOut[i] = 0;
        }
        int j = 0;
        block8: for (int i = Math.min(dr.length(), numBits) - 1; i >= 0; --i) {
            switch (dr.charAt(i)) {
                case '0': {
                    ++j;
                    continue block8;
                }
                case '1': {
                    int n = j / 16;
                    scanOut[n] = (short)(scanOut[n] | (short)(1 << j % 16));
                    ++j;
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected char: " + dr.charAt(i) + " = " + dr.charAt(i));
                }
            }
        }
        return 0;
    }

    private void writeln(String s) {
        if (DEBUG) {
            System.err.println(s);
        }
        this.urjtag.writeln(s);
    }

    private String readln() {
        try {
            String s;
            while ((s = this.br.readLine()).startsWith("Device Id: unknown as bit")) {
            }
            if (DEBUG) {
                System.err.println(s);
            }
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void expectStart(String x) {
        String s = this.readln();
        if (!s.startsWith(x)) {
            throw new RuntimeException("expected a line starting with \"" + x + "\" but got \"" + s + "\"");
        }
    }
}

