/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.verilog;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.verilog.VerilogData;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerilogReader
extends Input<Object> {
    List<NodeInst> transistors = new ArrayList<NodeInst>();
    double maxWidth = 100.0;
    double nodeWidth = 10.0;
    double primitiveHeight = 0.5;
    double primitiveWidth = 0.5;
    Map<Cell, Point2D.Double> locationMap = new HashMap<Cell, Point2D.Double>();
    PrimitiveNode essentialBounds = Generic.tech().findNodeProto("Essential-Bounds");
    Cell topCell = null;
    Map<String, NodeInst> pinsMap = new HashMap<String, NodeInst>();
    private String typicalSkipStrings = "\t\\";
    private VerilogPreferences localPrefs;

    public VerilogReader(VerilogPreferences ap) {
        this.localPrefs = ap;
    }

    private String readCellHeader(List<String> inputs) throws IOException {
        block0: while (true) {
            String key;
            if ((key = this.getAKeyword()) == null) {
                throw new IOException("Error on line " + this.lineReader.getLineNumber());
            }
            StringTokenizer parse2 = new StringTokenizer(key, "( ),\t", false);
            while (true) {
                if (!parse2.hasMoreTokens()) continue block0;
                String value2 = parse2.nextToken();
                if (value2.equals(";")) {
                    return null;
                }
                inputs.add(value2);
            }
            break;
        }
    }

    private NodeInst readSupply(VerilogData.VerilogModule module, boolean power, String name) {
        VerilogData.VerilogPort supply = module.addPort(name, false, false);
        supply.type = power ? PortCharacteristic.PWR : PortCharacteristic.GND;
        return null;
    }

    private void readInstance(VerilogData.VerilogModule module, VerilogData.VerilogModule element) throws IOException {
        StringBuffer signature = new StringBuffer();
        ArrayList<String> exports = new ArrayList<String>();
        ArrayList<String> pins = new ArrayList<String>();
        while (true) {
            String key;
            if ((key = this.getRestOfLine()).contains("//")) {
                continue;
            }
            signature.append(key);
            if (key.contains(";")) break;
        }
        String line = signature.toString();
        int index2 = line.indexOf("(");
        String instanceName = element.getName() + "-instance";
        assert (index2 > -1);
        if (index2 > 0) {
            instanceName = line.substring(0, index2);
        }
        line = line.substring(index2 + 1, line.length());
        StringTokenizer parse2 = new StringTokenizer(line, ")", false);
        exports.clear();
        pins.clear();
        while (parse2.hasMoreTokens()) {
            String value2 = parse2.nextToken();
            index2 = (value2 = value2.replaceAll(" ", "")).indexOf(".");
            if (index2 == -1) continue;
            int index22 = value2.indexOf("(");
            assert (index22 != -1);
            String n = value2.substring(index2 + 1, index22);
            n = TextUtils.correctName(n, false, true);
            exports.add(n);
            n = value2.substring(index22 + 1);
            n = TextUtils.correctName(n, false, false);
            if (n.contains(" ")) assert (false);
            pins.add(n);
        }
        instanceName = TextUtils.correctName(instanceName, false, true);
        instanceName = instanceName.replaceAll(" ", "");
        VerilogData.VerilogInstance verilogInst = null;
        verilogInst = module.addInstance(instanceName, element);
        for (int i = 0; i < exports.size(); ++i) {
            String export = (String)exports.get(i);
            String pin = (String)pins.get(i);
            pin = pin.replaceAll(" ", "");
            VerilogData.VerilogPort exp = element.findPort(export = export.replaceAll(" ", ""));
            if (exp == null) {
                exp = element.addPort(export, false, true);
            }
            verilogInst.addPortInstance(pin, exp);
        }
    }

    private String readWiresAndSupplies(VerilogData.VerilogModule module, boolean readWires, boolean power) throws IOException {
        ArrayList<String> values2 = new ArrayList<String>(2);
        block0: while (true) {
            String input2 = this.getRestOfLine();
            StringTokenizer parse2 = new StringTokenizer(input2, ",;", true);
            while (true) {
                StringTokenizer p;
                if (!parse2.hasMoreTokens()) continue block0;
                String net = parse2.nextToken();
                if (net.equals(",")) continue;
                if (net.equals(";")) {
                    return null;
                }
                if (readWires) {
                    p = new StringTokenizer(net, this.typicalSkipStrings + " ", false);
                    values2.clear();
                    while (p.hasMoreTokens()) {
                        values2.add(p.nextToken());
                    }
                    int size2 = values2.size();
                    if (size2 == 0) continue;
                    assert (size2 == 1 || size2 == 2);
                    String pinName = (String)values2.get(size2 - 1);
                    int[] vals = new int[]{0, 0};
                    int count2 = 0;
                    if (values2.size() == 2) {
                        p = new StringTokenizer((String)values2.get(0), "[:]", false);
                        while (p.hasMoreTokens()) {
                            String s = p.nextToken();
                            if (!TextUtils.isANumber(s)) continue;
                            vals[count2++] = Integer.parseInt(s);
                        }
                        if (count2 != 2 || vals[0] == vals[1]) {
                            System.out.println(net + " is not a bus wire");
                        }
                    }
                    pinName = TextUtils.correctName(pinName, false, true);
                    module.addWire(pinName, values2.size() == 2 ? (String)values2.get(0) : null);
                    continue;
                }
                p = new StringTokenizer(net, "\t ", false);
                String name = p.nextToken();
                name = TextUtils.correctName(name, false, true);
                this.readSupply(module, power, name);
            }
            break;
        }
    }

    private void ignoreUntilEndOfStatement(String endString, int nestedLoop) throws IOException {
        String input2;
        String key;
        String string2 = key = endString != null ? endString : ";";
        do {
            if (!(input2 = this.getRestOfLine()).contains("begin")) continue;
            this.ignoreUntilEndOfStatement("end", nestedLoop + 1);
            if (nestedLoop != 0) continue;
            return;
        } while (!input2.contains(key));
    }

    private String readInputOutput(VerilogData.VerilogModule module, PortCharacteristic portType) throws IOException {
        block0: while (true) {
            String input2;
            if (!(input2 = this.getRestOfLine()).contains(";")) {
                String msg = "Missing end of line character ';' in input/output'" + input2 + "'";
                System.out.println(msg);
                throw new IOException(msg);
            }
            StringTokenizer parse2 = new StringTokenizer(input2, ";,", true);
            while (true) {
                if (!parse2.hasMoreTokens()) continue block0;
                String net = parse2.nextToken();
                if (net.equals(",")) continue;
                if (net.equals(";")) {
                    return null;
                }
                StringTokenizer p = new StringTokenizer(net, " \t", false);
                ArrayList<String> l = new ArrayList<String>(2);
                while (p.hasMoreTokens()) {
                    String name = p.nextToken();
                    l.add(name);
                }
                int size2 = l.size();
                if (size2 == 0) continue;
                assert (size2 == 1 || size2 == 2);
                String name = (String)l.get(size2 - 1);
                if (l.size() == 2) {
                    // empty if block
                }
                VerilogData.VerilogPort export = module.findPort(name);
                if (Job.getDebug()) {
                    System.out.println("Error: export name '" + name + " 'doesn't match with module signature");
                }
                if (export == null) continue;
                if (export.type != PortCharacteristic.UNKNOWN && export.type != portType) {
                    System.out.println("Inconsistency in asigning port type in " + name + ". Found " + (Object)((Object)portType) + " and was " + (Object)((Object)export.type));
                }
                export.type = portType;
                if (l.size() != 2) continue;
                export.setBusInformation((String)l.get(0));
            }
            break;
        }
    }

    private String readCell(VerilogData verilogData, boolean primitive) throws IOException {
        ArrayList<String> inputs = new ArrayList<String>(10);
        this.readCellHeader(inputs);
        String cellName = (String)inputs.get(0);
        VerilogData.VerilogModule module = null;
        Cell cell = null;
        module = verilogData.getModule(cellName);
        if (module == null) {
            module = verilogData.addModule(cellName, primitive, true);
        }
        module.setValid(true);
        for (int i = 1; i < inputs.size(); ++i) {
            module.addPort((String)inputs.get(i), true, true);
        }
        String nextToken = null;
        while (true) {
            String key = null;
            if (nextToken != null) {
                key = nextToken;
                nextToken = null;
            } else {
                key = this.getAKeyword();
            }
            if (key == null) {
                String msg = "Reach end of file without finding a valid key, i.e. end of a comment";
                System.out.println(msg);
                throw new IOException(msg);
            }
            if (key.startsWith("/*")) {
                this.getRestOfComment();
                continue;
            }
            if (key.startsWith("/")) {
                this.getRestOfLine();
                continue;
            }
            if (key.startsWith("endmodule") || key.startsWith("endprimitive")) {
                return null;
            }
            if (key.equals("wire")) {
                this.readWiresAndSupplies(module, true, false);
                continue;
            }
            if (key.startsWith("tri")) assert (false);
            if (key.equals("input")) {
                this.readInputOutput(module, PortCharacteristic.IN);
                continue;
            }
            if (key.equals("output")) {
                this.readInputOutput(module, PortCharacteristic.OUT);
                continue;
            }
            if (key.equals("inout")) {
                this.readInputOutput(module, PortCharacteristic.BIDIR);
                continue;
            }
            if (key.startsWith("supply")) {
                boolean power = key.contains("supply1");
                this.readWiresAndSupplies(module, false, power);
                continue;
            }
            if (key.equals("assign") || key.startsWith("always") || key.startsWith("initial") || key.startsWith("reg") || key.startsWith("table") || key.startsWith("specify") || key.startsWith("begin")) {
                if (Job.getDebug()) {
                    System.out.println("Ignoring " + key);
                }
                String endStatement = null;
                int nestedLoopAllowed = 0;
                if (key.startsWith("table")) {
                    endStatement = "endtable";
                } else if (key.startsWith("specify")) {
                    endStatement = "endspecify";
                } else if (key.startsWith("always")) {
                    endStatement = "end";
                }
                this.ignoreUntilEndOfStatement(endStatement, nestedLoopAllowed);
                continue;
            }
            if (key.equals("tranif1")) {
                assert (false);
                nextToken = this.readGate(cell, PrimitiveNode.Function.TRANMOS);
                continue;
            }
            if (key.equals("tranif0")) {
                assert (false);
                nextToken = this.readGate(cell, PrimitiveNode.Function.TRAPMOS);
                continue;
            }
            VerilogData.VerilogModule element = verilogData.getModule(key);
            if (element == null) {
                element = verilogData.addModule(key, false, false);
            }
            this.readInstance(module, element);
        }
    }

    private Point2D.Double getNextLocation(Cell cell) {
        Point2D.Double point = this.locationMap.get(cell);
        double xPos = 0.0;
        double yPos = 0.0;
        if (point != null) {
            xPos = point.getX();
            yPos = point.getY();
        }
        double x = xPos * this.nodeWidth;
        double y = yPos * this.nodeWidth;
        Point2D.Double p = new Point2D.Double(x, y);
        if (x > this.maxWidth) {
            yPos += 1.0;
            xPos = 0.0;
        } else {
            xPos += 1.0;
        }
        point = new Point2D.Double(xPos, yPos);
        this.locationMap.put(cell, point);
        return p;
    }

    private String readGate(Cell cell, PrimitiveNode.Function function) throws IOException {
        String input2 = this.getRestOfLine();
        StringTokenizer parse2 = new StringTokenizer(input2, "(;, \t)", false);
        ArrayList<String> list2 = new ArrayList<String>(2);
        while (parse2.hasMoreTokens()) {
            String value2 = parse2.nextToken();
            list2.add(value2);
        }
        Orientation orient = Orientation.fromAngle(900);
        double width = Schematics.tech().transistorNode.getDefWidth();
        double height = Schematics.tech().transistorNode.getDefHeight();
        Point2D.Double p = this.getNextLocation(cell);
        NodeInst ni = NodeInst.newInstance(Schematics.tech().transistorNode, p, width, height, cell, orient, null);
        Schematics.tech().transistorNode.getTechnology().setPrimitiveFunction(ni, function);
        this.transistors.add(ni);
        PortInst[] ports = new PortInst[3];
        int count2 = 0;
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            ports[count2++] = it.next();
        }
        for (int i = 1; i < list2.size(); ++i) {
            String name = (String)list2.get(i);
            int pos = (3 + i) % 3;
            double posX = ((Point2D)p).getX();
            double posY = ((Point2D)p).getY();
            switch (pos) {
                case 0: {
                    posX -= width / 2.0;
                    break;
                }
                case 1: {
                    posX += width / 2.0;
                    posY -= height / 2.0;
                    break;
                }
                case 2: {
                    posX += width / 2.0;
                    posY += height / 2.0;
                }
            }
            PrimitiveNode primitive = Schematics.tech().wirePinNode;
            ni = NodeInst.newInstance(primitive, new Point2D.Double(posX, posY), this.primitiveWidth, this.primitiveHeight, cell, Orientation.IDENT, null);
            ArcInst.makeInstanceBase(Schematics.tech().wire_arc, 0.0, ni.getOnlyPortInst(), ports[pos], null, null, name);
        }
        return null;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.initKeywordParsing();
        VerilogData verilogData = this.parseVerilogInternal(lib.getName(), true);
        this.buildCells(verilogData, lib, true);
        this.topCell = verilogData.getTopSchematicCell();
        if (this.topCell != null) {
            currentCells.put(this.topCell.getLibrary(), this.topCell);
            return this.topCell.getLibrary();
        }
        return null;
    }

    public VerilogData parseVerilog(String[] lines2, String verilogName) {
        if (this.openStringsInput(lines2)) {
            System.out.println("Cannot open string set " + verilogName + " as Verilog");
            return null;
        }
        System.out.println("Reading Verilog format " + verilogName);
        this.initKeywordParsing();
        VerilogReader.setProgressValue(0);
        VerilogReader.setProgressNote("Reading Verilog format " + verilogName);
        VerilogData verilogData = this.parseVerilogInternal(verilogName, true);
        System.out.println("Verilog format " + verilogName + " read");
        return verilogData;
    }

    public VerilogData parseVerilog(String file, boolean simplifyWires) {
        URL fileURL = TextUtils.makeURLToFile(file);
        if (this.openTextInput(fileURL)) {
            System.out.println("Cannot open the Verilog file: " + file);
            return null;
        }
        System.out.println("Reading Verilog file: " + file);
        this.initKeywordParsing();
        VerilogReader.setProgressValue(0);
        VerilogReader.setProgressNote("Reading Verilog file:" + file);
        VerilogData verilogData = this.parseVerilogInternal(file, simplifyWires);
        System.out.println("Verilog file: " + file + " read");
        return verilogData;
    }

    public void createCellsOnly(VerilogData verilogData, Job job) {
        Library library = Library.newInstance(verilogData.name, null);
        this.buildCells(verilogData, library, false);
        if (job != null) {
            System.out.println("Accumulative time after creating cells '" + verilogData.name + "' " + job.getInfo());
        }
    }

    public VerilogData readVerilogOnly(String file, boolean fullOyster, Job job) {
        VerilogData verilogData = this.parseVerilog(file, fullOyster);
        if (verilogData == null) {
            return null;
        }
        if (job != null) {
            System.out.println("Accumulative time before creating cells '" + file + "' " + job.getInfo());
        }
        return verilogData;
    }

    public Cell readVerilog(String testName, String file, boolean createCells, boolean simplifyWires, Job job) {
        VerilogData verilogData = this.parseVerilog(file, simplifyWires);
        if (verilogData == null) {
            return null;
        }
        int index2 = file.lastIndexOf("/");
        String libName = file.substring(index2 + 1);
        if (job != null) {
            System.out.println("Accumulative time before creating cells '" + testName + "' " + job.getInfo());
        }
        if (createCells) {
            Library library = Library.newInstance(libName, null);
            this.buildCells(verilogData, library, simplifyWires);
            this.topCell = verilogData.getTopSchematicCell();
            if (this.topCell == null) {
                System.out.println("Check this case in readVerilog");
            }
        }
        if (job != null) {
            System.out.println("Accumulative time after creating cells '" + testName + "' " + job.getInfo());
        }
        return this.topCell;
    }

    private VerilogData parseVerilogInternal(String fileName, boolean simplifyWires) {
        VerilogData verilogData = new VerilogData(fileName);
        try {
            String nextToken = null;
            String key = null;
            while (true) {
                if (nextToken != null) {
                    key = nextToken;
                    nextToken = null;
                } else {
                    key = this.getAKeyword();
                }
                if (key != null) {
                    if (key.startsWith("/")) {
                        this.getRestOfLine();
                        continue;
                    }
                    if (!key.equals("module") && !key.equals("primitive")) continue;
                    boolean primitive = key.equals("primitive");
                    nextToken = this.readCell(verilogData, primitive);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println("Error reading Verilog file: " + e.getMessage());
        }
        if (simplifyWires) {
            verilogData.simplifyWires();
        }
        return verilogData;
    }

    private void buildCells(VerilogData verilogCell, Library lib, boolean createIconCells) {
        for (VerilogData.VerilogModule module : verilogCell.getModules()) {
            this.buildCellFromModule(module, lib, createIconCells);
        }
    }

    private void addPins(VerilogData.VerilogConnection port, Cell cell, boolean addExport, boolean fullOyster) {
        PortCharacteristic portType = port.getPortType();
        List<String> pinNames = port.getPinNames(fullOyster);
        Collections.sort(pinNames);
        for (String pinName : pinNames) {
            PrimitiveNode primitive = Schematics.tech().wirePinNode;
            NodeInst ni = cell.findNode(pinName);
            if (ni == null) {
                ni = NodeInst.newInstance(primitive, this.getNextLocation(cell), this.primitiveWidth, this.primitiveHeight, cell, Orientation.IDENT, pinName);
                if (!addExport) continue;
                Export.newInstance(cell, ni.getOnlyPortInst(), pinName, portType);
                continue;
            }
            assert (false);
            System.out.println("Wire/Input/Output " + pinName + " exists");
        }
    }

    private Cell buildCellFromModule(VerilogData.VerilogModule module, Library lib, boolean createIconcells) {
        String cellName = module.name + View.SCHEMATIC.getAbbreviationExtension();
        Cell cell = Library.findCellInLibraries(cellName, View.SCHEMATIC, null);
        if (cell != null) {
            return cell;
        }
        cell = Cell.makeInstance(lib, cellName);
        cell.setTechnology(Schematics.tech());
        List<Object> all = module.getAllSorted();
        for (Object obj : all) {
            if (obj instanceof VerilogData.VerilogWire) {
                VerilogData.VerilogWire wire = (VerilogData.VerilogWire)obj;
                this.addPins(wire, cell, false, createIconcells);
                continue;
            }
            if (!(obj instanceof VerilogData.VerilogPort)) continue;
            VerilogData.VerilogPort port = (VerilogData.VerilogPort)obj;
            String name = port.name;
            PortCharacteristic portType = port.type;
            if (portType == PortCharacteristic.BIDIR || portType == PortCharacteristic.IN || portType == PortCharacteristic.OUT || portType == PortCharacteristic.CLK || portType == PortCharacteristic.UNKNOWN) {
                this.addPins(port, cell, true, createIconcells);
                continue;
            }
            if (portType == PortCharacteristic.PWR || portType == PortCharacteristic.GND) {
                boolean power = portType == PortCharacteristic.PWR;
                PrimitiveNode np = power ? Schematics.tech().powerNode : Schematics.tech().groundNode;
                Point2D.Double p = this.getNextLocation(cell);
                double height = this.primitiveHeight;
                NodeInst supply = NodeInst.newInstance(np, p, this.primitiveWidth, height, cell, Orientation.IDENT, name);
                NodeInst ni = NodeInst.newInstance(Schematics.tech().wirePinNode, new Point2D.Double(p.getX(), p.getY() + height / 2.0), 0.5, 0.5, cell, Orientation.IDENT, name + "@0");
                ArcInst.makeInstanceBase(Schematics.tech().wire_arc, 0.0, ni.getOnlyPortInst(), supply.getOnlyPortInst(), null, null, name);
                Export.newInstance(cell, ni.getOnlyPortInst(), name, portType);
                continue;
            }
            System.out.println("Skipping this characteristic?");
        }
        for (VerilogData.VerilogInstance inst : module.getInstances()) {
            this.buildNodeInstFromModule(inst, lib, cell, createIconcells);
        }
        if (createIconcells) {
            ViewChanges.makeIconViewNoGUI(cell, true, true);
        }
        return cell;
    }

    Cell buildNodeInstFromModule(VerilogData.VerilogInstance inst, Library lib, Cell parent, boolean useIconCell) {
        Cell schematics = this.buildCellFromModule(inst.element, lib, useIconCell);
        Cell icon = useIconCell ? schematics.iconView() : schematics;
        NodeInst cellInst = NodeInst.newInstance(icon, this.getNextLocation(parent), 10.0, 10.0, parent, Orientation.IDENT, inst.name);
        for (VerilogData.VerilogPortInst port : inst.ports) {
            List<String> localPorts = port.getPortNames();
            int startPort = port.port.start;
            int endPort = port.port.end;
            int count2 = startPort;
            boolean asc = startPort < endPort;
            for (String s : localPorts) {
                int index2;
                NodeInst pin = parent.findNode(s);
                if (pin == null && (index2 = s.indexOf("[")) != -1) {
                    s = s.substring(0, index2);
                    pin = parent.findNode(s);
                }
                if (pin == null) {
                    if (Job.getDebug()) {
                        System.out.println("Unknown signal " + s + " in cell " + parent.describe(false));
                    }
                    PrimitiveNode primitive = port.port.isBusConnection() ? Schematics.tech().busPinNode : Schematics.tech().wirePinNode;
                    pin = NodeInst.newInstance(primitive, this.getNextLocation(parent), this.primitiveWidth, this.primitiveHeight, parent, Orientation.IDENT, s);
                }
                ArcProto node = pin.getProto() == Schematics.tech().busPinNode ? Schematics.tech().bus_arc : Schematics.tech().wire_arc;
                String exportName = port.port.name;
                if (port.port.isBusConnection()) {
                    exportName = exportName + "[" + count2 + "]";
                }
                PortInst ex = cellInst.findPortInst(exportName);
                assert (ex != null);
                ArcInst ai = ArcInst.makeInstanceBase(node, 0.0, pin.getOnlyPortInst(), ex, null, null, s);
                if (ai == null) assert (ai != null);
                ai.setFixedAngle(false);
                if (asc) {
                    ++count2;
                    continue;
                }
                --count2;
            }
        }
        return schematics;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VerilogPreferences
    extends Input.InputPreferences {
        public boolean runPlacement = SimulationTool.getFactoryVerilogRunPlacementTool();
        Placement.PlacementPreferences placementPrefs;
        IconParameters iconParameters = IconParameters.makeInstance(true);

        public VerilogPreferences(boolean factory) {
            super(factory);
            if (!factory) {
                this.runPlacement = SimulationTool.getVerilogRunPlacementTool();
            }
            this.placementPrefs = new Placement.PlacementPreferences(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            VerilogReader in = new VerilogReader(this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            if ((lib = in.importALibrary(lib, tech, currentCells)) != null && this.runPlacement) {
                Placement.placeCellNoJob(currentCells.get(lib), this.placementPrefs);
            }
            in.closeInput();
            return lib;
        }
    }
}

