/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.util.math.DBMath;

public class GEM
extends Technology {
    public static final Variable.Key ELEMENT_NAME = Variable.newKey("GEM_element");
    public static final Variable.Key EVENT_1 = Variable.newKey("GEM_event1");
    public static final Variable.Key EVENT_2 = Variable.newKey("GEM_event2");
    public static final Variable.Key EVENT_3 = Variable.newKey("GEM_event3");
    public static final Variable.Key EVENT_4 = Variable.newKey("GEM_event4");
    private Layer E_lay;
    private Layer GA_lay;
    private Layer TA_lay;
    private Layer CA_lay;
    private Layer PA_lay;
    private Layer NA_lay;
    private Layer FA_lay;
    private ArcProto generalArc;
    private ArcProto temporalArc;
    private ArcProto causalArc;
    private ArcProto prerequisiteArc;
    private ArcProto nondeterministicArc;
    private ArcProto nondeterministicForkArc;
    private Technology.TechPoint[] box_7;
    private PrimitiveNode e_node;
    private final double lambdaArrowSize = 1.0;
    private final double lambdaPlusSize = 0.75;
    private final double lambdaPlusGap = 0.5;
    private final double lambdaZigZagWidth = 0.5;
    private final double lambdaDoubleArcWidth = 0.5;
    private final double gridArrowSize = 400.0;
    private final double gridPlusSize = 300.0;

    public GEM(Generic generic, TechFactory techFactory) {
        super(generic, techFactory);
        this.setTechDesc("Temporal Specification Facility (from Lansky)");
        this.setFactoryScale(1000.0, false);
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.setNonStandard();
        this.E_lay = Layer.newInstance(this, "Element", new EGraphics(false, false, null, 0, 255, 0, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.GA_lay = Layer.newInstance(this, "General-arc", new EGraphics(false, false, null, 0, 0, 0, 255, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.TA_lay = Layer.newInstance(this, "Temporal-arc", new EGraphics(false, false, null, 0, 0, 255, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.CA_lay = Layer.newInstance(this, "Causal-arc", new EGraphics(false, false, null, 0, 0, 0, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.PA_lay = Layer.newInstance(this, "Prereq-arc", new EGraphics(false, false, null, 0, 255, 190, 6, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.NA_lay = Layer.newInstance(this, "Nondet-arc", new EGraphics(false, false, null, 0, 255, 255, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.FA_lay = Layer.newInstance(this, "Fork-arc", new EGraphics(false, false, null, 0, 186, 0, 255, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.E_lay.setFunction(Layer.Function.ART, 8192);
        this.GA_lay.setFunction(Layer.Function.CONTROL, 8192);
        this.TA_lay.setFunction(Layer.Function.CONTROL, 8192);
        this.CA_lay.setFunction(Layer.Function.CONTROL, 8192);
        this.PA_lay.setFunction(Layer.Function.CONTROL, 8192);
        this.NA_lay.setFunction(Layer.Function.CONTROL, 8192);
        this.FA_lay.setFunction(Layer.Function.CONTROL, 8192);
        this.generalArc = this.newArcProto("General", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.GA_lay, 0.0, Poly.Type.FILLED));
        this.generalArc.setWipable();
        this.generalArc.setFactoryAngleIncrement(0);
        this.temporalArc = this.newArcProto("Temporal", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.TA_lay, 0.0, Poly.Type.FILLED));
        this.temporalArc.setWipable();
        this.temporalArc.setFactoryAngleIncrement(0);
        this.temporalArc.setFactoryDirectional(5);
        this.causalArc = this.newArcProto("Causal", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.CA_lay, 0.0, Poly.Type.FILLED));
        this.causalArc.setWipable();
        this.causalArc.setFactoryAngleIncrement(0);
        this.prerequisiteArc = this.newArcProto("Prerequisite", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.PA_lay, 0.0, Poly.Type.FILLED));
        this.prerequisiteArc.setWipable();
        this.prerequisiteArc.setFactoryAngleIncrement(0);
        this.prerequisiteArc.setFactoryDirectional(5);
        this.nondeterministicArc = this.newArcProto("Nondeterministic", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.NA_lay, 0.0, Poly.Type.FILLED));
        this.nondeterministicArc.setWipable();
        this.nondeterministicArc.setFactoryAngleIncrement(0);
        this.nondeterministicArc.setFactoryDirectional(5);
        this.nondeterministicForkArc = this.newArcProto("Nondeterministic-fork", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.FA_lay, 0.0, Poly.Type.FILLED));
        this.nondeterministicForkArc.setWipable();
        this.nondeterministicForkArc.setFactoryAngleIncrement(0);
        this.nondeterministicForkArc.setFactoryDirectional(7);
        Technology.TechPoint[] box_6 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())};
        this.box_7 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())};
        PrimitiveNode gp_node = PrimitiveNode.newInstance("General-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.GA_lay, 0, Poly.Type.DISC, 0, this.box_7)});
        PrimitivePort pinPort = PrimitivePort.newInstance(this, gp_node, new ArcProto[]{this.generalArc}, "general", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter());
        gp_node.addPrimitivePortsFixed(new PrimitivePort[]{pinPort});
        gp_node.setFunction(PrimitiveNode.Function.PIN);
        gp_node.setArcsWipe();
        gp_node.setArcsShrink();
        PrimitiveNode tp_node = PrimitiveNode.newInstance("Temporal-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.TA_lay, 0, Poly.Type.DISC, 0, this.box_7)});
        tp_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, tp_node, new ArcProto[]{this.temporalArc}, "temporal", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        tp_node.setFunction(PrimitiveNode.Function.PIN);
        tp_node.setArcsWipe();
        tp_node.setArcsShrink();
        PrimitiveNode cp_node = PrimitiveNode.newInstance("Cause-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.CA_lay, 0, Poly.Type.DISC, 0, this.box_7)});
        cp_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, cp_node, new ArcProto[]{this.causalArc}, "cause", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        cp_node.setFunction(PrimitiveNode.Function.PIN);
        cp_node.setArcsWipe();
        cp_node.setArcsShrink();
        PrimitiveNode pp_node = PrimitiveNode.newInstance("Prereq-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.PA_lay, 0, Poly.Type.DISC, 0, this.box_7)});
        pp_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, pp_node, new ArcProto[]{this.prerequisiteArc}, "prereq", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        pp_node.setFunction(PrimitiveNode.Function.PIN);
        pp_node.setArcsWipe();
        pp_node.setArcsShrink();
        PrimitiveNode np_node = PrimitiveNode.newInstance("Nondet-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.NA_lay, 0, Poly.Type.DISC, 0, this.box_7)});
        np_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, np_node, new ArcProto[]{this.nondeterministicArc}, "nondet", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        np_node.setFunction(PrimitiveNode.Function.PIN);
        np_node.setArcsWipe();
        np_node.setArcsShrink();
        PrimitiveNode fp_node = PrimitiveNode.newInstance("Fork-Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.FA_lay, 0, Poly.Type.DISC, 0, this.box_7)});
        fp_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, fp_node, new ArcProto[]{this.nondeterministicForkArc}, "fork", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        fp_node.setFunction(PrimitiveNode.Function.PIN);
        fp_node.setArcsWipe();
        fp_node.setArcsShrink();
        this.e_node = PrimitiveNode.newInstance("Element", this, 8.0, 8.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.E_lay, 0, Poly.Type.CIRCLE, 0, this.box_7)});
        this.e_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.e_node, new ArcProto[]{this.generalArc, this.temporalArc, this.causalArc, this.prerequisiteArc, this.nondeterministicArc, this.nondeterministicForkArc}, "port1", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.0), EdgeV.fromCenter(0.5), EdgeH.fromLeft(2.0), EdgeV.fromCenter(0.5)), PrimitivePort.newInstance(this, this.e_node, new ArcProto[]{this.generalArc, this.temporalArc, this.causalArc, this.prerequisiteArc, this.nondeterministicArc, this.nondeterministicForkArc}, "port2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.0), EdgeV.fromCenter(-0.5), EdgeH.fromLeft(2.0), EdgeV.fromCenter(-0.5)), PrimitivePort.newInstance(this, this.e_node, new ArcProto[]{this.generalArc, this.temporalArc, this.causalArc, this.prerequisiteArc, this.nondeterministicArc, this.nondeterministicForkArc}, "port3", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.0), EdgeV.fromCenter(-1.5), EdgeH.fromLeft(2.0), EdgeV.fromCenter(-1.5)), PrimitivePort.newInstance(this, this.e_node, new ArcProto[]{this.generalArc, this.temporalArc, this.causalArc, this.prerequisiteArc, this.nondeterministicArc, this.nondeterministicForkArc}, "port4", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(2.0), EdgeV.fromCenter(-2.5), EdgeH.fromLeft(2.0), EdgeV.fromCenter(-2.5))});
        this.e_node.setFunction(PrimitiveNode.Function.UNKNOWN);
        PrimitiveNode g_node = PrimitiveNode.newInstance("Group", this, 10.0, 10.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.E_lay, 0, Poly.Type.CLOSED, 1, box_6)});
        g_node.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, g_node, new ArcProto[]{this.generalArc, this.temporalArc, this.causalArc, this.prerequisiteArc, this.nondeterministicArc, this.nondeterministicForkArc}, "group", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        g_node.setFunction(PrimitiveNode.Function.UNKNOWN);
        this.loadFactoryMenuPalette(GEM.class.getResource("gemMenu.xml"));
        this.newFoundry(Foundry.Type.NONE, null, new String[0]);
    }

    protected void genShapeOfNode(AbstractShapeBuilder b, ImmutableNodeInst n, PrimitiveNode pn, Technology.NodeLayer[] primLayers) {
        if (pn == this.e_node) {
            Technology.NodeLayer[] eventLayers = new Technology.NodeLayer[6];
            eventLayers[0] = new Technology.NodeLayer(this.E_lay, 0, Poly.Type.CIRCLE, 0, this.box_7);
            String title = "";
            Variable varTitle = n.getVar(ELEMENT_NAME);
            if (varTitle != null) {
                title = varTitle.getPureValue(-1);
            }
            eventLayers[1] = new Technology.NodeLayer(this.E_lay, 0, Poly.Type.TEXTCENT, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.fromTop(1.0))});
            eventLayers[1].setMessage(title);
            String event1 = "";
            Variable varEvent1 = n.getVar(EVENT_1);
            if (varEvent1 != null) {
                event1 = varEvent1.getPureValue(-1);
            }
            eventLayers[2] = new Technology.NodeLayer(this.E_lay, 0, Poly.Type.TEXTLEFT, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(2.0), EdgeV.fromCenter(0.5))});
            eventLayers[2].setMessage(event1);
            String event2 = "";
            Variable varEvent2 = n.getVar(EVENT_2);
            if (varEvent2 != null) {
                event2 = varEvent2.getPureValue(-1);
            }
            eventLayers[3] = new Technology.NodeLayer(this.E_lay, 0, Poly.Type.TEXTLEFT, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(2.0), EdgeV.fromCenter(-0.5))});
            eventLayers[3].setMessage(event2);
            String event3 = "";
            Variable varEvent3 = n.getVar(EVENT_3);
            if (varEvent3 != null) {
                event3 = varEvent3.getPureValue(-1);
            }
            eventLayers[4] = new Technology.NodeLayer(this.E_lay, 0, Poly.Type.TEXTLEFT, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(2.0), EdgeV.fromCenter(-1.5))});
            eventLayers[4].setMessage(event3);
            String event4 = "";
            Variable varEvent4 = n.getVar(EVENT_4);
            if (varEvent4 != null) {
                event4 = varEvent4.getPureValue(-1);
            }
            eventLayers[5] = new Technology.NodeLayer(this.E_lay, 0, Poly.Type.TEXTLEFT, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.fromLeft(2.0), EdgeV.fromCenter(-2.5))});
            eventLayers[5].setMessage(event4);
            primLayers = eventLayers;
            ERectangle fullRectangle = this.e_node.getFullRectangle();
            EPoint fixupCorrection = EPoint.fromGrid(fullRectangle.getGridWidth(), fullRectangle.getGridHeight());
            for (Technology.NodeLayer nodeLayer : eventLayers) {
                nodeLayer.fixup(fixupCorrection);
            }
        }
        b.genShapeOfNode(n, pn, primLayers, null);
    }

    protected void getShapeOfArc(AbstractShapeBuilder b, ImmutableArcInst a, EGraphics graphicsOverride) {
        ArcProto ap = this.getArcProto(a.protoId);
        assert (ap.getTechnology() == this);
        if (ap == this.generalArc) {
            Layer layer = this.GA_lay;
            if (b.skipLayer(layer)) {
                return;
            }
            b.pushPoint(a.headLocation);
            b.pushPoint(a.tailLocation);
            b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
            return;
        }
        if (ap == this.prerequisiteArc) {
            Layer layer = this.PA_lay;
            if (b.skipLayer(layer)) {
                return;
            }
            b.pushPoint(a.headLocation);
            b.pushPoint(a.tailLocation);
            b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
            if (a.isHeadArrowed()) {
                this.addHeadArrow(b, a, graphicsOverride, layer, a.headLocation);
            }
            return;
        }
        if (ap == this.nondeterministicForkArc) {
            Layer layer = this.FA_lay;
            if (b.skipLayer(layer)) {
                return;
            }
            EPoint newTail = a.tailLocation;
            if (a.isTailArrowed()) {
                newTail = this.addTailPlus(b, a, graphicsOverride, layer);
            }
            b.pushPoint(a.headLocation);
            b.pushPoint(newTail);
            b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
            if (a.isHeadArrowed()) {
                this.addHeadArrow(b, a, graphicsOverride, layer, a.headLocation);
            }
            return;
        }
        if (ap == this.nondeterministicArc) {
            Layer layer = this.NA_lay;
            if (b.skipLayer(layer)) {
                return;
            }
            EPoint newHead = a.headLocation;
            if (a.isHeadArrowed()) {
                newHead = this.addHeadPlus(b, a, graphicsOverride, layer);
                this.addHeadArrow(b, a, graphicsOverride, layer, newHead);
            }
            b.pushPoint(a.tailLocation);
            b.pushPoint(newHead);
            b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
            return;
        }
        if (ap == this.temporalArc) {
            Layer layer = this.TA_lay;
            if (b.skipLayer(layer)) {
                return;
            }
            this.addDoubleLineArc(b, a, graphicsOverride, layer);
            return;
        }
        if (ap == this.causalArc) {
            Layer layer = this.CA_lay;
            if (b.skipLayer(layer)) {
                return;
            }
            this.addZigZagArc(b, a, graphicsOverride, layer);
            return;
        }
    }

    public boolean isEasyShape(ImmutableArcInst a, boolean explain) {
        ArcProto ap = this.getArcProto(a.protoId);
        if (ap != this.generalArc) {
            if (explain) {
                System.out.println("GEM_ARC_SHAPE");
            }
            return false;
        }
        return super.isEasyShape(a, explain);
    }

    private void addHeadArrow(AbstractShapeBuilder b, ImmutableArcInst a, EGraphics graphicsOverride, Layer layer, EPoint headLoc) {
        int angle = a.getDefinedAngle();
        angle = (angle + 1800) % 3600;
        int angleOfArrow = 300;
        int backAngle1 = angle - angleOfArrow;
        int backAngle2 = angle + angleOfArrow;
        b.pushPoint(headLoc);
        b.pushPoint(headLoc, DBMath.cos(backAngle1) * 400.0, DBMath.sin(backAngle1) * 400.0);
        b.pushPoint(headLoc);
        b.pushPoint(headLoc, DBMath.cos(backAngle2) * 400.0, DBMath.sin(backAngle2) * 400.0);
        b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
    }

    private EPoint addTailPlus(AbstractShapeBuilder b, ImmutableArcInst a, EGraphics graphicsOverride, Layer layer) {
        int angle = a.getDefinedAngle();
        int angleOfPlus = 900;
        int backAngleLeft = angle - angleOfPlus;
        int backAngleRight = angle + angleOfPlus;
        EPoint plusCenter = new EPoint(a.tailLocation.getX() + DBMath.cos(angle) * 0.75, a.tailLocation.getY() + DBMath.sin(angle) * 0.75);
        b.pushPoint(plusCenter, DBMath.cos(backAngleLeft) * 300.0, DBMath.sin(backAngleLeft) * 300.0);
        b.pushPoint(plusCenter, DBMath.cos(backAngleRight) * 300.0, DBMath.sin(backAngleRight) * 300.0);
        b.pushPoint(a.tailLocation);
        b.pushPoint(a.tailLocation, DBMath.cos(angle) * 300.0 * 2.0, DBMath.sin(angle) * 300.0 * 2.0);
        b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
        EPoint newTail = new EPoint(a.tailLocation.getX() + DBMath.cos(angle) * 2.0, a.tailLocation.getY() + DBMath.sin(angle) * 2.0);
        return newTail;
    }

    private EPoint addHeadPlus(AbstractShapeBuilder b, ImmutableArcInst a, EGraphics graphicsOverride, Layer layer) {
        int angle = a.getDefinedAngle();
        angle = (angle + 1800) % 3600;
        int angleOfPlus = 900;
        int backAngleLeft = angle - angleOfPlus;
        int backAngleRight = angle + angleOfPlus;
        EPoint plusCenter = new EPoint(a.headLocation.getX() + DBMath.cos(angle) * 0.75, a.headLocation.getY() + DBMath.sin(angle) * 0.75);
        b.pushPoint(plusCenter, DBMath.cos(backAngleLeft) * 300.0, DBMath.sin(backAngleLeft) * 300.0);
        b.pushPoint(plusCenter, DBMath.cos(backAngleRight) * 300.0, DBMath.sin(backAngleRight) * 300.0);
        b.pushPoint(a.headLocation);
        b.pushPoint(a.headLocation, DBMath.cos(angle) * 300.0 * 2.0, DBMath.sin(angle) * 300.0 * 2.0);
        b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
        EPoint newHead = new EPoint(a.headLocation.getX() + DBMath.cos(angle) * 2.0, a.headLocation.getY() + DBMath.sin(angle) * 2.0);
        return newHead;
    }

    private void addDoubleLineArc(AbstractShapeBuilder b, ImmutableArcInst a, EGraphics graphicsOverride, Layer layer) {
        int angle = a.getDefinedAngle();
        int angleOfArrow = 900;
        angle = (angle + 1800) % 3600;
        int backAngle1 = angle - angleOfArrow;
        int backAngle2 = angle + angleOfArrow;
        double indentHeadX = a.headLocation.getX();
        double indentHeadY = a.headLocation.getY();
        if (a.isHeadArrowed()) {
            indentHeadX += DBMath.cos(angle) * 0.5;
            indentHeadY += DBMath.sin(angle) * 0.5;
        }
        EPoint headLeft = new EPoint(indentHeadX + DBMath.cos(backAngle1) * 0.5, indentHeadY + DBMath.sin(backAngle1) * 0.5);
        EPoint headRight = new EPoint(indentHeadX + DBMath.cos(backAngle2) * 0.5, indentHeadY + DBMath.sin(backAngle2) * 0.5);
        EPoint tailLeft = new EPoint(a.tailLocation.getX() + DBMath.cos(backAngle1) * 0.5, a.tailLocation.getY() + DBMath.sin(backAngle1) * 0.5);
        EPoint tailRight = new EPoint(a.tailLocation.getX() + DBMath.cos(backAngle2) * 0.5, a.tailLocation.getY() + DBMath.sin(backAngle2) * 0.5);
        b.pushPoint(tailLeft);
        b.pushPoint(headLeft);
        b.pushPoint(tailRight);
        b.pushPoint(headRight);
        if (a.isHeadArrowed()) {
            angleOfArrow = 450;
            backAngle1 = angle - angleOfArrow;
            backAngle2 = angle + angleOfArrow;
            EPoint headArrowLeft = new EPoint(a.headLocation.getX() + DBMath.cos(backAngle1) * 0.5 * 2.0, a.headLocation.getY() + DBMath.sin(backAngle1) * 0.5 * 2.0);
            EPoint headArrowRight = new EPoint(a.headLocation.getX() + DBMath.cos(backAngle2) * 0.5 * 2.0, a.headLocation.getY() + DBMath.sin(backAngle2) * 0.5 * 2.0);
            b.pushPoint(a.headLocation);
            b.pushPoint(headArrowLeft);
            b.pushPoint(a.headLocation);
            b.pushPoint(headArrowRight);
        }
        b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
    }

    private void addZigZagArc(AbstractShapeBuilder b, ImmutableArcInst a, EGraphics graphicsOverride, Layer layer) {
        int angle = a.getDefinedAngle();
        int angleOfArrow = 900;
        int backAngle1 = angle - angleOfArrow;
        int backAngle2 = angle + angleOfArrow;
        double centerX = (a.headLocation.getX() + a.tailLocation.getX()) / 2.0;
        double centerY = (a.headLocation.getY() + a.tailLocation.getY()) / 2.0;
        EPoint centerLeft = new EPoint(centerX + DBMath.cos(backAngle1) * 0.5, centerY + DBMath.sin(backAngle1) * 0.5);
        EPoint centerRight = new EPoint(centerX + DBMath.cos(backAngle2) * 0.5, centerY + DBMath.sin(backAngle2) * 0.5);
        b.pushPoint(a.headLocation);
        b.pushPoint(centerLeft);
        b.pushPoint(centerLeft);
        b.pushPoint(centerRight);
        b.pushPoint(centerRight);
        b.pushPoint(a.tailLocation);
        b.pushPoly(Poly.Type.VECTORS, layer, graphicsOverride, null);
    }
}

