/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CellUsage
extends HierarchyEnumerator.Visitor {
    private Map<Cell, CellContext> cellsInUse = new HashMap<Cell, CellContext>();
    private List<Cell> cellsInRevTopoOrder = new ArrayList<Cell>();
    private Map<Cell.CellGroup, Set<CellContext>> groupToAdditions = new HashMap<Cell.CellGroup, Set<CellContext>>();
    private Cell root;
    private Set<Cell> singleUseCells;
    private Set<Cell> cellsWithLeGates;

    private void prln(String s) {
        System.out.println(s);
    }

    private void processCellGroupAdditions(CellContext cellCtxt) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cellCtxt.cell);
        if (ann == null) {
            return;
        }
        Cell.CellGroup group = ann.getGroupToJoin();
        if (group == null) {
            return;
        }
        Set<CellContext> additions = this.groupToAdditions.get(group);
        if (additions == null) {
            additions = new HashSet<CellContext>();
            this.groupToAdditions.put(group, additions);
        }
        additions.add(cellCtxt);
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.root == null) {
            this.root = cell;
        }
        VarContext context = info.getContext();
        if (this.cellsInUse.containsKey(cell)) {
            return false;
        }
        CellContext cellCtxt = new CellContext(cell, context);
        this.cellsInUse.put(cell, cellCtxt);
        this.processCellGroupAdditions(cellCtxt);
        return true;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
        this.cellsInRevTopoOrder.add(info.getCell());
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    private void addUse(Set<Cell> usedOnce, Set<Cell> usedMoreThanOnce, Cell c) {
        if (usedMoreThanOnce.contains(c)) {
            return;
        }
        if (usedOnce.contains(c)) {
            usedOnce.remove(c);
            usedMoreThanOnce.add(c);
        } else {
            usedOnce.add(c);
        }
    }

    private Set<Cell> findSingleUseCells() {
        HashSet<Cell> singleUseCells = new HashSet<Cell>();
        HashMap<Cell, HashSet<Cell>> cellToUsedOnce = new HashMap<Cell, HashSet<Cell>>();
        HashSet<Cell> usedMoreThanOnce = new HashSet<Cell>();
        Iterator<Cell> it = this.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell c = it.next();
            HashSet<Cell> usedOnce = new HashSet<Cell>();
            Iterator<Nodable> noIt = c.getNetlist(NccNetlist.SHORT_RESISTORS).getNodables();
            while (noIt.hasNext()) {
                NodeProto np = noIt.next().getProto();
                if (!(np instanceof Cell)) continue;
                Cell child = (Cell)np;
                this.addUse(usedOnce, usedMoreThanOnce, child);
                if (!cellToUsedOnce.containsKey(child)) continue;
                Set childUsedOnce = (Set)cellToUsedOnce.get(child);
                for (Cell ci : childUsedOnce) {
                    this.addUse(usedOnce, usedMoreThanOnce, ci);
                }
            }
            cellToUsedOnce.put(c, usedOnce);
            if (it.hasNext()) continue;
            singleUseCells.add(c);
            singleUseCells.addAll(usedOnce);
        }
        return singleUseCells;
    }

    private boolean isLeGate(Nodable no) {
        boolean attrLeGate = no.getParameterOrVariable(LENetlister.ATTR_LEGATE) != null || no.getParameterOrVariable(LENetlister.ATTR_LEKEEPER) != null;
        boolean hasGetDrive = false;
        Iterator<Variable> vIt = no.getDefinedParameters();
        while (vIt.hasNext()) {
            String expr;
            Variable v = vIt.next();
            if (!v.isJava() || (expr = v.getObject().toString()).indexOf("getDrive") == -1 && expr.indexOf("getdrive") == -1) continue;
            hasGetDrive = true;
        }
        if (hasGetDrive && !attrLeGate) {
            this.prln("  Warning: instance: " + no.getName() + " in Cell: " + no.getParent().describe(false) + " has a variable that calls getDrive but the instance " + "has no variable named LEGATE or LEKEEPER");
        }
        if (!attrLeGate || !hasGetDrive) {
            // empty if block
        }
        return hasGetDrive;
    }

    private Set<Cell> findCellsWithLeGate() {
        HashSet<Cell> cellsWithLeGate = new HashSet<Cell>();
        Iterator<Cell> it = this.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell c = it.next();
            boolean hasLeGate = false;
            Iterator<Nodable> noIt = c.getNetlist(NccNetlist.SHORT_RESISTORS).getNodables();
            while (noIt.hasNext()) {
                Cell child;
                Nodable no = noIt.next();
                if (this.isLeGate(no)) {
                    hasLeGate = true;
                    break;
                }
                NodeProto np = no.getProto();
                if (!(np instanceof Cell) || !cellsWithLeGate.contains(child = (Cell)np)) continue;
                hasLeGate = true;
                break;
            }
            if (!hasLeGate) continue;
            System.out.println("  Cell contains LE gate: " + c.describe(false));
            cellsWithLeGate.add(c);
        }
        return cellsWithLeGate;
    }

    private boolean cellIsParameterized(Cell c) {
        return c.hasParameters();
    }

    private void postProcess() {
        this.singleUseCells = this.findSingleUseCells();
        this.cellsWithLeGates = this.findCellsWithLeGate();
    }

    private CellUsage() {
    }

    public static CellUsage getCellUsage(CellContext root) {
        CellUsage visitor = new CellUsage();
        HierarchyEnumerator.enumerateCell(root.cell, root.context, (HierarchyEnumerator.Visitor)visitor);
        visitor.postProcess();
        return visitor;
    }

    public boolean cellIsUsed(Cell cell) {
        return this.cellsInUse.containsKey(cell);
    }

    public boolean cellHasOnlyOneSize(Cell cell) {
        return this.singleUseCells.contains(cell) || !this.cellsWithLeGates.contains(cell) && !this.cellIsParameterized(cell);
    }

    public Iterator<Cell> cellsInReverseTopologicalOrder() {
        return this.cellsInRevTopoOrder.iterator();
    }

    public CellContext getCellContext(Cell cell) {
        Job.error(!this.cellsInUse.containsKey(cell), "cell not found");
        return this.cellsInUse.get(cell);
    }

    public Set<CellContext> getGroupAdditions(Cell.CellGroup group) {
        HashSet additions = this.groupToAdditions.get(group);
        return additions != null ? additions : new HashSet();
    }

    public Cell getRoot() {
        return this.root;
    }
}

