/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.generator.flag.router.Channel;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.generator.layout.TechType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdRoute {
    private TechType tech;
    private List<Channel> m2channels;
    private List<Channel> m3channels;

    private BdRoute(TechType tech) {
        this.tech = tech;
    }

    private List<NodeInst> getStages(Cell layCell) {
        ArrayList<NodeInst> stages = new ArrayList<NodeInst>();
        Iterator<NodeInst> nIt = layCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            stages.add(ni);
        }
        Collections.sort(stages, new Comparator<NodeInst>(){

            @Override
            public int compare(NodeInst n1, NodeInst n2) {
                double delta = n1.getAnchorCenterY() - n2.getAnchorCenterY();
                return (int)Math.signum(delta);
            }
        });
        return stages;
    }

    private void setUpChannels(Cell layCell) {
        List<NodeInst> stages = this.getStages(layCell);
    }

    private void route1(Cell layCell, List<ToConnect> work) {
    }

    public static void route(Cell layCell, List<ToConnect> work, TechType tech) {
        BdRoute br = new BdRoute(tech);
        br.route1(layCell, work);
    }
}

