/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMenu
extends EDialog {
    private JList listNodes;
    private JList listArcs;
    private JList listCells;
    private JList listSpecials;
    private JList listPopup;
    private DefaultListModel modelNodes;
    private DefaultListModel modelArcs;
    private DefaultListModel modelCells;
    private DefaultListModel modelSpecials;
    private DefaultListModel modelPopup;
    private int menuWid;
    private int menuHei;
    private int menuSelectedX;
    private int menuSelectedY;
    private int lastListSelected = -1;
    private Object[][] menuArray;
    private Object[][] factoryMenuArray;
    private MenuView menuView;
    private String techName;
    private Xml.Technology xTech;
    private boolean changingNodeFields = false;
    private boolean changed;
    private JPanel Top;
    private JButton addButton;
    private JButton addColumn;
    private JButton addRow;
    private JScrollPane arcListPane;
    private JScrollPane cellListPane;
    private JButton deleteColumn;
    private JButton deleteRow;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox libraryName;
    private JPanel lowerLeft;
    private JPanel lowerRight;
    private JLabel menuSize;
    private JTextField nodeAngle;
    private JLabel nodeAngleLabel;
    private JComboBox nodeFunction;
    private JLabel nodeFunctionLabel;
    private JScrollPane nodeListPane;
    private JTextField nodeName;
    private JLabel nodeNameLabel;
    private JScrollPane popupListPane;
    private JButton removeButton;
    private JLabel selectedMenuName;
    private JScrollPane specialListPane;

    public static void showComponentMenuDialog(String techName, Xml.MenuPalette xmp, List<Xml.PrimitiveNodeGroup> nodeGroups, List<Xml.ArcProto> arcs) {
        ComponentMenu dialog = new ComponentMenu((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setTitle("Technology Edit: Component Menu Layout");
        Xml.Technology xTech = new Xml.Technology();
        xTech.nodeGroups.addAll(nodeGroups);
        xTech.arcs.addAll(arcs);
        xTech.menuPalette = xmp;
        int menuWid = xmp.numColumns;
        int menuHei = xmp.menuBoxes.size() / menuWid;
        Object[][] menuArray = new Object[menuHei][menuWid];
        int i = 0;
        for (int y = 0; y < menuHei; ++y) {
            for (int x = 0; x < menuWid; ++x) {
                List<?> obj;
                if ((obj = xmp.menuBoxes.get(i++)) instanceof List) {
                    List<?> l = obj;
                    if (l.size() == 0) {
                        obj = null;
                    } else if (l.size() == 1) {
                        obj = l.get(0);
                    }
                }
                menuArray[y][x] = obj;
            }
        }
        dialog.showTechnology(techName, xTech, menuArray, menuArray);
        dialog.finishInitialization();
        dialog.setVisible(true);
    }

    public ComponentMenu(Frame parent, boolean techEdit) {
        super(parent, true);
        this.initComponents();
        this.menuView = new MenuView();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 8;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.9;
        gbc.insets = new Insets(1, 4, 4, 4);
        this.Top.add((Component)this.menuView, gbc);
        List<PrimitiveNode.Function> funs = PrimitiveNode.Function.getFunctions();
        for (PrimitiveNode.Function fun : funs) {
            this.nodeFunction.addItem(fun.getName());
        }
        this.modelNodes = new DefaultListModel();
        this.listNodes = new JList(this.modelNodes);
        this.nodeListPane.setViewportView(this.listNodes);
        this.listNodes.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComponentMenu.this.selectList(0);
            }
        });
        this.modelArcs = new DefaultListModel();
        this.listArcs = new JList(this.modelArcs);
        this.arcListPane.setViewportView(this.listArcs);
        this.listArcs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComponentMenu.this.selectList(1);
            }
        });
        this.modelCells = new DefaultListModel();
        this.listCells = new JList(this.modelCells);
        this.cellListPane.setViewportView(this.listCells);
        this.listCells.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComponentMenu.this.selectList(2);
            }
        });
        for (Library lib : Library.getVisibleLibraries()) {
            this.libraryName.addItem(lib.getName());
        }
        this.libraryName.setSelectedItem(Library.getCurrent());
        this.libraryChanged();
        this.libraryName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.libraryChanged();
            }
        });
        this.modelSpecials = new DefaultListModel();
        this.modelSpecials.addElement("Cell");
        this.modelSpecials.addElement("Export");
        this.modelSpecials.addElement("Misc.");
        this.modelSpecials.addElement("Pure");
        this.modelSpecials.addElement("Spice");
        this.listSpecials = new JList(this.modelSpecials);
        this.specialListPane.setViewportView(this.listSpecials);
        this.listSpecials.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComponentMenu.this.selectList(3);
            }
        });
        this.modelPopup = new DefaultListModel();
        this.listPopup = new JList(this.modelPopup);
        this.popupListPane.setViewportView(this.listPopup);
        this.listPopup.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ComponentMenu.this.showSelectedPopup();
            }
        });
        this.nodeAngle.getDocument().addDocumentListener(new NodeFieldDocumentListener());
        this.nodeName.getDocument().addDocumentListener(new NodeFieldDocumentListener());
        this.nodeFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.nodeInfoChanged();
            }
        });
        if (techEdit) {
            JButton OK = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.insets = new Insets(25, 4, 4, 4);
            this.lowerRight.add((Component)OK, gbc);
            OK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ComponentMenu.this.saveChanges();
                    ComponentMenu.this.closeDialog(null);
                }
            });
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.insets = new Insets(25, 4, 4, 4);
            this.lowerRight.add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ComponentMenu.this.closeDialog(null);
                }
            });
        }
    }

    public void showTechnology(String name, Xml.Technology xt, Object[][] theArray, Object[][] factoryArray) {
        this.techName = name;
        this.xTech = xt;
        this.menuArray = theArray;
        this.factoryMenuArray = factoryArray;
        this.menuHei = this.menuArray.length;
        this.menuWid = this.menuArray[0].length;
        this.modelNodes.clear();
        for (Xml.PrimitiveNodeGroup ng : this.xTech.nodeGroups) {
            for (Xml.PrimitiveNode n : ng.nodes) {
                this.modelNodes.addElement(n.name);
            }
        }
        this.modelArcs.clear();
        for (Xml.ArcProto ap : this.xTech.arcs) {
            this.modelArcs.addElement(ap.name);
        }
        this.showMenuSize();
        this.showSelected();
        this.menuView.repaint();
        this.changed = false;
    }

    public void factoryReset() {
        this.menuHei = this.factoryMenuArray.length;
        this.menuWid = this.factoryMenuArray[0].length;
        this.menuArray = new Object[this.menuHei][];
        for (int y = 0; y < this.menuHei; ++y) {
            this.menuArray[y] = new Object[this.menuWid];
            for (int x = 0; x < this.menuWid; ++x) {
                this.menuArray[y][x] = this.factoryMenuArray[y][x];
            }
        }
        this.menuSelectedX = 0;
        this.menuSelectedY = 0;
        this.showMenuSize();
        this.showSelected();
        this.menuView.repaint();
        this.changed = true;
    }

    @Override
    public String getName() {
        return "Component Menu";
    }

    public JPanel getPanel() {
        return this.Top;
    }

    @Override
    protected void escapePressed() {
        this.closeDialog(null);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Object[][] getMenuInfo() {
        return this.menuArray;
    }

    public static Xml.MenuPalette getMenuPalette(Technology tech) {
        String nodeGroupXML = new ComponentMenuPreferences((boolean)false).menuXmls.get(tech);
        if (nodeGroupXML == null || nodeGroupXML.length() == 0) {
            return tech.getFactoryMenuPalette();
        }
        return tech.parseComponentMenuXML(nodeGroupXML);
    }

    private void saveChanges() {
        if (!this.changed) {
            return;
        }
        Xml.MenuPalette xmp = new Xml.MenuPalette();
        xmp.numColumns = this.menuWid;
        xmp.menuBoxes = new ArrayList();
        for (int y = 0; y < this.menuHei; ++y) {
            for (int x = 0; x < this.menuWid; ++x) {
                Object item = null;
                if (this.menuArray[y] != null) {
                    item = this.menuArray[y][x];
                }
                if (item instanceof List) {
                    xmp.menuBoxes.add((List)item);
                    continue;
                }
                ArrayList<Object> subList = new ArrayList<Object>();
                if (item != null) {
                    subList.add(item);
                }
                xmp.menuBoxes.add(subList);
            }
        }
        new SetMenuJob(xmp.writeXml());
    }

    private void selectList(int list) {
        this.lastListSelected = list;
        switch (list) {
            case 0: {
                this.listArcs.clearSelection();
                this.listCells.clearSelection();
                this.listSpecials.clearSelection();
                break;
            }
            case 1: {
                this.listNodes.clearSelection();
                this.listCells.clearSelection();
                this.listSpecials.clearSelection();
                break;
            }
            case 2: {
                this.listNodes.clearSelection();
                this.listArcs.clearSelection();
                this.listSpecials.clearSelection();
                break;
            }
            case 3: {
                this.listNodes.clearSelection();
                this.listArcs.clearSelection();
                this.listCells.clearSelection();
            }
        }
    }

    private void showMenuSize() {
        this.menuSize.setText(this.techName + " Component menu (" + this.menuWid + " by " + this.menuHei + ")");
    }

    private void showSelected() {
        Object item = this.menuArray[this.menuSelectedY] == null ? null : this.menuArray[this.menuSelectedY][this.menuSelectedX];
        this.showSelectedObject(item, false);
    }

    private void showSelectedObject(Object item, boolean fromPopup) {
        this.showThisNode(false, null, null);
        if (!fromPopup) {
            this.popupListPane.setViewportView(null);
            this.modelPopup.clear();
        }
        if (item instanceof Xml.PrimitiveNode) {
            Xml.PrimitiveNode np = (Xml.PrimitiveNode)item;
            if (!fromPopup) {
                this.selectedMenuName.setText("Node entry: " + np.name);
            }
            this.showThisNode(true, null, np);
        } else if (item instanceof Xml.MenuNodeInst) {
            Xml.MenuNodeInst ni = (Xml.MenuNodeInst)item;
            String name = "Node entry: " + ni.protoName;
            if (!fromPopup) {
                this.selectedMenuName.setText(name);
            }
            this.showThisNode(true, ni, null);
        } else if (item instanceof Xml.ArcProto) {
            Xml.ArcProto ap = (Xml.ArcProto)item;
            if (!fromPopup) {
                this.selectedMenuName.setText("Arc entry: " + ap.name);
            }
        } else if (item instanceof JSeparator) {
            if (!fromPopup) {
                this.selectedMenuName.setText("Separator");
            }
        } else if (item instanceof List && !fromPopup) {
            this.selectedMenuName.setText("Popup menu entry:");
            this.popupListPane.setViewportView(this.listPopup);
            List nodes = (List)item;
            for (Object obj : nodes) {
                if (obj instanceof Xml.PrimitiveNode) {
                    this.modelPopup.addElement(((Xml.PrimitiveNode)obj).name);
                    continue;
                }
                if (obj instanceof Xml.MenuNodeInst) {
                    this.modelPopup.addElement(this.getNodeName((Xml.MenuNodeInst)obj));
                    continue;
                }
                if (obj instanceof Xml.ArcProto) {
                    this.modelPopup.addElement(((Xml.ArcProto)obj).name);
                    continue;
                }
                if (obj instanceof JSeparator) {
                    this.modelPopup.addElement("----------");
                    continue;
                }
                this.modelPopup.addElement(obj);
            }
        } else if (item instanceof String) {
            String s = (String)item;
            if (s.startsWith("LOADCELL ")) {
                if (!fromPopup) {
                    this.selectedMenuName.setText("Cell entry: " + s.substring(9));
                }
            } else if (!fromPopup) {
                this.selectedMenuName.setText("Special entry: " + s);
            }
        } else if (!fromPopup) {
            this.selectedMenuName.setText("Empty entry");
        }
    }

    private void showSelectedPopup() {
        Object item;
        Object object = item = this.menuArray[this.menuSelectedY] == null ? null : this.menuArray[this.menuSelectedY][this.menuSelectedX];
        if (item == null) {
            return;
        }
        if (item instanceof List) {
            List nodes = (List)item;
            int index = this.listPopup.getSelectedIndex();
            if (index < 0 || index >= nodes.size()) {
                return;
            }
            Object obj = nodes.get(index);
            this.showSelectedObject(obj, true);
        }
    }

    private String getNodeName(Xml.MenuNodeInst ni) {
        return ni.protoName;
    }

    private void nodeInfoChanged() {
        String protoName;
        Object item;
        if (this.changingNodeFields) {
            return;
        }
        Object object = item = this.menuArray[this.menuSelectedY] == null ? null : this.menuArray[this.menuSelectedY][this.menuSelectedX];
        if (item == null) {
            return;
        }
        int index = -1;
        List nodes = null;
        if (item instanceof List) {
            nodes = (List)item;
            index = this.listPopup.getSelectedIndex();
            if (index < 0 || index >= nodes.size()) {
                return;
            }
            item = nodes.get(index);
        }
        if (item instanceof Xml.MenuNodeInst) {
            protoName = ((Xml.MenuNodeInst)item).protoName;
        } else if (item instanceof Xml.PrimitiveNode) {
            protoName = ((Xml.PrimitiveNode)item).name;
        } else {
            return;
        }
        Xml.MenuNodeInst newItem = new Xml.MenuNodeInst();
        newItem.protoName = protoName;
        newItem.function = PrimitiveNode.Function.findName((String)this.nodeFunction.getSelectedItem());
        newItem.rotation = TextUtils.atoi(this.nodeAngle.getText()) * 10;
        newItem.text = this.nodeName.getText().trim();
        if (index < 0) {
            this.menuArray[this.menuSelectedY][this.menuSelectedX] = newItem;
        } else {
            nodes.set(index, newItem);
        }
        this.menuView.repaint();
        this.changed = true;
    }

    private void libraryChanged() {
        this.modelCells.clear();
        String libName = (String)this.libraryName.getSelectedItem();
        if (libName == null) {
            return;
        }
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            this.modelCells.addElement(cell.noLibDescribe());
        }
    }

    private void showThisNode(boolean valid, Xml.MenuNodeInst ni, Xml.PrimitiveNode np) {
        this.changingNodeFields = true;
        this.nodeName.setText("");
        this.nodeAngle.setText("");
        this.nodeFunction.setSelectedIndex(0);
        if (valid) {
            this.nodeAngle.setEnabled(true);
            this.nodeAngleLabel.setEnabled(true);
            this.nodeFunction.setEnabled(true);
            this.nodeFunctionLabel.setEnabled(true);
            this.nodeName.setEnabled(true);
            this.nodeNameLabel.setEnabled(true);
            if (ni == null) {
                this.nodeAngle.setText("0");
                if (np != null) {
                    this.nodeFunction.setSelectedItem(np.function.getName());
                }
            } else {
                this.nodeAngle.setText(ni.rotation / 10 + "");
                this.nodeFunction.setSelectedItem(ni.function.getName());
                if (ni.text != null) {
                    this.nodeName.setText(ni.text);
                }
            }
        } else {
            this.nodeAngle.setEnabled(false);
            this.nodeAngleLabel.setEnabled(false);
            this.nodeFunction.setEnabled(false);
            this.nodeFunctionLabel.setEnabled(false);
            this.nodeName.setEnabled(false);
            this.nodeNameLabel.setEnabled(false);
        }
        this.changingNodeFields = false;
    }

    private void addToMenu(Object obj) {
        Object item;
        if (this.menuArray[this.menuSelectedY] == null) {
            this.menuArray[this.menuSelectedY] = new Object[this.menuWid];
        }
        if ((item = this.menuArray[this.menuSelectedY][this.menuSelectedX]) == null) {
            this.menuArray[this.menuSelectedY][this.menuSelectedX] = obj;
        } else if (item instanceof List) {
            List popupItems = (List)item;
            if (!this.isUniformType(popupItems, obj)) {
                return;
            }
            popupItems.add(obj);
        } else {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.add(item);
            if (!this.isUniformType(newList, obj)) {
                return;
            }
            newList.add(obj);
            this.menuArray[this.menuSelectedY][this.menuSelectedX] = newList;
        }
        this.menuView.repaint();
        this.showSelected();
        this.changed = true;
    }

    private boolean isUniformType(List list, Object newOne) {
        if (newOne instanceof String) {
            Job.getUserInterface().showErrorMessage("Must remove everything in the menu before adding 'special text'", "Cannot Add");
            return false;
        }
        for (Object oldOne : list) {
            if (oldOne instanceof Xml.ArcProto) {
                if (newOne instanceof Xml.ArcProto) continue;
                Job.getUserInterface().showErrorMessage("Existing Arc menu can only have other arcs added to it", "Cannot Add");
                return false;
            }
            if (oldOne instanceof Xml.PrimitiveNode) {
                if (newOne instanceof Xml.PrimitiveNode) continue;
                Job.getUserInterface().showErrorMessage("Existing Primitive Node menu can only have other primitive nodes added to it", "Cannot Add");
                return false;
            }
            if (!(oldOne instanceof String) || !((String)oldOne).startsWith("LOADCELL ") || newOne instanceof String && ((String)newOne).startsWith("LOADCELL ")) continue;
            Job.getUserInterface().showErrorMessage("Existing Cell menu can only have other cells added to it", "Cannot Add");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.Top = new JPanel();
        this.nodeListPane = new JScrollPane();
        this.arcListPane = new JScrollPane();
        this.menuSize = new JLabel();
        this.specialListPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.lowerRight = new JPanel();
        this.addRow = new JButton();
        this.deleteRow = new JButton();
        this.addColumn = new JButton();
        this.deleteColumn = new JButton();
        this.lowerLeft = new JPanel();
        this.selectedMenuName = new JLabel();
        this.popupListPane = new JScrollPane();
        this.nodeAngleLabel = new JLabel();
        this.nodeFunctionLabel = new JLabel();
        this.nodeNameLabel = new JLabel();
        this.nodeName = new JTextField();
        this.nodeFunction = new JComboBox();
        this.nodeAngle = new JTextField();
        this.cellListPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.libraryName = new JComboBox();
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.setTitle("Component Menu");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ComponentMenu.this.closeDialog(evt);
            }
        });
        this.Top.setLayout(new GridBagLayout());
        this.nodeListPane.setPreferredSize(new Dimension(200, 200));
        this.nodeListPane.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.Top.add((Component)this.nodeListPane, gridBagConstraints);
        this.arcListPane.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.Top.add((Component)this.arcListPane, gridBagConstraints);
        this.menuSize.setText("Menu");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.Top.add((Component)this.menuSize, gridBagConstraints);
        this.specialListPane.setOpaque(false);
        this.specialListPane.setPreferredSize(new Dimension(200, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.Top.add((Component)this.specialListPane, gridBagConstraints);
        this.jLabel2.setText("Nodes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 40, 1, 4);
        this.Top.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Arcs:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 40, 1, 4);
        this.Top.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Special:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 40, 1, 4);
        this.Top.add((Component)this.jLabel4, gridBagConstraints);
        this.addButton.setText("<< Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.removeButton, gridBagConstraints);
        this.lowerRight.setLayout(new GridBagLayout());
        this.addRow.setText("Add Row Below Current");
        this.addRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.addRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.lowerRight.add((Component)this.addRow, gridBagConstraints);
        this.deleteRow.setText("Delete Row With Current");
        this.deleteRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.deleteRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.lowerRight.add((Component)this.deleteRow, gridBagConstraints);
        this.addColumn.setText("Add Column to Right of Current");
        this.addColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.addColumnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.lowerRight.add((Component)this.addColumn, gridBagConstraints);
        this.deleteColumn.setText("Delete Column With Current");
        this.deleteColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComponentMenu.this.deleteColumnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.lowerRight.add((Component)this.deleteColumn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.Top.add((Component)this.lowerRight, gridBagConstraints);
        this.lowerLeft.setLayout(new GridBagLayout());
        this.selectedMenuName.setText("selected menu");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.lowerLeft.add((Component)this.selectedMenuName, gridBagConstraints);
        this.popupListPane.setPreferredSize(new Dimension(200, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.lowerLeft.add((Component)this.popupListPane, gridBagConstraints);
        this.nodeAngleLabel.setText("Angle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.lowerLeft.add((Component)this.nodeAngleLabel, gridBagConstraints);
        this.nodeFunctionLabel.setText("Function:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.lowerLeft.add((Component)this.nodeFunctionLabel, gridBagConstraints);
        this.nodeNameLabel.setText("Label:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.lowerLeft.add((Component)this.nodeNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.lowerLeft.add((Component)this.nodeName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.lowerLeft.add((Component)this.nodeFunction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.lowerLeft.add((Component)this.nodeAngle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        this.Top.add((Component)this.lowerLeft, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.Top.add((Component)this.cellListPane, gridBagConstraints);
        this.jLabel1.setText("Cells:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 40, 1, 4);
        this.Top.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.Top.add((Component)this.libraryName, gridBagConstraints);
        this.getContentPane().add((Component)this.Top, "Center");
        this.pack();
    }

    private void deleteColumnActionPerformed(ActionEvent evt) {
        if (this.menuWid <= 1) {
            Job.getUserInterface().showErrorMessage("There must be at least one column...cannot delete the last one", "Cannot Remove Column");
            return;
        }
        for (int y = 0; y < this.menuHei; ++y) {
            Object[] newRow = new Object[this.menuWid - 1];
            int fill = 0;
            for (int x = 0; x < this.menuWid; ++x) {
                if (x == this.menuSelectedX) continue;
                newRow[fill++] = this.menuArray[y][x];
            }
            this.menuArray[y] = newRow;
        }
        --this.menuWid;
        if (this.menuSelectedX >= this.menuWid) {
            --this.menuSelectedX;
        }
        this.menuView.repaint();
        this.showSelected();
        this.showMenuSize();
        this.changed = true;
    }

    private void addColumnActionPerformed(ActionEvent evt) {
        for (int y = 0; y < this.menuHei; ++y) {
            Object[] newRow = new Object[this.menuWid + 1];
            int fill = 0;
            for (int x = 0; x < this.menuWid; ++x) {
                newRow[fill++] = this.menuArray[y][x];
                if (x != this.menuSelectedX) continue;
                newRow[fill++] = null;
            }
            this.menuArray[y] = newRow;
        }
        ++this.menuWid;
        ++this.menuSelectedX;
        this.menuView.repaint();
        this.showSelected();
        this.showMenuSize();
        this.changed = true;
    }

    private void deleteRowActionPerformed(ActionEvent evt) {
        if (this.menuHei <= 1) {
            Job.getUserInterface().showErrorMessage("There must be at least one row...cannot delete the last one", "Cannot Remove Row");
            return;
        }
        Object[][] newMenu = new Object[this.menuHei - 1][];
        int fill = 0;
        for (int y = 0; y < this.menuHei; ++y) {
            if (y == this.menuSelectedY) continue;
            newMenu[fill++] = this.menuArray[y];
        }
        this.menuArray = newMenu;
        --this.menuHei;
        if (this.menuSelectedY >= this.menuHei) {
            --this.menuSelectedY;
        }
        this.menuView.repaint();
        this.showSelected();
        this.showMenuSize();
        this.changed = true;
    }

    private void addRowActionPerformed(ActionEvent evt) {
        Object[][] newMenu = new Object[this.menuHei + 1][];
        int fill = 0;
        for (int y = 0; y < this.menuHei; ++y) {
            if (y == this.menuSelectedY) {
                newMenu[fill++] = new Object[this.menuWid];
            }
            newMenu[fill++] = this.menuArray[y];
        }
        this.menuArray = newMenu;
        ++this.menuHei;
        ++this.menuSelectedY;
        this.menuView.repaint();
        this.showSelected();
        this.showMenuSize();
        this.changed = true;
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object item;
        if (this.menuArray[this.menuSelectedY] == null) {
            this.menuArray[this.menuSelectedY] = new Object[this.menuWid];
        }
        if ((item = this.menuArray[this.menuSelectedY][this.menuSelectedX]) == null) {
            return;
        }
        if (item instanceof List) {
            List popupItems = (List)item;
            int index = this.listPopup.getSelectedIndex();
            if (index < 0) {
                Job.getUserInterface().showErrorMessage("Must first select the popup item to be removed from the list", "Cannot Remove");
                return;
            }
            popupItems.remove(index);
            if (popupItems.size() == 1) {
                this.menuArray[this.menuSelectedY][this.menuSelectedX] = popupItems.get(0);
            }
        } else {
            this.menuArray[this.menuSelectedY][this.menuSelectedX] = null;
        }
        this.menuView.repaint();
        this.showSelected();
        this.changed = true;
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        switch (this.lastListSelected) {
            case 0: {
                String nodeName = (String)this.listNodes.getSelectedValue();
                Xml.PrimitiveNode pnp = this.xTech.findNode(nodeName);
                this.addToMenu(pnp);
                break;
            }
            case 1: {
                String arcName = (String)this.listArcs.getSelectedValue();
                Xml.ArcProto ap = this.xTech.findArc(arcName);
                this.addToMenu(ap);
                break;
            }
            case 2: {
                String cellName = (String)this.listCells.getSelectedValue();
                String libName = (String)this.libraryName.getSelectedItem();
                this.addToMenu("LOADCELL " + libName + ":" + cellName);
                break;
            }
            case 3: {
                String specialName = (String)this.listSpecials.getSelectedValue();
                this.addToMenu(specialName);
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class MenuView
    extends JPanel
    implements MouseListener {
        MenuView() {
            this.addMouseListener(this);
        }

        public void paint(Graphics g) {
            int i;
            Dimension dim = this.getSize();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, dim.width, dim.height);
            g.setColor(Color.BLACK);
            for (i = 0; i <= ComponentMenu.this.menuHei; ++i) {
                int y = dim.height - 1 - (dim.height - 1) * i / ComponentMenu.this.menuHei;
                g.drawLine(0, y, dim.width - 1, y);
            }
            for (i = 0; i <= ComponentMenu.this.menuWid; ++i) {
                int x = (dim.width - 1) * i / ComponentMenu.this.menuWid;
                g.drawLine(x, 0, x, dim.height - 1);
            }
            for (i = 0; i < ComponentMenu.this.menuWid; ++i) {
                for (int j = 0; j < ComponentMenu.this.menuHei; ++j) {
                    int lowX = (dim.width - 1) * i / ComponentMenu.this.menuWid;
                    int lowY = dim.height - 1 - (dim.height - 1) * (j + 1) / ComponentMenu.this.menuHei;
                    int highX = (dim.width - 1) * (i + 1) / ComponentMenu.this.menuWid;
                    int highY = dim.height - 1 - (dim.height - 1) * j / ComponentMenu.this.menuHei;
                    Object item = ComponentMenu.this.menuArray[j] == null ? null : ComponentMenu.this.menuArray[j][i];
                    Color borderColor = null;
                    if (item instanceof Xml.PrimitiveNode) {
                        Xml.PrimitiveNode np = (Xml.PrimitiveNode)item;
                        int midY = (lowY + highY) / 2;
                        this.showString(g, "Node", lowX, highX, lowY, midY);
                        this.showString(g, np.name, lowX, highX, midY, highY);
                        borderColor = Color.BLUE;
                    } else if (item instanceof Xml.MenuNodeInst) {
                        Xml.MenuNodeInst ni = (Xml.MenuNodeInst)item;
                        int midY = (lowY + highY) / 2;
                        this.showString(g, "Node", lowX, highX, lowY, midY);
                        this.showString(g, ComponentMenu.this.getNodeName(ni), lowX, highX, midY, highY);
                        borderColor = Color.BLUE;
                    } else if (item instanceof Xml.ArcProto) {
                        Xml.ArcProto ap = (Xml.ArcProto)item;
                        int midY = (lowY + highY) / 2;
                        this.showString(g, "Arc", lowX, highX, lowY, midY);
                        this.showString(g, ap.name, lowX, highX, midY, highY);
                        borderColor = Color.RED;
                    } else if (item instanceof List) {
                        List popupItems = (List)item;
                        for (Object o : popupItems) {
                            if (o instanceof Xml.PrimitiveNode || o instanceof Xml.MenuNodeInst) {
                                borderColor = Color.BLUE;
                                continue;
                            }
                            if (!(o instanceof Xml.ArcProto)) continue;
                            borderColor = Color.RED;
                        }
                        this.showString(g, "POPUP", lowX, highX, lowY, highY);
                    } else if (item instanceof String) {
                        String s = (String)item;
                        if (s.startsWith("LOADCELL ")) {
                            String cellName = s.substring(9);
                            int midY = (lowY + highY) / 2;
                            this.showString(g, "Cell", lowX, highX, lowY, midY);
                            this.showString(g, cellName, lowX, highX, midY, highY);
                            borderColor = Color.BLUE;
                        } else {
                            this.showString(g, "\"" + (String)item + "\"", lowX, highX, lowY, highY);
                        }
                    }
                    if (borderColor == null) continue;
                    g.setColor(borderColor);
                    g.drawLine(lowX + 1, lowY - 1, highX - 1, lowY - 1);
                    g.drawLine(highX - 1, lowY - 1, highX - 1, highY + 1);
                    g.drawLine(highX - 1, highY + 1, lowX + 1, highY + 1);
                    g.drawLine(lowX + 1, highY + 1, lowX + 1, lowY - 1);
                }
            }
            if (ComponentMenu.this.menuSelectedX >= 0 && ComponentMenu.this.menuSelectedY >= 0) {
                int lowX = (dim.width - 1) * ComponentMenu.this.menuSelectedX / ComponentMenu.this.menuWid;
                int lowY = dim.height - 1 - (dim.height - 1) * (ComponentMenu.this.menuSelectedY + 1) / ComponentMenu.this.menuHei;
                int highX = (dim.width - 1) * (ComponentMenu.this.menuSelectedX + 1) / ComponentMenu.this.menuWid;
                int highY = dim.height - 1 - (dim.height - 1) * ComponentMenu.this.menuSelectedY / ComponentMenu.this.menuHei;
                g.setColor(Color.GREEN);
                g.drawLine(lowX, lowY, highX, lowY);
                g.drawLine(highX, lowY, highX, highY);
                g.drawLine(highX, highY, lowX, highY);
                g.drawLine(lowX, highY, lowX, lowY);
                g.drawLine(lowX + 1, lowY + 1, highX - 1, lowY + 1);
                g.drawLine(highX - 1, lowY + 1, highX - 1, highY - 1);
                g.drawLine(highX - 1, highY - 1, lowX + 1, highY - 1);
                g.drawLine(lowX + 1, highY - 1, lowX + 1, lowY + 1);
            }
        }

        private void showString(Graphics g, String msg, int lowX, int highX, int lowY, int highY) {
            double txtWidth;
            double txtHeight;
            LineMetrics lm;
            GlyphVector gv;
            g.setColor(Color.BLACK);
            Font font = new Font(User.getDefaultFont(), 0, 9);
            g.setFont(font);
            FontRenderContext frc = new FontRenderContext(null, true, true);
            while (true) {
                gv = font.createGlyphVector(frc, msg);
                lm = font.getLineMetrics(msg, frc);
                txtHeight = lm.getHeight();
                Rectangle2D rasRect = gv.getLogicalBounds();
                txtWidth = rasRect.getWidth();
                if (txtWidth <= (double)(highX - lowX)) break;
                msg = msg.substring(0, msg.length() - 1);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.drawGlyphVector(gv, (float)((double)lowX + ((double)(highX - lowX) - txtWidth) / 2.0), (float)((double)(lowY + highY) + txtHeight) / 2.0f - lm.getDescent());
        }

        public void mousePressed(MouseEvent evt) {
            Dimension dim = this.getSize();
            int x = evt.getX() / (dim.width / ComponentMenu.this.menuWid);
            int y = ComponentMenu.this.menuHei - 1 - evt.getY() / (dim.height / ComponentMenu.this.menuHei);
            if (x < 0 || x >= ComponentMenu.this.menuWid || y < 0 || y >= ComponentMenu.this.menuHei) {
                return;
            }
            ComponentMenu.this.menuSelectedX = x;
            ComponentMenu.this.menuSelectedY = y;
            ComponentMenu.this.showSelected();
            this.repaint();
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }

    private class NodeFieldDocumentListener
    implements DocumentListener {
        private NodeFieldDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            ComponentMenu.this.nodeInfoChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            ComponentMenu.this.nodeInfoChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            ComponentMenu.this.nodeInfoChanged();
        }
    }

    private static class SetMenuJob
    extends Job {
        private String menuXML;

        private SetMenuJob(String menuXML) {
            super("Set Technology Library Component Menu", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.menuXML = menuXML;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Library.getCurrent().newVar(Info.COMPMENU_KEY, (Object)this.menuXML);
            return true;
        }
    }

    public static class ComponentMenuPreferences
    extends PrefPackage {
        private static final String KEY_COMPONENT_MENU = "ComponentMenuXMLfor";
        public Map<Technology, String> menuXmls = new HashMap<Technology, String>();

        public ComponentMenuPreferences(boolean factory) {
            super(factory);
            Preferences techPrefs = ComponentMenuPreferences.getPrefRoot().node("technology/technologies");
            Iterator<Technology> it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = it.next();
                String key = this.getKey(KEY_COMPONENT_MENU, tech.getId());
                String menuXml = techPrefs.get(key, "");
                this.menuXmls.put(tech, menuXml);
            }
        }

        public void putPrefs(Preferences prefRoot, boolean removeDefaults) {
            super.putPrefs(prefRoot, removeDefaults);
            Preferences techPrefs = prefRoot.node("technology/technologies");
            for (Map.Entry<Technology, String> e : this.menuXmls.entrySet()) {
                Technology tech = e.getKey();
                String key = this.getKey(KEY_COMPONENT_MENU, tech.getId());
                String menuXml = e.getValue();
                if (removeDefaults && menuXml.length() == 0) {
                    techPrefs.remove(key);
                    continue;
                }
                if (menuXml.length() < 8192) {
                    techPrefs.put(key, menuXml);
                    continue;
                }
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "XML description is too long (" + menuXml.length() + ").\n Preferences can't be stored", "Error saving XML preferences", 0);
            }
        }
    }
}

